/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.imports.AccessResult;
import com.puppycrawl.tools.checkstyle.checks.imports.ImportControlLoader;
import com.puppycrawl.tools.checkstyle.checks.imports.PkgControl;
import org.apache.commons.beanutils.ConversionException;

public class ImportControlCheck
extends Check {
    private PkgControl mRoot;
    private String mInPkg;
    private PkgControl mCurrentLeaf;

    public int[] getDefaultTokens() {
        return new int[]{16, 30, 152};
    }

    public void beginTree(DetailAST aRootAST) {
        this.mCurrentLeaf = null;
    }

    public void visitToken(DetailAST aAST) {
        FullIdent imp;
        AccessResult access;
        if (aAST.getType() == 16) {
            DetailAST nameAST = aAST.getLastChild().getPreviousSibling();
            FullIdent full = FullIdent.createFullIdent(nameAST);
            if (this.mRoot == null) {
                this.log(nameAST, "import.control.missing.file");
            } else {
                this.mInPkg = full.getText();
                this.mCurrentLeaf = this.mRoot.locateFinest(this.mInPkg);
                if (this.mCurrentLeaf == null) {
                    this.log(nameAST, "import.control.unknown.pkg");
                }
            }
        } else if (this.mCurrentLeaf != null && !AccessResult.ALLOWED.equals(access = this.mCurrentLeaf.checkAccess((imp = aAST.getType() == 30 ? FullIdent.createFullIdentBelow(aAST) : FullIdent.createFullIdent((DetailAST)aAST.getFirstChild().getNextSibling())).getText(), this.mInPkg))) {
            this.log(aAST, "import.control.disallowed", (Object)imp.getText());
        }
    }

    public void setFile(String aName) {
        if (aName == null || aName.trim().length() == 0) {
            return;
        }
        try {
            this.mRoot = ImportControlLoader.load(aName);
        }
        catch (CheckstyleException ex) {
            throw new ConversionException("Unable to load " + aName, ex);
        }
    }
}

