/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.j2ee;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.j2ee.AbstractJ2eeCheck;
import com.puppycrawl.tools.checkstyle.checks.j2ee.Utils;

public abstract class AbstractBeanCheck
extends AbstractJ2eeCheck {
    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    protected void checkBean(DetailAST aAST, String aBeanType, boolean aAllowAbstract) {
        DetailAST nameAST = aAST.findFirstToken(58);
        String name = nameAST.getText();
        String arg = aBeanType + " '" + name + "'";
        if (!Utils.isPublic(aAST)) {
            this.log(nameAST.getLineNo(), nameAST.getColumnNo(), "nonpublic.bean", (Object)arg);
        }
        if (Utils.isFinal(aAST)) {
            this.log(nameAST.getLineNo(), nameAST.getColumnNo(), "illegalmodifier.bean", new Object[]{arg, "final"});
        }
        if (!aAllowAbstract && Utils.isAbstract(aAST)) {
            this.log(nameAST.getLineNo(), nameAST.getColumnNo(), "illegalmodifier.bean", new Object[]{arg, "abstract"});
        }
        if (!Utils.hasPublicConstructor(aAST, 0)) {
            this.log(nameAST.getLineNo(), nameAST.getColumnNo(), "nonpublicconstructor.bean", (Object)arg);
        }
        if (Utils.hasPublicMethod(aAST, "finalize", true, 0)) {
            this.log(nameAST.getLineNo(), nameAST.getColumnNo(), "hasfinalize.bean", (Object)arg);
        }
    }
}

