/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.plugins.bluej;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.plugins.bluej.FileAuditor;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Auditor
implements AuditListener {
    private List<FileAuditor> mFileAuditors = null;
    private FileAuditor mCurrentFileAuditor;

    @Override
    public void auditStarted(AuditEvent aEvt) {
        this.mFileAuditors = new ArrayList<FileAuditor>();
    }

    @Override
    public void auditFinished(AuditEvent aEvt) {
    }

    @Override
    public void fileStarted(AuditEvent aEvt) {
        for (FileAuditor auditor : this.mFileAuditors) {
            if (!auditor.toString().equals(aEvt.getFileName())) continue;
            this.mCurrentFileAuditor = auditor;
            return;
        }
        this.mCurrentFileAuditor = new FileAuditor(aEvt);
        this.mFileAuditors.add(this.mCurrentFileAuditor);
    }

    @Override
    public void fileFinished(AuditEvent aEvt) {
    }

    @Override
    public void addError(AuditEvent aEvt) {
        this.mCurrentFileAuditor.addError(aEvt);
    }

    @Override
    public void addException(AuditEvent aEvt, Throwable aThrowable) {
        this.mCurrentFileAuditor.addException(aEvt, aThrowable);
    }

    public List<FileAuditor> getFileAuditors() {
        return this.mFileAuditors;
    }
}

