/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.UMLextension;

import bluej.extensions.BClass;
import bluej.extensions.BMethod;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.bluej.UMLextension.Preferences;
import org.bluej.UMLextension.UMLExtension;

class UMLDisplay
extends JFrame
implements MouseListener {
    private Color background = this.getBackground();
    private static final String[] UML_VIS = new String[]{"- ", "# ", "~", "+ "};
    private static final String[] JAVA_VIS = new String[]{"private ", "protected ", "", "public "};
    private static final int PRIVATE_IX = 0;
    private static final int PROTECTED_IX = 1;
    private static final int PACKAGE_IX = 2;
    private static final int PUBLIC_IX = 3;

    public UMLDisplay(Point location, BClass bc) {
        this.getBackgroundColor();
        this.setUndecorated(true);
        this.getContentPane().setBackground(this.background);
        JComponent jc = this.getContents(bc);
        this.getContentPane().add(jc);
        jc.addMouseListener(this);
        this.pack();
        int x = location.x;
        int y = location.y - this.getHeight() / 2;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (x + this.getWidth() > screenSize.width) {
            x = screenSize.width - this.getWidth();
        }
        if (x < 0) {
            x = 0;
        }
        if (y + this.getHeight() >= screenSize.height) {
            y = screenSize.height - this.getHeight() - 1;
        }
        if (y < 0) {
            y = 0;
        }
        this.setLocation(x, y);
        this.setVisible(true);
    }

    private JComponent getContents(BClass bc) {
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createLineBorder(Color.black, 3));
        try {
            int i;
            box.add(this.spacer());
            JComponent jc = this.getStereotype(bc.getJavaClass());
            if (jc != null) {
                box.add(jc);
            }
            JLabel jl = new JLabel(bc.getJavaClass().getName());
            jl.setFont(jl.getFont().deriveFont(1));
            Box inner = Box.createHorizontalBox();
            inner.add(Box.createHorizontalGlue());
            inner.add(Box.createHorizontalStrut(10));
            inner.add(jl);
            inner.add(Box.createHorizontalStrut(10));
            inner.add(Box.createHorizontalGlue());
            box.add(inner);
            if (Preferences.showAttributes) {
                ArrayList<JComponent> attribs = new ArrayList<JComponent>();
                Field[] fa = bc.getJavaClass().getDeclaredFields();
                for (i = 0; i < fa.length; ++i) {
                    if (!this.shouldShow(fa[i].getModifiers())) continue;
                    attribs.add(this.formatAttribute(fa[i]));
                }
                if (attribs.size() > 0) {
                    box.add(this.separator());
                    Iterator it = attribs.iterator();
                    while (it.hasNext()) {
                        box.add((JComponent)it.next());
                    }
                }
            }
            if (Preferences.showMethods) {
                ArrayList<JComponent> methods = new ArrayList<JComponent>();
                if (Preferences.showParams || Preferences.showVisibility) {
                    Constructor<?>[] bca = bc.getJavaClass().getDeclaredConstructors();
                    for (i = 0; i < bca.length; ++i) {
                        if (!this.shouldShow(bca[i].getModifiers())) continue;
                        methods.add(this.formatConstructor(bca[i]));
                    }
                }
                BMethod[] bma = bc.getDeclaredMethods();
                for (i = 0; i < bma.length; ++i) {
                    if (!this.shouldShow(bma[i].getModifiers())) continue;
                    methods.add(this.formatMethod(bma[i]));
                }
                if (methods.size() > 0) {
                    box.add(this.separator());
                    Iterator it = methods.iterator();
                    while (it.hasNext()) {
                        box.add((JComponent)it.next());
                    }
                }
            }
            box.add(this.spacer());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return box;
    }

    private boolean shouldShow(int modifiers) {
        return Preferences.showPrivates || !Modifier.isPrivate(modifiers);
    }

    private JComponent formatAttribute(Field b) {
        if (Preferences.useJavaSyntax) {
            return this.displayString(this.visibility(b.getModifiers()) + this.trim(this.getSimpleName(b.getType())) + " " + b.getName());
        }
        return this.displayString(this.visibility(b.getModifiers()) + b.getName() + ": " + this.trim(this.getSimpleName(b.getType())));
    }

    private JComponent formatConstructor(Constructor c) {
        return this.displayString(this.visibility(c.getModifiers()) + c.getName() + this.formatArgs(c.getParameterTypes()));
    }

    private JComponent formatMethod(BMethod bm) {
        if (Preferences.useJavaSyntax) {
            return this.displayString(this.visibility(bm.getModifiers()) + this.trim(this.getSimpleName(bm.getReturnType())) + " " + bm.getName() + this.formatArgs(bm.getParameterTypes()));
        }
        return this.displayString(this.visibility(bm.getModifiers()) + bm.getName() + this.formatArgs(bm.getParameterTypes()) + ": " + this.trim(this.getSimpleName(bm.getReturnType())));
    }

    private String formatArgs(Class[] args) {
        if (!Preferences.showParams) {
            return "";
        }
        String res = "(";
        for (int i = 0; i < args.length; ++i) {
            res = res + this.trim(this.getSimpleName(args[i]));
            if (i == args.length - 1) continue;
            res = res + ", ";
        }
        res = res + ")";
        return res;
    }

    private JComponent getStereotype(Class c) {
        String s = null;
        if (c.isInterface()) {
            s = "<<interface>>";
        } else if (Modifier.isAbstract(c.getModifiers())) {
            s = "<<abstract>>";
        }
        try {
            if (Class.forName("java.lang.Enum").isAssignableFrom(c)) {
                s = "<<enum>>";
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            if (Class.forName("junit.framework.TestCase").isAssignableFrom(c)) {
                s = "<<unit test>>";
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            if (Class.forName("java.applet.Applet").isAssignableFrom(c)) {
                s = "<<applet>>";
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (s == null) {
            return null;
        }
        Box inner = Box.createHorizontalBox();
        inner.add(Box.createHorizontalGlue());
        inner.add(Box.createHorizontalStrut(10));
        inner.add(new JLabel(s));
        inner.add(Box.createHorizontalStrut(10));
        inner.add(Box.createHorizontalGlue());
        return inner;
    }

    private JComponent separator() {
        Box b1 = Box.createVerticalBox();
        b1.add(this.spacer());
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createHorizontalGlue());
        b2.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        b1.add(b2);
        b1.add(this.spacer());
        return b1;
    }

    private JComponent spacer() {
        Box b = Box.createVerticalBox();
        b.add(Box.createVerticalStrut(4));
        return b;
    }

    private JComponent displayString(String content) {
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalStrut(10));
        JLabel jl = new JLabel(content);
        b.add(jl);
        b.add(Box.createHorizontalStrut(10));
        b.add(Box.createHorizontalGlue());
        return b;
    }

    private String trim(String s) {
        return s.substring(s.lastIndexOf(46) + 1);
    }

    private String visibility(int modifiers) {
        String[] vis = null;
        if (!Preferences.showVisibility) {
            return "";
        }
        vis = Preferences.useJavaSyntax ? JAVA_VIS : UML_VIS;
        if (Modifier.isPrivate(modifiers)) {
            return vis[0];
        }
        if (Modifier.isProtected(modifiers)) {
            return vis[1];
        }
        if ((modifiers & 7) == 0) {
            return vis[2];
        }
        return vis[3];
    }

    private String getSimpleName(Class c) {
        String name = c.getName();
        if (c.isArray()) {
            System.out.println("Array: \"" + name + "\"");
            int dimensions = 0;
            String type = null;
            int pos = 0;
            while (name.charAt(pos++) == '[') {
                ++dimensions;
            }
            switch (name.charAt(--pos)) {
                case 'Z': {
                    type = "boolean";
                    break;
                }
                case 'B': {
                    type = "byte";
                    break;
                }
                case 'C': {
                    type = "char";
                    break;
                }
                case 'L': {
                    type = name.substring(name.indexOf(76) + 1, name.indexOf(59));
                    break;
                }
                case 'D': {
                    type = "double";
                    break;
                }
                case 'F': {
                    type = "float";
                    break;
                }
                case 'I': {
                    type = "int";
                    break;
                }
                case 'J': {
                    type = "long";
                    break;
                }
                case 'S': {
                    type = "short";
                    break;
                }
                default: {
                    System.out.println("Type: '" + name.charAt(pos) + "'");
                    type = "???";
                }
            }
            name = type;
            for (int i = 0; i < dimensions; ++i) {
                name = name + "[]";
            }
        }
        return name;
    }

    private void getBackgroundColor() {
        String colorString = UMLExtension.bluej.getBlueJPropertyString("colour.class.bg.default", null);
        if ((colorString = UMLExtension.bluej.getExtensionPropertyString("background", colorString)) != null) {
            UMLExtension.bluej.setExtensionPropertyString("background", colorString);
            String[] rgbVal = colorString.split(",");
            if (rgbVal.length != 3) {
                System.out.println("Can't parse background color string \"" + colorString + "\"");
                return;
            }
            int r = 0;
            int g = 0;
            int b = 0;
            try {
                r = Integer.parseInt(rgbVal[0].trim());
                g = Integer.parseInt(rgbVal[1].trim());
                b = Integer.parseInt(rgbVal[2].trim());
            }
            catch (NumberFormatException e) {
                System.out.println("Can't parse background color string \"" + colorString + "\"");
                return;
            }
            this.background = new Color(r, g, b);
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.dispose();
        this.setVisible(false);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

