/*
 * Decompiled with CFR 0.152.
 */
package org.patterncoder;

import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class PatternImage
extends JPanel {
    public Image img;
    private Image scaledImg;
    private String path;

    public PatternImage() {
        super.setBorder(new EtchedBorder());
    }

    public void paint(Graphics g) {
        if (this.scaledImg != null) {
            g.drawImage(this.scaledImg, 0, 0, this);
        }
        super.paintBorder(g);
    }

    public void setImage(String path, int width, int height) {
        this.path = path;
        File temp = new File(path);
        try {
            if (temp.exists() && temp.canRead()) {
                this.img = ImageIO.read(temp);
                this.scaledImg = this.img.getScaledInstance(width, height, 4);
            } else {
                this.scaledImg = null;
            }
        }
        catch (IOException ioe) {
        }
        catch (Exception e) {
            // empty catch block
        }
        this.repaint();
    }

    public void setImage(String path) {
        this.path = path;
        File temp = new File(path);
        try {
            if (temp.exists() && temp.canRead()) {
                this.img = ImageIO.read(temp);
                this.scaledImg = this.img.getScaledInstance(this.getPanelWidth(), this.getPanelHeight(), 4);
            } else {
                this.scaledImg = null;
            }
        }
        catch (IOException ioe) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    private int getPanelWidth() {
        return super.getWidth();
    }

    private int getPanelHeight() {
        return super.getHeight();
    }
}

