/*
 * Decompiled with CFR 0.152.
 */
package org.patterncoder.pattern;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import org.patterncoder.ErrorHandler;
import org.patterncoder.PatternCoderException;
import org.patterncoder.pattern.PatternClass;
import org.patterncoder.source.PatternFileReader;
import org.patterncoder.source.PatternFileReaderDom;
import org.patterncoder.source.PatternSourceManager;
import org.patterncoder.source.XMLSourceHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternModel
extends Observable {
    private List<String> files = new ArrayList<String>();
    private List<String> patterns = new ArrayList<String>();
    private HashMap<Object, PatternClass> comps;
    private String curPattern = "";
    private int curIndex = 0;
    private String description = "";
    private String image = "";
    private PatternSourceManager sourceHandler;
    private PatternFileReader reader;

    public PatternModel() throws PatternCoderException {
        this.sourceHandler = XMLSourceHandler.getInstance();
        this.reader = new PatternFileReaderDom();
    }

    public PatternModel(PatternSourceManager edh, PatternFileReader pfr) {
        this.sourceHandler = edh;
        this.reader = pfr;
    }

    public void populateModel() throws FileNotFoundException, Exception {
        boolean index = false;
        this.files = this.sourceHandler.getSourceFiles();
        int length = this.files.size();
        for (int i = 0; i < length; ++i) {
            File tempFile = new File(this.files.get(i).toString());
            try {
                this.reader.parseFile(tempFile);
                if (this.reader.getPatternName() == null) continue;
                this.patterns.add(this.reader.getPatternName());
                continue;
            }
            catch (SAXException saxe) {
                System.out.println("A problem occured trying to validate" + tempFile);
                System.out.println(saxe.getMessage());
                continue;
            }
            catch (IOException e) {
                ErrorHandler.logErrorMsg("Problem reading file: " + tempFile);
            }
        }
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public File getCurrentSourceFile() {
        return new File(this.files.get(this.curIndex).toString());
    }

    public String getDescription() {
        return this.description;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    private void setImage(String image) throws Exception {
        if (image == null) {
            throw new Exception("No image file");
        }
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public void setCurrentPattern(String curPattern, int index) {
        try {
            this.curPattern = curPattern;
            this.curIndex = index;
            File temp = new File(this.files.get(this.curIndex).toString());
            this.reader.parseFile(temp);
            this.setDescription(this.reader.getPatternDesc());
            this.sourceHandler.getImage(this.reader.getPatternImage()).toString();
            this.setImage(this.sourceHandler.getImage(this.reader.getPatternImage()).toString());
            this.setComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void setComponents() {
        try {
            this.reader.parseFile(this.getCurrentSourceFile());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.comps = this.reader.getPatternComponents();
    }

    public HashMap<Object, PatternClass> getComponents() {
        return this.comps;
    }

    public PatternClass getPatternComp(Object id) {
        return this.comps.get(id);
    }

    public String getCurrentPatternName() {
        return this.curPattern;
    }
}

