/*
 * Decompiled with CFR 0.152.
 */
package org.patterncoder.source;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.patterncoder.PatternCoderException;
import org.patterncoder.pattern.PatternClass;
import org.patterncoder.pattern.PatternModel;
import org.patterncoder.source.PatternFileReader;
import org.patterncoder.source.PatternFileValidator;
import org.patterncoder.wizard.Wizard;
import org.patterncoder.wizard.WizardPanelDescriptor;
import org.patterncoder.wizard.panels.ClassPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternFileReaderDom
implements PatternFileReader {
    private PatternFileValidator validator;
    private DocumentBuilder parser;
    private Document xmlDoc;
    private final String PATTERN_TAG = "pattern";
    private final String PAT_NAME_TAG = "patternName";
    private final String PAT_DESC_TAG = "patternDescription";
    private final String PAT_IMG_TAG = "patternImage";
    private final String CLASS_TAG = "class";
    private final String CLASS_DESC = "classDescription";
    private final String CLASS_TEMPLATE = "classTemplate";
    private final String CLASS_DEF_NAME = "defaultName";
    private final String CLASS_ID = "classId";
    private final String DEPENDANT_CLASS = "dependantClass";
    private final String CLASS_TYPE = "compType";
    private final String WIZARD_TAG = "wizard";
    private final String WIZARD_STEP_TAG = "step";
    private final String STEP_TYPE = "type";
    private final String STEP_COMP_ID = "compId";
    private final String STEP_ID = "stepId";
    private final String STEP_NAME = "stepName";
    private final String STEP_DESC = "stepDesc";
    private final String STEP_NEXT = "nextStepId";
    private final String STEP_PREVIOUS = "previousStepId";

    public PatternFileReaderDom() throws PatternCoderException {
        try {
            this.validator = new PatternFileValidator();
            this.parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new PatternCoderException(pce.getMessage());
        }
        catch (SAXException saxe) {
            throw new PatternCoderException(saxe.getMessage());
        }
    }

    public PatternFileReaderDom(DocumentBuilder parser) {
        this.parser = parser;
    }

    @Override
    public void parseFile(File sourceFile) throws IOException, SAXException {
        this.validator.validateFile(sourceFile.toString());
        this.xmlDoc = this.parser.parse(sourceFile);
    }

    @Override
    public String getPatternName() {
        NodeList patternNode = this.xmlDoc.getElementsByTagName("pattern");
        NamedNodeMap patAtts = patternNode.item(0).getAttributes();
        Node name = patAtts.getNamedItem("patternName");
        return name.getNodeValue();
    }

    @Override
    public String getPatternDesc() {
        NodeList patternNode = this.xmlDoc.getElementsByTagName("pattern");
        Element patternTag = (Element)patternNode.item(0);
        Element desc = (Element)patternTag.getElementsByTagName("patternDescription").item(0);
        return ((Text)desc.getFirstChild()).getData().trim();
    }

    @Override
    public String getPatternImage() {
        NodeList patternNode = this.xmlDoc.getElementsByTagName("pattern");
        NamedNodeMap patAtts = patternNode.item(0).getAttributes();
        Node image = patAtts.getNamedItem("patternImage");
        return image.getNodeValue();
    }

    @Override
    public HashMap<Object, PatternClass> getPatternComponents() {
        NodeList classNode = this.xmlDoc.getElementsByTagName("class");
        Element classTag = (Element)classNode.item(0);
        HashMap<Object, PatternClass> patternComps = new HashMap<Object, PatternClass>();
        ArrayList<PatternClass> patternClasses = new ArrayList<PatternClass>();
        NodeList patternNode = this.xmlDoc.getElementsByTagName("pattern");
        Element pattern = (Element)patternNode.item(0);
        NodeList classNodes = pattern.getElementsByTagName("class");
        for (int i = 0; i < classNodes.getLength(); ++i) {
            Element comp = (Element)classNodes.item(i);
            Element desc = (Element)comp.getElementsByTagName("classDescription").item(0);
            String classDescription = ((Text)desc.getFirstChild()).getData().trim();
            NamedNodeMap classAtts = classNodes.item(i).getAttributes();
            Node template = classAtts.getNamedItem("classTemplate");
            Node name = classAtts.getNamedItem("defaultName");
            Node id = classAtts.getNamedItem("classId");
            Node compType = classAtts.getNamedItem("compType");
            PatternClass tempClass = new PatternClass(id.getNodeValue().toString(), compType.getNodeValue().toString(), template.getNodeValue().toString(), classDescription, name.getNodeValue().toString());
            Element patClass = (Element)classNodes.item(i);
            NodeList classInnerNodes = patClass.getElementsByTagName("dependantClass");
            for (int t = 0; t < classInnerNodes.getLength(); ++t) {
                NamedNodeMap depAtts = classInnerNodes.item(t).getAttributes();
                Node dep = depAtts.getNamedItem("value");
                tempClass.addDependancy(dep.getNodeValue().toString());
            }
            patternClasses.add(tempClass);
            patternComps.put(id.getNodeValue(), tempClass);
        }
        return patternComps;
    }

    @Override
    public List<WizardPanelDescriptor> getWizardDescriptors(Wizard parent, PatternModel model) {
        ArrayList<WizardPanelDescriptor> descriptors = new ArrayList<WizardPanelDescriptor>();
        NodeList patternNode = this.xmlDoc.getElementsByTagName("pattern");
        Element pattern = (Element)patternNode.item(0);
        NodeList wizardNode = pattern.getElementsByTagName("wizard");
        Element step = (Element)wizardNode.item(0);
        NodeList stepNodes = step.getElementsByTagName("step");
        for (int i = 0; i < stepNodes.getLength(); ++i) {
            NamedNodeMap stepAtts = stepNodes.item(i).getAttributes();
            Node type = stepAtts.getNamedItem("type");
            Node compId = stepAtts.getNamedItem("compId");
            Node stepId = stepAtts.getNamedItem("stepId");
            Node next = stepAtts.getNamedItem("nextStepId");
            Node previous = stepAtts.getNamedItem("previousStepId");
            Node stepName = stepAtts.getNamedItem("stepName");
            Node stepDesc = stepAtts.getNamedItem("stepDesc");
            String nextTemp = null;
            String previousTemp = null;
            nextTemp = next.getNodeValue() == "" ? null : next.getNodeValue().toString();
            previousTemp = previous.getNodeValue() == "" ? null : previous.getNodeValue().toString();
            WizardPanelDescriptor tempDescriptor = new WizardPanelDescriptor(stepId.getNodeValue(), nextTemp, previousTemp, stepName.getNodeValue().toString(), stepDesc.getNodeValue().toString(), new ClassPanel(parent, model, compId.getNodeValue()));
            descriptors.add(tempDescriptor);
        }
        return descriptors;
    }

    class ValidatorErrorHandler
    implements ErrorHandler {
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException("ERROR: " + sAXParseException.toString());
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
        }
    }
}

