/*
 * Decompiled with CFR 0.152.
 */
package org.patterncoder.wizard.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.patterncoder.PatternCoderException;
import org.patterncoder.PatternImage;
import org.patterncoder.pattern.PatternClass;
import org.patterncoder.pattern.PatternModel;
import org.patterncoder.util.NameVerifier;
import org.patterncoder.wizard.Wizard;
import org.patterncoder.wizard.panels.AbstractWizardPanel;

public class ClassPanel
extends AbstractWizardPanel {
    private PatternModel model;
    private PatternClass thisComp;
    private Object compId;
    private Wizard parent;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JLabel lblComp;
    private JLabel lblInfo;
    private JLabel lblName;
    private JLabel lblPatternName;
    private PatternImage patternImage1;
    private JPanel pnlComponent;
    private JLabel txtComponent;
    private JEditorPane txtInfo;
    private JTextField txtName;

    public ClassPanel(Wizard parent, PatternModel model, Object compId) {
        this.parent = parent;
        this.model = model;
        this.compId = compId;
        model.addObserver(this);
        this.thisComp = model.getPatternComp(compId);
        this.initComponents();
        this.setComponentFields();
    }

    private void initComponents() {
        this.pnlComponent = new JPanel();
        this.lblComp = new JLabel();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.txtComponent = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.lblInfo = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txtInfo = new JEditorPane();
        this.patternImage1 = new PatternImage();
        this.lblPatternName = new JLabel();
        this.setLayout(new GridBagLayout());
        this.pnlComponent.setLayout(new GridBagLayout());
        this.pnlComponent.setBorder(BorderFactory.createTitledBorder(""));
        this.pnlComponent.setToolTipText("Rename");
        this.pnlComponent.setPreferredSize(new Dimension(376, 187));
        this.lblComp.setFont(new Font("Arial", 1, 12));
        this.lblComp.setText("Component:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 18, 0, 0);
        this.pnlComponent.add((Component)this.lblComp, gridBagConstraints);
        this.lblName.setFont(new Font("Arial", 1, 12));
        this.lblName.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 24;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 18, 0, 0);
        this.pnlComponent.add((Component)this.lblName, gridBagConstraints);
        this.txtName.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ClassPanel.this.txtNameKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 230;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 10, 0, 20);
        this.pnlComponent.add((Component)this.txtName, gridBagConstraints);
        this.txtComponent.setText("comp");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(14, 12, 0, 20);
        this.pnlComponent.add((Component)this.txtComponent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(9, 20, 81, 0);
        this.pnlComponent.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = -7;
        gridBagConstraints.ipady = -16;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(13, 9, 0, 13);
        this.add((Component)this.pnlComponent, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(""));
        this.lblInfo.setFont(new Font("Arial", 1, 12));
        this.lblInfo.setText("Component Role:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 481;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(13, 10, 0, 16);
        this.jPanel1.add((Component)this.lblInfo, gridBagConstraints);
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jScrollPane1.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(153, 153, 153)));
        this.jScrollPane1.setFont(new Font("Arial", 0, 10));
        this.txtInfo.setEditable(false);
        this.txtInfo.setContentType("text/html");
        this.txtInfo.setBackground(new Color(255, 255, 255));
        this.jScrollPane1.setViewportView(this.txtInfo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 557;
        gridBagConstraints.ipady = 97;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 10, 10, 10);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = -30;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 10, 17, 13);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.patternImage1.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                ClassPanel.this.patternImage1ComponentResized(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 217;
        gridBagConstraints.ipady = 157;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(13, 10, 0, 0);
        this.add((Component)this.patternImage1, gridBagConstraints);
        this.lblPatternName.setFont(new Font("Tahoma", 1, 14));
        this.lblPatternName.setText("Design Pattern name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 425;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 20, 0, 0);
        this.add((Component)this.lblPatternName, gridBagConstraints);
    }

    private void txtNameKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            if (this.parent.getWizardModel().getCurrentPanelDesc().getNextPanelID() == null) {
                this.parent.finish();
            } else {
                this.parent.next();
            }
        }
    }

    private void patternImage1ComponentResized(ComponentEvent evt) {
        this.setImage(this.model.getImage());
    }

    public void update(Observable t, Object o) {
        this.setImage(this.model.getImage());
    }

    private void setImage(String s) {
        this.patternImage1.setImage(s);
    }

    private void setComponentFields() {
        this.lblPatternName.setText(this.model.getCurrentPatternName() + " Pattern");
        this.txtComponent.setText(this.thisComp.getCompType());
        this.txtName.setText(this.thisComp.getName());
        this.txtInfo.setText("<style type=\"text/css\">body {font-size: 12pt; font-family: san-serif;color: #008800 }</style><body>" + this.thisComp.getDescription() + "</body>");
        try {
            this.txtInfo.setCaretPosition(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closingPanel() throws PatternCoderException {
        if (!NameVerifier.verifyName(this.txtName.getText())) {
            throw new PatternCoderException("The name you have entered is invalid. \nPlease enter a valid name to proceed");
        }
        this.model.getPatternComp(this.compId).setClassName(this.txtName.getText());
    }

    public void displayingPanel() throws PatternCoderException {
    }
}

