/*
 * Decompiled with CFR 0.152.
 */
package org.patterncoder;

import bluej.extensions.BPackage;
import bluej.extensions.BlueJ;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import java.io.File;

public class BlueJHandler {
    private static BlueJHandler singleton = null;
    public static BlueJ thisBlueJ = null;

    private BlueJHandler() {
    }

    public static synchronized BlueJHandler getInstance() {
        if (singleton == null) {
            singleton = new BlueJHandler();
        }
        return singleton;
    }

    public synchronized void setBlueJ(BlueJ thisBlueJ) {
        BlueJHandler.thisBlueJ = thisBlueJ;
    }

    public File getUserConfigDir() {
        return thisBlueJ.getUserConfigDir();
    }

    public File getBlueJDir() {
        return thisBlueJ.getSystemLibDir();
    }

    public File getProjectDir() throws ProjectNotOpenException {
        return thisBlueJ.getCurrentPackage().getProject().getDir();
    }

    public File getCurrentPackageDir() throws ProjectNotOpenException, PackageNotFoundException {
        return this.getCurrentPackage().getDir();
    }

    private BPackage getCurrentPackage() {
        return thisBlueJ.getCurrentPackage();
    }

    public String getCurrentPackageName() throws ProjectNotOpenException, PackageNotFoundException {
        return thisBlueJ.getCurrentPackage().getName();
    }

    public void addClass(String className) {
        try {
            thisBlueJ.getCurrentPackage().newClass(className);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void reload() {
        try {
            thisBlueJ.getCurrentPackage().reload();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

