/*
 * Decompiled with CFR 0.152.
 */
package org.patterncoder;

import bluej.extensions.BPackage;
import bluej.extensions.BlueJ;
import bluej.extensions.Extension;
import bluej.extensions.MenuGenerator;
import bluej.extensions.event.PackageEvent;
import bluej.extensions.event.PackageListener;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.patterncoder.ErrorHandler;
import org.patterncoder.PatternCoderException;
import org.patterncoder.PatternCoderFrame;

public class PatternCoder
extends Extension
implements PackageListener {
    public static final String VERSION = "0.5.2.003";
    public static final String NAME = "PatternCoder";
    public static final String DESCRIPTION = "Design patterns extension for BlueJ, developed at Glasgow Caledonian University and The University of the West of Scotland";
    public static final String EXT_URL = "http://www.patterncoder.org";
    private PatternCoderFrame patFrame;
    private BlueJ bluej;

    public void startup(BlueJ bluej) {
        System.setProperty("debug", "true");
        this.bluej = bluej;
        bluej.setMenuGenerator((MenuGenerator)new PatternCoderMenuGenerator());
        bluej.addPackageListener((PackageListener)this);
    }

    public void packageOpened(PackageEvent ev) {
    }

    public void packageClosing(PackageEvent ev) {
    }

    public boolean isCompatible() {
        return true;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getName() {
        return NAME;
    }

    public void terminate() {
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public URL getURL() {
        try {
            return new URL(EXT_URL);
        }
        catch (Exception urlExce) {
            ErrorHandler.logErrorMsg("URL Exception" + urlExce.getMessage());
            return null;
        }
    }

    class PatternCoderMenuGenerator
    extends MenuGenerator {
        PatternCoderMenuGenerator() {
        }

        public JMenuItem getToolsMenuItem(BPackage aPackage) {
            return new JMenuItem(new PatternAction(PatternCoder.NAME, "Tools menu:"));
        }

        public void notifyPostToolsMenu(BPackage bp, JMenuItem jmi) {
            if (bp == null) {
                jmi.setEnabled(false);
            }
        }

        class PatternAction
        extends AbstractAction {
            private String msgHeader;

            public PatternAction(String menuName, String msg) {
                this.putValue("Name", menuName);
                this.msgHeader = msg;
            }

            public void actionPerformed(ActionEvent anEvent) {
                try {
                    PatternCoder.this.patFrame = new PatternCoderFrame(PatternCoder.this.bluej);
                    PatternCoder.this.patFrame.setVisible(true);
                }
                catch (PatternCoderException pce) {
                    ErrorHandler.printErrorMsg("A problem occured whilst validating one or more XML files.\nPlease make sure that the schema document is present in the correct directory.");
                    ErrorHandler.logErrorMsg("PatternCoder Error:\n" + pce.getMessage());
                }
                catch (FileNotFoundException fnfe) {
                    ErrorHandler.printErrorMsg("Unable to open pattern source directory.\n\nPlease ensure PatternFiles folder is located in the extensions directory.");
                    ErrorHandler.logErrorMsg(fnfe.getMessage());
                }
                catch (Exception e) {
                    ErrorHandler.printErrorMsg("A problem has occured and the PatternCoder extension could not open correctly\nPlease ensure that all pattern source files are in the correct directory and adhere to the correct schema document.\nPlease also ensure that the schema document itself is present in the correct directory.");
                    ErrorHandler.logErrorMsg(e.getMessage());
                }
            }
        }
    }
}

