/*
 * Decompiled with CFR 0.152.
 */
package org.patterncoder;

import bluej.extensions.BlueJ;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.patterncoder.BlueJHandler;
import org.patterncoder.ErrorHandler;
import org.patterncoder.PatternCoderException;
import org.patterncoder.pattern.PatternImplementer;
import org.patterncoder.pattern.PatternModel;
import org.patterncoder.source.PatternFileReader;
import org.patterncoder.source.PatternFileReaderDom;
import org.patterncoder.wizard.Wizard;
import org.patterncoder.wizard.WizardModel;
import org.patterncoder.wizard.WizardPanelDescriptor;
import org.patterncoder.wizard.panels.PatternChooser;
import org.xml.sax.SAXException;

public class PatternCoderFrame
extends JFrame
implements Wizard,
Observer {
    private JPanel patChooser;
    private PatternModel model;
    private PatternImplementer pi;
    private CardLayout cardLayout;
    private WizardModel wModel;
    private PatternFileReader reader;
    private WizardPanelDescriptor chooserPanel;
    private static final String PAT_CHOICE_PANEL_ID = "ChoicePanel";
    private JButton btnBack;
    private JButton btnCancel;
    private JButton btnFinish;
    private JButton btnNext;
    private JPanel displayPanel;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JPanel navigationPanel;
    private JSeparator panelSeperator;
    private JPanel titlePanel;
    private JLabel txtStep;
    private JLabel txtStepDesc;

    public PatternCoderFrame(BlueJ bluej) throws FileNotFoundException, PatternCoderException, Exception {
        this.initComponents();
        this.setLocation(200, 100);
        this.wModel = new WizardModel();
        BlueJHandler.getInstance().setBlueJ(bluej);
        this.model = new PatternModel();
        this.model.populateModel();
        this.setStaticPanels();
        this.model.addObserver(this);
        this.setDynamicPanels();
    }

    private void initComponents() {
        this.cardLayout = new CardLayout();
        this.displayPanel = new JPanel();
        this.navigationPanel = new JPanel();
        this.panelSeperator = new JSeparator();
        this.btnCancel = new JButton();
        this.btnBack = new JButton();
        this.btnNext = new JButton();
        this.btnFinish = new JButton();
        this.jPanel1 = new JPanel();
        this.titlePanel = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.txtStep = new JLabel();
        this.txtStepDesc = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle("PatternCoder for BlueJ");
        this.setIconImage(new ImageIcon(PatternCoderFrame.class.getResource("patterncoder.gif")).getImage());
        this.displayPanel.setLayout(new GridBagLayout());
        this.displayPanel.setLayout(this.cardLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 650;
        gridBagConstraints.ipady = 390;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.displayPanel, gridBagConstraints);
        this.navigationPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 779;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.navigationPanel.add((Component)this.panelSeperator, gridBagConstraints);
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PatternCoderFrame.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 30, 7, 10);
        this.navigationPanel.add((Component)this.btnCancel, gridBagConstraints);
        this.btnBack.setText("< Back");
        this.btnBack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PatternCoderFrame.this.btnBackActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 10, 7, 0);
        this.navigationPanel.add((Component)this.btnBack, gridBagConstraints);
        this.btnNext.setText("Next >");
        this.btnNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PatternCoderFrame.this.btnNextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.ipadx = 13;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 7, 0);
        this.navigationPanel.add((Component)this.btnNext, gridBagConstraints);
        this.btnFinish.setText("Finish");
        this.btnFinish.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PatternCoderFrame.this.btnFinishActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.ipadx = 21;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 7, 0);
        this.navigationPanel.add((Component)this.btnFinish, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 250;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 100, 0, 0);
        this.navigationPanel.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = -129;
        gridBagConstraints.ipady = -1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.navigationPanel, gridBagConstraints);
        this.titlePanel.setLayout(new GridBagLayout());
        this.titlePanel.setBackground(new Color(255, 255, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 779;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(14, 0, 0, 0);
        this.titlePanel.add((Component)this.jSeparator1, gridBagConstraints);
        this.txtStep.setFont(new Font("Tahoma", 1, 12));
        this.txtStep.setText("txtStep");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 472;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 20, 0, 100);
        this.titlePanel.add((Component)this.txtStep, gridBagConstraints);
        this.txtStepDesc.setText("txtStepDesc");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 411;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 70, 0, 100);
        this.titlePanel.add((Component)this.txtStepDesc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = -129;
        gridBagConstraints.ipady = -1;
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.titlePanel, gridBagConstraints);
        this.setBounds(0, 0, 659, 522);
    }

    private void btnBackActionPerformed(ActionEvent evt) {
        this.back();
    }

    private void btnNextActionPerformed(ActionEvent evt) {
        this.next();
    }

    private void btnFinishActionPerformed(ActionEvent evt) {
        this.finish();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    public void update(Observable t, Object o) {
        this.setDynamicPanels();
    }

    public WizardModel getWizardModel() {
        return this.wModel;
    }

    private void setButtonStatus() {
        if (this.wModel.getCurrentPanelDesc().getNextPanelID() == null) {
            this.btnNext.setVisible(false);
            this.btnFinish.setVisible(true);
        } else {
            this.btnNext.setVisible(true);
            this.btnFinish.setVisible(false);
        }
        if (this.wModel.getCurrentPanelDesc().getPreviousPanelID() == null) {
            this.btnBack.setEnabled(false);
        } else {
            this.btnBack.setEnabled(true);
        }
    }

    private void setWizardTitle(String step, String stepDesc) {
        this.txtStep.setText(step);
        this.txtStepDesc.setText(stepDesc);
    }

    private void registerWizardPanel(Object id, WizardPanelDescriptor panel) {
        this.displayPanel.add((Component)panel.getPanel(), id);
        this.wModel.registerWizardPanel(id, panel);
    }

    private void setCurrentPanel(Object id) {
        if (id == null) {
            ErrorHandler.printErrorMsg("Unable to display wizard panel");
        }
        this.wModel.setCurrentPanelDesc(id);
        this.cardLayout.show(this.displayPanel, id.toString());
        int t = this.wModel.getCurrentPanelDesc().getStepNumber();
        int tt = this.wModel.totalNum();
        this.setWizardTitle(this.wModel.getCurrentPanelDesc().getStep() + " (Step " + t + " of " + tt + ")", this.wModel.getCurrentPanelDesc().getStepDesc());
    }

    private void setStaticPanels() {
        this.chooserPanel = new WizardPanelDescriptor(PAT_CHOICE_PANEL_ID, null, null, "Select design pattern", "Select the design pattern you wish to adopt and click next.", new PatternChooser(this.model));
        this.registerWizardPanel(this.chooserPanel.getPanelID(), this.chooserPanel);
    }

    public void setDynamicPanels() {
        for (int i = 0; i < this.displayPanel.getComponentCount(); ++i) {
            Component tempComp = this.displayPanel.getComponent(i);
            if (tempComp.equals(this.chooserPanel.getPanel())) continue;
            this.displayPanel.remove(i);
        }
        this.wModel.clearWizardModel();
        try {
            this.reader = new PatternFileReaderDom();
        }
        catch (Exception e) {
            ErrorHandler.printErrorMsg("An error occured creating file reader object\nThe extension will now close.");
            System.out.println(e.getMessage());
            this.exitExtension();
        }
        try {
            this.reader.parseFile(this.model.getCurrentSourceFile());
        }
        catch (IOException ioe) {
            ErrorHandler.printErrorMsg("The source file for this pattern can not be found" + this.model.getCurrentSourceFile() + ioe.toString());
            System.out.println(ioe.getMessage());
            this.exitExtension();
        }
        catch (SAXException saxe) {
            ErrorHandler.printErrorMsg("The source file for this pattern may have been changed since the extension was loaded.\nAll pattern source files must conform to a schema. Please ensure that all files do so.\nThe extension will now exit.");
            System.out.println(saxe.getMessage());
            this.exitExtension();
        }
        ArrayList<WizardPanelDescriptor> descriptors = new ArrayList<WizardPanelDescriptor>(this.reader.getWizardDescriptors(this, this.model));
        for (int i = 0; i < descriptors.size(); ++i) {
            if (((WizardPanelDescriptor)descriptors.get(i)).getPreviousPanelID() == null) {
                ((WizardPanelDescriptor)descriptors.get(i)).setPreviousID(PAT_CHOICE_PANEL_ID);
                this.chooserPanel.setNextPanelID(((WizardPanelDescriptor)descriptors.get(i)).getPanelID());
            }
            this.registerWizardPanel(((WizardPanelDescriptor)descriptors.get(i)).getPanelID(), (WizardPanelDescriptor)descriptors.get(i));
        }
        this.setCurrentPanel(PAT_CHOICE_PANEL_ID);
        this.setButtonStatus();
    }

    public void next() {
        try {
            this.wModel.getCurrentPanelDesc().closingPanel();
            this.setCurrentPanel(this.wModel.getCurrentPanelDesc().getNextPanelID());
            this.setButtonStatus();
        }
        catch (PatternCoderException bdpe) {
            ErrorHandler.printWarningMsg(bdpe.getMessage());
        }
    }

    public void back() {
        this.setCurrentPanel(this.wModel.getCurrentPanelDesc().getPreviousPanelID());
        this.setButtonStatus();
    }

    public void finish() {
        try {
            this.wModel.getCurrentPanelDesc().closingPanel();
            this.pi = new PatternImplementer();
            this.pi.usePattern(this.model.getComponents());
            this.exitExtension();
        }
        catch (PatternCoderException bdpe) {
            ErrorHandler.printWarningMsg(bdpe.getMessage());
        }
        catch (IOException ioe) {
            ErrorHandler.printErrorMsg("A file required to implement the pattern is missing.\nPlease ensure that all template files are in the correct directory and match the names in the pattern source file.");
            ErrorHandler.logErrorMsg(ioe.getMessage());
            this.exitExtension();
        }
        catch (ProjectNotOpenException pnoe) {
            ErrorHandler.printErrorMsg("A problem occured trying to add classes to the current project.\nPlease make sure there is a project open.");
            ErrorHandler.logErrorMsg(pnoe.getMessage());
            this.exitExtension();
        }
        catch (PackageNotFoundException pnfe) {
            ErrorHandler.printErrorMsg("A problem occured trying to find the package selected.");
            ErrorHandler.logErrorMsg(pnfe.getMessage());
            this.exitExtension();
        }
        catch (Exception e) {
            ErrorHandler.printErrorMsg("A general exception has occured and the pattern could not be implemented.");
            ErrorHandler.logErrorMsg(e.getMessage());
            this.exitExtension();
        }
    }

    public void cancel() {
        this.exitExtension();
    }

    private void exitExtension() {
        this.dispose();
    }
}

