/*
 * Decompiled with CFR 0.152.
 */
package org.patterncoder.pattern;

import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.patterncoder.BlueJHandler;
import org.patterncoder.pattern.PatternClass;
import org.patterncoder.source.PatternSourceManager;
import org.patterncoder.source.XMLSourceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternImplementer {
    private PatternSourceManager psm;
    private final String CLASS_NAME_STRING = "\\$CLASSNAME";
    private final String DEPENDANT_CLASS = "\\$DEPENDANT";
    private final String PACKAGE_NAME = "\\$PKGLINE";
    private ArrayList<PatternClass> components;

    public PatternImplementer() {
        this.psm = XMLSourceHandler.getInstance();
    }

    public PatternImplementer(PatternSourceManager psm, BlueJHandler bjh) {
        this.psm = psm;
    }

    public void usePattern(HashMap<Object, PatternClass> classes) throws IOException, ProjectNotOpenException, PackageNotFoundException {
        this.components = new ArrayList();
        Iterator<Object> iter = classes.keySet().iterator();
        while (iter.hasNext()) {
            this.components.add(classes.get(iter.next()));
        }
        for (int i = 0; i < classes.size(); ++i) {
            PatternClass pc = this.components.get(i);
            String template = pc.getTemplate();
            String className = pc.getName();
            this.createSourceFile(new File(BlueJHandler.getInstance().getCurrentPackageDir(), className + ".java"), this.psm.getClassTemplate(template), className, pc.getDependants());
        }
        this.reloadPackage();
    }

    private void createSourceFile(File destination, File sourceTemplate, String className, List<String> deps) throws IOException, ProjectNotOpenException, PackageNotFoundException {
        Pattern classNamePattern = Pattern.compile("\\$CLASSNAME");
        Pattern packageNamePattern = Pattern.compile("\\$PKGLINE");
        String output = "";
        ArrayList<String> deps2 = new ArrayList<String>(deps);
        FileInputStream fis = new FileInputStream(sourceTemplate);
        FileChannel fc = fis.getChannel();
        MappedByteBuffer bbuf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fc.size());
        CharBuffer cbuf = Charset.forName("8859_1").newDecoder().decode(bbuf);
        Matcher matcher = classNamePattern.matcher(cbuf);
        output = matcher.replaceAll(className);
        matcher = packageNamePattern.matcher(output);
        output = BlueJHandler.getInstance().getCurrentPackageName().compareTo("") != 0 ? matcher.replaceAll("package " + BlueJHandler.getInstance().getCurrentPackageName() + ";") : matcher.replaceAll("");
        if (!deps2.isEmpty()) {
            for (int i = 0; i < deps2.size(); ++i) {
                String temp = "\\$DEPENDANT".concat(deps2.get(i));
                Pattern classDepPat = Pattern.compile(temp);
                matcher = classDepPat.matcher(output);
                for (int t = 0; t < this.components.size(); ++t) {
                    PatternClass temp2 = this.components.get(t);
                    String classDep = String.valueOf(temp2.getId());
                    if (deps2.get(i).compareTo(classDep) != 0) continue;
                    output = matcher.replaceAll(temp2.getName());
                }
            }
        }
        FileWriter out = new FileWriter(destination);
        String newOutput = output.concat("\n\n/*\n *Source file generated by patternCoder for BlueJ Version 0.5.1.002.\n *For more info, please visit http://www.patterncoder.org.\n */");
        out.write(newOutput);
        fis.close();
        out.close();
        this.addClass(className);
    }

    private void addClass(String className) {
        BlueJHandler.getInstance().addClass(className);
    }

    private void reloadPackage() {
        BlueJHandler.getInstance().reload();
    }
}

