/*
 * Decompiled with CFR 0.152.
 */
package org.patterncoder.source;

import java.io.File;
import java.io.IOException;
import java.text.StringCharacterIterator;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PatternFileValidator {
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String MAC_COMPONENT = "BlueJ.app/Contents/Resources/Java/extensions/patternfiles";
    static final String PC_COMPONENT = "lib/extensions/patternfiles";
    static final String SCHEMA_XSD = "patternschema.xsd";
    private Schema schema;
    private Validator validator;

    public PatternFileValidator() throws SAXException {
        String curDir = System.getProperty("user.dir");
        File curDirFile = null;
        String arch = System.getProperty("os.name");
        curDirFile = arch.toLowerCase().startsWith("mac") ? new File(curDir, MAC_COMPONENT) : new File(curDir, PC_COMPONENT);
        File schemaSourceFile = new File(curDirFile, SCHEMA_XSD);
        String schemaSource = "";
        try {
            schemaSource = schemaSourceFile.toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.schema = PatternFileValidator.compileSchema(schemaSource);
        this.validator = this.schema.newValidator();
        this.validator.setErrorHandler(new ValidatorErrorHandler());
    }

    public static Schema compileSchema(String schema) throws SAXException {
        SchemaFactory sf = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        return sf.newSchema(new File(schema));
    }

    public void validateFile(String sourcefile) throws SAXException, IOException {
        sourcefile = this.replaceSpaces(sourcefile);
        this.validator.validate(new StreamSource(sourcefile));
    }

    private String replaceSpaces(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == ' ') {
                result.append("%20");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    class ValidatorErrorHandler
    implements ErrorHandler {
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException("ERROR: " + sAXParseException.toString());
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException("Fatal ERROR: " + sAXParseException.toString());
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException("Warning: " + sAXParseException.toString());
        }
    }
}

