/*
 * Decompiled with CFR 0.152.
 */
package org.patterncoder.source;

import bluej.extensions.ProjectNotOpenException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.patterncoder.BlueJHandler;
import org.patterncoder.ErrorHandler;
import org.patterncoder.source.PatternFileValidator;
import org.patterncoder.source.PatternSourceManager;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLSourceHandler
implements PatternSourceManager {
    private static XMLSourceHandler singleton = null;
    private PatternFileValidator validator;
    private File extensionDir;
    private final String EXTENSION_DIR_NAME = "extensions";
    private final String PATTERN_FILES_DIR_NAME = "patternfiles";
    private final String CLASS_TEMPLATES = "templates";
    private final String IMG_DIR = "images";
    private final String PAT_FILE_EXTENSION = ".xml";

    private XMLSourceHandler() {
    }

    public static synchronized XMLSourceHandler getInstance() {
        if (singleton == null) {
            singleton = new XMLSourceHandler();
        }
        return singleton;
    }

    @Override
    public File getImage(String image) throws FileNotFoundException {
        return new File(this.getImageDir(), image);
    }

    @Override
    public ArrayList<String> getSourceFiles() throws FileNotFoundException, Exception {
        this.validator = new PatternFileValidator();
        ArrayList<String> sources = new ArrayList<String>();
        String extDir = this.getExtensionDir() + System.getProperties().getProperty("file.separator");
        String[] temp = this.getExtensionDir().list();
        for (int i = 0; i < temp.length; ++i) {
            if (!temp[i].endsWith(".xml")) continue;
            try {
                this.validator.validateFile(extDir + temp[i]);
                sources.add(extDir + temp[i]);
                continue;
            }
            catch (SAXException saxe) {
                ErrorHandler.logErrorMsg("Could not validate file " + extDir + temp[i] + saxe.getMessage());
            }
        }
        return sources;
    }

    @Override
    public File getClassTemplate(String template) throws FileNotFoundException {
        return new File(this.getTemplateDir(), template);
    }

    private File getImageDir() throws FileNotFoundException {
        return new File(this.getExtensionDir(), "images");
    }

    private File getTemplateDir() throws FileNotFoundException {
        return new File(this.getExtensionDir(), "templates");
    }

    private File getExtensionDir() throws FileNotFoundException {
        this.extensionDir = this.findExtensionDir();
        return this.extensionDir;
    }

    private File findExtensionDir() throws FileNotFoundException {
        File f1 = new File(BlueJHandler.getInstance().getBlueJDir(), "extensions/patternfiles");
        if (f1.exists()) {
            return f1;
        }
        f1 = new File(BlueJHandler.getInstance().getUserConfigDir(), "extensions/patternfiles");
        if (f1.exists()) {
            return f1;
        }
        try {
            f1 = new File(BlueJHandler.getInstance().getProjectDir(), "extensions/patternfiles");
        }
        catch (ProjectNotOpenException exc) {
            System.out.println((Object)((Object)exc) + "Project not open");
        }
        if (f1.exists()) {
            return f1;
        }
        throw new FileNotFoundException("Unable to find Patterns directory");
    }
}

