/*
 * Decompiled with CFR 0.152.
 */
package kr.or.bluej.cw.extension;

import bluej.extensions.BlueJ;
import bluej.extensions.PreferenceGenerator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import kr.or.bluej.cw.styler.CodeFormatter;

class Preferences
implements PreferenceGenerator {
    private String style;
    private JTextPane stylePane;
    private static final String STYLE_1 = "BlueJ style";
    private static final String STYLE_2 = "BlueJ style and indent brace";
    private static final String STYLE_3 = "Trail brace in the end of the lines";
    private JPanel panel;
    private JPanel RBPanel;
    private JRadioButton rbtnBraceStyle1;
    private JRadioButton rbtnBraceStyle2;
    private JRadioButton rbtnBraceStyle3;
    private ButtonGroup group = new ButtonGroup();
    private BlueJ bluej;
    public static final String CURR_STYLE = "";
    private static String strCodeStyle;

    public Preferences(BlueJ bluej) {
        this.initStyle();
        this.stylePane = this.getJTextPane();
        this.bluej = bluej;
        this.rbtnBraceStyle1 = this.getJRadioButton(STYLE_1);
        this.rbtnBraceStyle2 = this.getJRadioButton(STYLE_2);
        this.rbtnBraceStyle3 = this.getJRadioButton(STYLE_3);
        this.group.add(this.rbtnBraceStyle1);
        this.group.add(this.rbtnBraceStyle2);
        this.group.add(this.rbtnBraceStyle3);
        this.RBPanel = new JPanel();
        this.RBPanel.add(this.rbtnBraceStyle1);
        this.RBPanel.add(this.rbtnBraceStyle2);
        this.RBPanel.add(this.rbtnBraceStyle3);
        this.RBPanel.setBorder(new TitledBorder("CodeStyle"));
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.RBPanel, "North");
        this.panel.add((Component)this.stylePane, "Center");
        strCodeStyle = CURR_STYLE;
        this.loadValues();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void initStyle() {
        this.style = "/**\n* An example of a method - replace this comment with your own\n* @param  y   a sample parameter for a method\n* @return     the sum of x and y\n*/\npublic int sampleMethod(int y){\n// put your code here\nreturn x + y;\n}";
    }

    public void setStyleText(String strStyle) {
        if (strStyle.equals(STYLE_1)) {
            CodeFormatter.setBRACKET_BREAK(true);
            CodeFormatter.setBRACKET_INDENT(false);
            this.stylePane.setText(CodeFormatter.format(this.style));
        } else if (strStyle.equals(STYLE_3)) {
            CodeFormatter.setBRACKET_BREAK(false);
            CodeFormatter.setBRACKET_INDENT(false);
            this.stylePane.setText(CodeFormatter.format(this.style));
        } else if (strStyle.equals(STYLE_2)) {
            CodeFormatter.setBRACKET_BREAK(true);
            CodeFormatter.setBRACKET_INDENT(true);
            this.stylePane.setText(CodeFormatter.format(this.style));
        }
        CodeFormatter.setBRACKET_BREAK(false);
        CodeFormatter.setBRACKET_INDENT(false);
    }

    private JTextPane getJTextPane() {
        if (this.stylePane == null) {
            this.stylePane = new JTextPane();
            this.stylePane.setBackground(Color.LIGHT_GRAY);
            this.stylePane.setBorder(new TitledBorder(new EtchedBorder()));
            this.stylePane.setEditable(false);
        }
        return this.stylePane;
    }

    public JRadioButton getJRadioButton(String name) {
        JRadioButton newRButton = new JRadioButton(name);
        class RButtonListener
        implements ActionListener {
            private final /* synthetic */ String val$name;

            RButtonListener(String val$name) {
                this.val$name = val$name;
            }

            public void actionPerformed(ActionEvent event) {
                if (this.val$name.equals(Preferences.STYLE_1)) {
                    Preferences.this.setStyleText(Preferences.STYLE_1);
                    Preferences.this.stylePane.repaint();
                } else if (this.val$name.equals(Preferences.STYLE_2)) {
                    Preferences.this.setStyleText(Preferences.STYLE_2);
                    Preferences.this.stylePane.repaint();
                } else if (this.val$name.equals(Preferences.STYLE_3)) {
                    Preferences.this.setStyleText(Preferences.STYLE_3);
                    Preferences.this.stylePane.repaint();
                }
            }
        }
        RButtonListener listener = new RButtonListener(name);
        newRButton.addActionListener(listener);
        return newRButton;
    }

    public void saveValues() {
        if (this.rbtnBraceStyle1.isSelected()) {
            this.bluej.setExtensionPropertyString(CURR_STYLE, STYLE_1);
        } else if (this.rbtnBraceStyle2.isSelected()) {
            this.bluej.setExtensionPropertyString(CURR_STYLE, STYLE_2);
        } else if (this.rbtnBraceStyle3.isSelected()) {
            this.bluej.setExtensionPropertyString(CURR_STYLE, STYLE_3);
        }
    }

    public void loadValues() {
        strCodeStyle = this.bluej.getExtensionPropertyString(CURR_STYLE, CURR_STYLE);
        if (strCodeStyle.equals(STYLE_3)) {
            this.setStyleText(STYLE_3);
            this.rbtnBraceStyle3.setSelected(true);
            this.stylePane.repaint();
        } else if (strCodeStyle.equals(STYLE_2)) {
            this.setStyleText(STYLE_2);
            this.rbtnBraceStyle2.setSelected(true);
            this.stylePane.repaint();
        } else {
            this.setStyleText(STYLE_1);
            this.rbtnBraceStyle1.setSelected(true);
            this.stylePane.repaint();
        }
    }

    public int whatStyleSelected() {
        if (this.rbtnBraceStyle1.isSelected()) {
            return 1;
        }
        if (this.rbtnBraceStyle2.isSelected()) {
            return 2;
        }
        return 3;
    }
}

