/*
 * Decompiled with CFR 0.152.
 */
package kr.or.bluej.cw.styler;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import kr.or.bluej.cw.styler.JSBeautifier;
import kr.or.bluej.cw.styler.JSFormatter;

public class CodeFormatter {
    private static int PREFERRED_LINE_LENGTH = 1000;
    private static int LINE_LENGTH_DEVIATION = 2;
    private static int SPACE_INDENTATION = 2;
    private static boolean BRACKET_BREAK = false;
    private static boolean BRACKET_INDENT = false;
    private static final String FORMATTER_ENCODING = "ISO-8859-1";
    private static int ENCODE = 2;

    public static String format(String code) {
        String encoding = FORMATTER_ENCODING;
        try {
            JSFormatter formatter = new JSFormatter();
            formatter.setPreferredLineLength(PREFERRED_LINE_LENGTH);
            formatter.setLineLengthDeviation(LINE_LENGTH_DEVIATION);
            formatter.setBracketBreak(CodeFormatter.getBRACKET_BREAK());
            formatter.setBracketIndent(CodeFormatter.getBRACKET_INDENT());
            ByteArrayOutputStream out = new ByteArrayOutputStream(code.length());
            formatter.format(new BufferedReader(new StringReader(code)), new PrintWriter(out, true));
            code = CodeFormatter.getString(out, encoding);
            out = new ByteArrayOutputStream(code.length());
            JSBeautifier beautifier = new JSBeautifier();
            beautifier.setSpaceIndentation(SPACE_INDENTATION);
            beautifier.setMaxInStatementIndetation(0);
            beautifier.beautifyReader(new BufferedReader(new StringReader(code)), new PrintWriter(out, true));
            return CodeFormatter.convertUniIntoKsc(code.toString());
        }
        catch (Exception e) {
            return code;
        }
    }

    private static String convertUniIntoKsc(String str) throws UnsupportedEncodingException {
        str = new String(str.getBytes(FORMATTER_ENCODING), "KSC5601");
        return str;
    }

    protected static String getString(ByteArrayOutputStream out, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            return out.toString();
        }
        return out.toString(encoding);
    }

    public static boolean getBRACKET_BREAK() {
        return BRACKET_BREAK;
    }

    public static boolean getBRACKET_INDENT() {
        return BRACKET_INDENT;
    }

    public static int getPREFERRED_LINE_LENGTH() {
        return PREFERRED_LINE_LENGTH;
    }

    public static void setPREFERRED_LINE_LENGTH(int i) {
        PREFERRED_LINE_LENGTH = i;
    }

    public static int getLINE_LENGTH_DEVIATION() {
        return LINE_LENGTH_DEVIATION;
    }

    public static int getSPACE_INDENTATION() {
        return SPACE_INDENTATION;
    }

    public static void setBRACKET_BREAK(boolean b) {
        BRACKET_BREAK = b;
    }

    public static void setBRACKET_INDENT(boolean b) {
        BRACKET_INDENT = b;
    }

    public static void setLINE_LENGTH_DEVIATION(int i) {
        LINE_LENGTH_DEVIATION = i;
    }

    public static void setSPACE_INDENTATION(int i) {
        SPACE_INDENTATION = i;
    }

    public static int getENCODE() {
        return ENCODE;
    }

    public static void setENCODE(int i) {
        ENCODE = i;
    }
}

