/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.mainrunner;

import [Ljava.lang.String;;
import bluej.extensions.BClass;
import bluej.extensions.BMethod;
import bluej.extensions.MenuGenerator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Modifier;
import javax.swing.JMenuItem;
import org.bluej.mainrunner.Actor;

class MenuBuilder
extends MenuGenerator {
    MenuBuilder() {
    }

    public JMenuItem getClassMenuItem(final BClass aClass) {
        JMenuItem jmi = null;
        if (this.hasMainMethod(aClass)) {
            jmi = new JMenuItem("Run Main Method");
            jmi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new Actor(aClass).start();
                }
            });
        }
        return jmi;
    }

    public void notifyPostClassMenu(BClass bc, JMenuItem jmi) {
        jmi.setEnabled(this.hasMainMethod(bc));
    }

    private boolean hasMainMethod(BClass aClass) {
        try {
            if (!aClass.isCompiled()) {
                return false;
            }
            BMethod bm = aClass.getDeclaredMethod("main", new Class[]{String;.class});
            if (bm == null) {
                return false;
            }
            if (bm.getReturnType() != Void.TYPE) {
                return false;
            }
            int mod = bm.getModifiers();
            return Modifier.isPublic(mod) && Modifier.isStatic(mod);
        }
        catch (Exception e) {
            return false;
        }
    }
}

