/*
 * Decompiled with CFR 0.152.
 */
package kr.or.bluej.cw.extension;

import bluej.extensions.BClass;
import bluej.extensions.BPackage;
import bluej.extensions.BProject;
import bluej.extensions.BlueJ;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.extensions.editor.Editor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import kr.or.bluej.cw.extension.ClassWizardExtension;
import kr.or.bluej.cw.extension.Preferences;
import kr.or.bluej.cw.gui.SplashFrame;
import kr.or.bluej.cw.io.Reader;
import kr.or.bluej.cw.io.Writer;
import kr.or.bluej.cw.member.CWClassOrInterface;
import kr.or.bluej.cw.parser.JavaParser;
import kr.or.bluej.cw.parser.ParseException;
import kr.or.bluej.cw.styler.CodeFormatter;

public class ClassWizard
extends AbstractAction {
    Editor editor;
    BClass selectedClass;
    File file;
    JavaParser javaParser;
    CWClassOrInterface cwClassOrInterface;
    String source;
    BlueJ bluej;
    Preferences p;
    boolean isCompiled;
    Writer writer;
    Reader reader;
    BPackage bPackage;
    BProject bProject;
    File pFile;
    static Vector openFilePathList = new Vector();
    String currentFilePath;
    SplashFrame splash;

    public ClassWizard(BClass selectedClass, BlueJ bluej) {
        this.selectedClass = selectedClass;
        this.bluej = bluej;
        this.cwClassOrInterface = new CWClassOrInterface();
        this.source = "";
        this.currentFilePath = "";
        this.putValue("Name", "Run ClassWizard");
    }

    public void actionPerformed(ActionEvent event) {
        try {
            this.file = this.selectedClass.getJavaFile();
            this.currentFilePath = this.file.getAbsolutePath();
            for (int openFilePathListIndex = 0; openFilePathListIndex < openFilePathList.size(); ++openFilePathListIndex) {
                if (!((String)openFilePathList.get(openFilePathListIndex)).equals(this.currentFilePath)) continue;
                JOptionPane.showMessageDialog(null, "Class Wizard can`t be run \nmuch than one class simultanously.");
                return;
            }
            openFilePathList.add(this.currentFilePath);
        }
        catch (Exception e) {
            System.out.println("Exception from getJavaFile");
        }
        try {
            this.editor = this.selectedClass.getEditor();
        }
        catch (ProjectNotOpenException poe) {
        }
        catch (PackageNotFoundException pnfe) {
            // empty catch block
        }
        try {
            this.bPackage = this.selectedClass.getPackage();
        }
        catch (ProjectNotOpenException pnoe) {
        }
        catch (PackageNotFoundException pnfe) {
            // empty catch block
        }
        this.editor.setReadOnly(true);
        try {
            this.isCompiled = this.selectedClass.isCompiled();
        }
        catch (ProjectNotOpenException pnoe) {
            System.out.println("Exception from isCompiled");
        }
        catch (PackageNotFoundException pnfe) {
            System.out.println("Exception from isCompiled");
        }
        if (this.isCompiled) {
            this.splash = new SplashFrame();
            this.p = (Preferences)this.bluej.getPreferenceGenerator();
            if (this.p.whatStyleSelected() == 1) {
                CodeFormatter.setBRACKET_BREAK(true);
                CodeFormatter.setBRACKET_INDENT(false);
            } else if (this.p.whatStyleSelected() == 2) {
                CodeFormatter.setBRACKET_BREAK(true);
                CodeFormatter.setBRACKET_INDENT(true);
            } else {
                CodeFormatter.setBRACKET_BREAK(false);
                CodeFormatter.setBRACKET_INDENT(false);
            }
            this.reader = new Reader(this.file);
            this.reader.getSource();
            try {
                this.javaParser = new JavaParser(new FileInputStream(this.file), this.file);
                try {
                    ClassWizard classWizard = this;
                    classWizard.javaParser.CompilationUnit();
                    this.cwClassOrInterface = this.javaParser.getCWClassOrInterface();
                    this.cwClassOrInterface.setFilePath(this.currentFilePath);
                    this.javaParser = null;
                }
                catch (ParseException e) {
                    System.out.println("Exception from CompilationUnit");
                }
            }
            catch (Exception e) {
                System.out.println("Exception from FileInputStream");
            }
            ClassWizardExtension.disable = true;
            try {
                Editor editor = this.selectedClass.getEditor();
                this.splash.setMainFrameMember(this.cwClassOrInterface, this.file, this, editor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void exit() {
        this.editor.setReadOnly(false);
        openFilePathList.removeElement(this.cwClassOrInterface.getFilePath());
        try {
            this.bPackage = this.selectedClass.getPackage();
            this.bProject = this.bPackage.getProject();
            this.pFile = this.bProject.getDir();
            this.bProject.close();
            this.bluej.openProject(this.pFile);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        ClassWizardExtension.disable = false;
    }

    public void print(CWClassOrInterface coi) {
        Writer writer = new Writer(this.cwClassOrInterface, this.selectedClass, this.editor, this.file);
        writer.printSource();
    }
}

