/*
 * Decompiled with CFR 0.152.
 */
package kr.or.bluej.cw.gui;

import bluej.extensions.editor.Editor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kr.or.bluej.cw.checker.ArrayChecker;
import kr.or.bluej.cw.checker.FieldTypeChecker;
import kr.or.bluej.cw.checker.ImportChecker;
import kr.or.bluej.cw.checker.InterfaceChecker;
import kr.or.bluej.cw.checker.ReturnTypeChecker;
import kr.or.bluej.cw.checker.WordChecker;
import kr.or.bluej.cw.extension.ClassWizard;
import kr.or.bluej.cw.gui.JCheckBox;
import kr.or.bluej.cw.gui.MainFrame;
import kr.or.bluej.cw.gui.MainMenu;
import kr.or.bluej.cw.gui.Message;
import kr.or.bluej.cw.gui.ParameterFrame;
import kr.or.bluej.cw.member.CWClassOrInterface;
import kr.or.bluej.cw.member.CWConstructor;
import kr.or.bluej.cw.member.CWField;
import kr.or.bluej.cw.member.CWMethod;
import kr.or.bluej.cw.member.CWParameter;

public class MainFrame
extends JFrame
implements WindowListener,
WindowFocusListener {
    private JComponent[] generalComp;
    private JComponent[] fieldComp;
    private JComponent[] methodComp;
    private JComponent[] constructorComp;
    private File file;
    private String frontComment = "";
    private String rightComment = "";
    private CWClassOrInterface coi;
    private JList fieldList;
    private JList constructorList;
    private JList methodList;
    private MainFrame myself = this;
    private Vector fieldListData;
    private Vector methodListData;
    private Vector constructorListData;
    private int fieldMode = -1;
    private int methodMode = -1;
    private int constructorMode = -1;
    private static boolean exit;
    private ClassWizard classwizard;
    private Color defaultColor;
    private JLabel lblMsg;
    private int fieldIndex = -3;
    private String strType;
    private Editor editor;
    private Vector vecMethodOverlap;
    private Vector vecConstructorOverlap;
    private String paramOverlap;
    private int overlapIndex;
    private String currOperatorName = null;
    Vector currParameters = null;
    private Vector changedParameters = null;
    ParameterFrame parameterFrame = null;

    public static void showClassWizard(CWClassOrInterface coi, File file, ClassWizard cw, Editor editor) {
        MainFrame mf = new MainFrame(coi, file, cw, editor);
    }

    private void initCode() {
        int cnt;
        CWMethod method;
        if (this.coi == null) {
            return;
        }
        this.vecMethodOverlap = new Vector();
        this.vecConstructorOverlap = new Vector();
        this.paramOverlap = "";
        this.overlapIndex = -1;
        this.makeMainPanel();
        this.fieldListData = null;
        this.methodListData = null;
        this.constructorListData = null;
        String type = null;
        JTextField tf = (JTextField)this.generalComp[0];
        if (this.coi.getAbstract().equals("abstract")) {
            type = "abstract";
            this.generalComp[1].setFont(this.generalComp[0].getFont().deriveFont(2));
        } else {
            type = this.coi.getSuperClassName().equals("Applet") || this.coi.getSuperClassName().equals("JApplet") ? "applet" : (this.coi.getType().equals("interface") ? "interface" : "class");
        }
        tf.setText(type);
        tf = (JTextField)this.generalComp[1];
        tf.setText(this.coi.getClassNameOrInterfaceName());
        tf = (JTextField)this.generalComp[3];
        tf.setText(this.coi.getSuperClassName());
        tf = (JTextField)this.generalComp[5];
        tf.setText(this.coi.getPackage());
        JTextArea ta = (JTextArea)this.generalComp[7];
        ta.setText(this.coi.getComments());
        JComboBox cb = (JComboBox)this.generalComp[2];
        if (this.coi.getVisibility().equals("public")) {
            cb.setSelectedItem("public");
        } else {
            cb.setSelectedItem("package");
        }
        JList l = (JList)this.generalComp[4];
        if (this.strType.equals("class")) {
            l.setListData(this.coi.getImplementedInterfaceNames());
        } else {
            l.setListData(this.coi.getSuperInterfaceNames());
        }
        l = (JList)this.generalComp[6];
        l.setListData(this.coi.getImports());
        if (this.coi.getFinal().equals("final")) {
            ((JCheckBox)this.generalComp[8]).setSelected(true);
        }
        this.fieldListData = this.coi.getFields();
        this.fieldListData = (Vector)this.fieldListData.clone();
        Vector<String> fieldNameList = new Vector<String>();
        Iterator i = this.fieldListData.iterator();
        while (i.hasNext()) {
            CWField field = (CWField)i.next();
            String name = field.getName();
            String visibility = field.getVisibility();
            if (visibility.equals("private")) {
                name = "-" + name;
            } else if (visibility.equals("protected")) {
                name = "#" + name;
            } else if (visibility.equals("public")) {
                name = "+" + name;
            } else if (visibility.equals("")) {
                name = "~" + name;
            }
            name = name + " : " + field.getType();
            String init = field.getInitialValue();
            init = init.trim();
            if (!init.equals("")) {
                name = name + " = " + field.getInitialValue();
            }
            fieldNameList.add(name);
        }
        this.fieldList.setListData(fieldNameList);
        this.fieldList.setCellRenderer(new FieldCellRenderer(this.fieldListData));
        this.methodListData = this.coi.getMethods();
        int numberOfMethod = this.methodListData.size();
        for (int j = 0; j < numberOfMethod; ++j) {
            method = (CWMethod)this.methodListData.get(j);
            String body = method.getBody();
            if (body.indexOf(125) >= 0) continue;
            body = "{\n}";
            method.setBody(body);
            this.methodListData.set(j, method);
        }
        this.methodListData = (Vector)this.methodListData.clone();
        Vector<String> methodNameList = new Vector<String>();
        i = this.methodListData.iterator();
        while (i.hasNext()) {
            String name;
            method = (CWMethod)i.next();
            String methodOverlap = name = method.getOperatorName();
            String visibility = method.getVisibility();
            if (visibility.equals("private")) {
                name = "-" + name;
            } else if (visibility.equals("protected")) {
                name = "#" + name;
            } else if (visibility.equals("public")) {
                name = "+" + name;
            } else if (visibility.equals("")) {
                name = "~" + name;
            }
            name = name + "(";
            Iterator ii = method.getParameters().iterator();
            while (ii.hasNext()) {
                CWParameter p = (CWParameter)ii.next();
                name = name + p.getParameterName() + " : " + p.getType();
                methodOverlap = methodOverlap + " " + p.getType();
                if (!ii.hasNext()) continue;
                name = name + ", ";
            }
            name = name + ")";
            name = name + " : " + method.getReturnType();
            methodNameList.add(name);
            this.vecMethodOverlap.add(methodOverlap);
        }
        this.methodList.setListData(methodNameList);
        this.methodList.setCellRenderer(new MethodCellRenderer(this.methodListData));
        this.constructorListData = this.coi.getConstructors();
        int numberOfConstructor = this.constructorListData.size();
        for (int j = 0; j < numberOfConstructor; ++j) {
            CWConstructor constructor = (CWConstructor)this.constructorListData.get(j);
            String body = constructor.getBody();
            if (body.indexOf(125) >= 0) continue;
            body = "{\n}";
            constructor.setBody(body);
            this.constructorListData.set(j, constructor);
        }
        this.constructorListData = (Vector)this.constructorListData.clone();
        Vector<String> constructorNameList = new Vector<String>();
        i = this.constructorListData.iterator();
        while (i.hasNext()) {
            String constructorOverlap = "";
            CWConstructor constructor = (CWConstructor)i.next();
            String name = constructor.getOperatorName();
            String visibility = constructor.getVisibility();
            if (visibility.equals("private")) {
                name = "-" + name;
            } else if (visibility.equals("protected")) {
                name = "#" + name;
            } else if (visibility.equals("public")) {
                name = "+" + name;
            } else if (visibility.equals("")) {
                name = "~" + name;
            }
            name = name + "(";
            Iterator ii = constructor.getParameters().iterator();
            while (ii.hasNext()) {
                CWParameter p = (CWParameter)ii.next();
                name = name + p.getParameterName() + " : " + p.getType();
                constructorOverlap = constructorOverlap + p.getType();
                if (!ii.hasNext()) continue;
                name = name + ", ";
                constructorOverlap = constructorOverlap + " ";
            }
            name = name + ")";
            constructorNameList.add(name);
            this.vecConstructorOverlap.add(constructorOverlap);
        }
        this.constructorList.setListData(constructorNameList);
        for (cnt = 0; cnt < this.fieldComp.length; ++cnt) {
            this.fieldComp[cnt].setEnabled(false);
        }
        for (cnt = 0; cnt < this.methodComp.length; ++cnt) {
            this.methodComp[cnt].setEnabled(false);
        }
        for (cnt = 0; cnt < this.constructorComp.length; ++cnt) {
            this.constructorComp[cnt].setEnabled(false);
        }
    }

    private MainFrame(CWClassOrInterface coi, File file, ClassWizard cw, Editor e) {
        super("Class Wizard : " + coi.getClassNameOrInterfaceName());
        this.setDefaultCloseOperation(0);
        this.setBounds(150, 100, 600, 520);
        this.setResizable(false);
        try {
            Image image = new ImageIcon(this.getClass().getResource("wizard_icon.jpg")).getImage();
            this.setIconImage(image);
        }
        catch (Exception e2) {
            // empty catch block
        }
        this.strType = coi.getType();
        this.coi = coi;
        this.file = file;
        this.classwizard = cw;
        this.initCode();
        this.setVisible(true);
        this.addWindowListener(this);
        this.addWindowFocusListener(this);
        exit = false;
        this.editor = e;
    }

    private void makeMainPanel() {
        MainMenu menuBar = new MainMenu(this);
        this.setJMenuBar(menuBar);
        Container cp = this.getContentPane();
        cp.setLayout(null);
        JPanel embTab = new JPanel();
        embTab.setLayout(null);
        embTab.setBounds(10, 10, this.getWidth() - 30, this.getHeight() - 120);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setBounds(0, 0, embTab.getWidth(), embTab.getHeight());
        tabbedPane.addTab("General", this.makeGeneralPanel());
        tabbedPane.addTab("Field", this.makeFieldPanel());
        tabbedPane.addTab("Method", this.makeMethodPanel());
        tabbedPane.addTab("Constructor", this.makeConstructorPanel());
        if (this.strType.equals("interface")) {
            tabbedPane.setEnabledAt(3, false);
        }
        tabbedPane.addChangeListener(new TabChanged());
        embTab.add(tabbedPane);
        JPanel embBtn = new JPanel();
        embBtn.setLayout(null);
        embBtn.setBounds(10, 20 + this.getHeight() - 120, this.getWidth() - 30, 80);
        JButton okBtn = new JButton("ok");
        okBtn.setBounds(this.getWidth() - 30 - 100 - 110 - 110, 0, 100, 40);
        okBtn.addActionListener(new OkBtn());
        JButton cancelBtn = new JButton("cancel");
        cancelBtn.setBounds(this.getWidth() - 30 - 100 - 110, 0, 100, 40);
        cancelBtn.addActionListener(new CencelBtn());
        JButton applyBtn = new JButton("apply");
        applyBtn.setBounds(this.getWidth() - 30 - 100, 0, 100, 40);
        applyBtn.addActionListener(new ApplyBtn());
        this.lblMsg = new JLabel();
        this.lblMsg.setBounds(this.getWidth() - 30 - 100 - 110 - 110 - 200 - 50, 20, 250, 20);
        this.lblMsg.setHorizontalAlignment(2);
        this.lblMsg.setText("");
        embBtn.add(this.lblMsg);
        embBtn.add(okBtn);
        embBtn.add(cancelBtn);
        embBtn.add(applyBtn);
        cp.add(embTab);
        cp.add(embBtn);
    }

    private JPanel makeGeneralPanel() {
        this.generalComp = new JComponent[9];
        JPanel[] panel = new JPanel[3];
        for (int i = 0; i < panel.length; ++i) {
            panel[i] = new JPanel();
            panel[i].setLayout(null);
        }
        panel[0].add(panel[1]);
        panel[0].add(panel[2]);
        panel[0].setBounds(0, 0, 560, 380);
        panel[1].setBounds(10, 10, panel[0].getWidth() / 2 - 20, panel[0].getHeight() - 30);
        panel[2].setBounds(panel[0].getWidth() / 2 + 20, 10, panel[0].getWidth() / 2 - 20, panel[0].getHeight() - 30);
        panel[1].setBorder(new EtchedBorder());
        panel[2].setBorder(new EtchedBorder());
        JLabel[] label = new JLabel[8];
        for (int i = 0; i < label.length; ++i) {
            label[i] = new JLabel();
        }
        label[0].setText("Type");
        label[1].setText("Name");
        label[2].setText("Visibility");
        label[3].setText("Super Class");
        if (this.strType.equals("interface")) {
            label[3].setEnabled(false);
        }
        label[4].setText("Interface");
        if (this.strType.equals("interface")) {
            label[4].setText("Super interface");
        }
        label[5].setText("Package");
        label[6].setText("Import");
        label[7].setText("Comment");
        JTextField[] textfield = new JTextField[4];
        for (int i = 0; i < textfield.length; ++i) {
            textfield[i] = new JTextField();
        }
        if (this.strType.equals("interface")) {
            textfield[2].setEditable(false);
        }
        textfield[0].setEditable(false);
        textfield[1].setEditable(false);
        JComboBox<String> combobox = new JComboBox<String>();
        JList[] list = new JList[2];
        for (int i = 0; i < list.length; ++i) {
            list[i] = new JList();
        }
        JButton[] button = new JButton[4];
        for (int i = 0; i < button.length; ++i) {
            button[i] = new JButton();
        }
        button[0].setText("add");
        button[1].setText("del");
        button[2].setText("add");
        button[3].setText("del");
        JTextArea textarea = new JTextArea();
        JCheckBox boxFinal = new JCheckBox("Final");
        JScrollPane[] scrollpane = new JScrollPane[]{new JScrollPane(list[0]), new JScrollPane(list[1]), new JScrollPane(textarea)};
        panel[1].add(label[0]);
        label[0].setBounds(10, 10, 80, 20);
        panel[1].add(label[1]);
        label[1].setBounds(10, 40, 80, 20);
        panel[1].add(label[2]);
        label[2].setBounds(10, 70, 80, 20);
        panel[1].add(label[3]);
        label[3].setBounds(10, 100, 80, 20);
        panel[1].add(label[4]);
        label[4].setBounds(10, 160, 90, 20);
        panel[1].add(boxFinal);
        boxFinal.setBounds(115, 160, 120, 20);
        panel[1].add(textfield[0]);
        textfield[0].setBounds(120, 10, 130, 20);
        panel[1].add(textfield[1]);
        textfield[1].setBounds(120, 40, 130, 20);
        panel[1].add(textfield[2]);
        textfield[2].setBounds(120, 100, 130, 20);
        panel[1].add(combobox);
        combobox.setBounds(120, 70, 130, 20);
        combobox.addItem("");
        combobox.addItem("public");
        panel[1].add(scrollpane[0]);
        scrollpane[0].setBounds(10, 190, 240, 100);
        panel[1].add(button[0]);
        button[0].setBounds(10, 300, 80, 40);
        if (this.strType.equals("class")) {
            button[0].addActionListener(new GeneralInterfaceAdder(list[0], "Interface : "));
        } else {
            button[0].addActionListener(new GeneralInterfaceAdder(list[0], "Super interface : "));
        }
        panel[1].add(button[1]);
        button[1].setBounds(170, 300, 80, 40);
        button[1].addActionListener(new GeneralDeler(list[0]));
        panel[1].add(label[5]);
        label[5].setBounds(10, 130, 80, 20);
        panel[2].add(label[6]);
        label[6].setBounds(10, 160, 80, 20);
        panel[2].add(label[7]);
        label[7].setBounds(10, 10, 80, 20);
        panel[1].add(textfield[3]);
        textfield[3].setBounds(120, 130, 130, 20);
        panel[2].add(scrollpane[1]);
        scrollpane[1].setBounds(10, 190, 240, 100);
        panel[2].add(button[2]);
        button[2].setBounds(10, 300, 80, 40);
        button[2].addActionListener(new GeneralImportAdder(list[1], "Import : "));
        panel[2].add(button[3]);
        button[3].setBounds(170, 300, 80, 40);
        button[3].addActionListener(new GeneralDeler(list[1]));
        panel[2].add(scrollpane[2]);
        scrollpane[2].setBounds(10, 40, 240, 110);
        GeneralColorRecoverListener generalColorRecover = new GeneralColorRecoverListener();
        this.generalComp[0] = textfield[0];
        this.generalComp[0].addMouseListener(generalColorRecover);
        this.generalComp[1] = textfield[1];
        this.generalComp[1].addMouseListener(generalColorRecover);
        this.generalComp[2] = combobox;
        this.generalComp[2].addMouseListener(generalColorRecover);
        this.generalComp[3] = textfield[2];
        this.generalComp[3].addMouseListener(generalColorRecover);
        if (this.strType.equals("class")) {
            ((JTextField)this.generalComp[3]).setBackground(new Color(0xFFFFFF));
        }
        this.generalComp[4] = list[0];
        this.generalComp[4].addMouseListener(generalColorRecover);
        this.generalComp[5] = textfield[3];
        this.generalComp[5].addMouseListener(generalColorRecover);
        this.generalComp[6] = list[1];
        this.generalComp[6].addMouseListener(generalColorRecover);
        this.generalComp[7] = textarea;
        this.generalComp[7].addMouseListener(generalColorRecover);
        this.generalComp[8] = boxFinal;
        this.generalComp[8].addMouseListener(generalColorRecover);
        if (this.coi.getAbstract().equals("abstract") || this.coi.getType().equals("interface")) {
            boxFinal.setEnabled(false);
        }
        return panel[0];
    }

    private JPanel makeFieldPanel() {
        this.fieldComp = new JComponent[13];
        JPanel[] panel = new JPanel[3];
        for (int i = 0; i < panel.length; ++i) {
            panel[i] = new JPanel();
            panel[i].setLayout(null);
        }
        panel[0].add(panel[1]);
        panel[0].add(panel[2]);
        panel[0].setBounds(0, 0, 560, 380);
        panel[1].setBounds(10, 10, panel[0].getWidth() / 2 - 20, panel[0].getHeight() - 30);
        panel[2].setBounds(panel[0].getWidth() / 2 + 20, 10, panel[0].getWidth() / 2 - 20, panel[0].getHeight() - 30);
        panel[1].setBorder(new EtchedBorder());
        panel[2].setBorder(new EtchedBorder());
        JLabel[] label = new JLabel[4];
        for (int i = 0; i < label.length; ++i) {
            label[i] = new JLabel();
        }
        label[0].setText("Visibility");
        label[1].setText("Type");
        label[2].setText("Name");
        label[3].setText("Init Value");
        JTextField[] textfield = new JTextField[2];
        for (int i = 0; i < textfield.length; ++i) {
            textfield[i] = new JTextField();
        }
        JComboBox[] combobox = new JComboBox[2];
        for (int i = 0; i < combobox.length; ++i) {
            combobox[i] = new JComboBox();
        }
        FieldColorRecoverListener fieldColorRecover = new FieldColorRecoverListener();
        this.fieldList = new JList();
        this.fieldList.addListSelectionListener(new FieldListListener());
        this.fieldList.addMouseListener(fieldColorRecover);
        JButton[] button = new JButton[5];
        for (int i = 0; i < button.length; ++i) {
            button[i] = new JButton();
        }
        button[0].setText("add");
        button[0].addMouseListener(fieldColorRecover);
        button[1].setText("modify");
        button[1].addMouseListener(fieldColorRecover);
        button[2].setText("del");
        button[2].addMouseListener(fieldColorRecover);
        button[3].setText("set");
        button[3].addMouseListener(fieldColorRecover);
        button[4].setText("reset");
        button[4].addMouseListener(fieldColorRecover);
        JTextArea textarea = new JTextArea();
        textarea.addMouseListener(fieldColorRecover);
        JScrollPane[] scrollpane = new JScrollPane[]{new JScrollPane(this.fieldList), new JScrollPane(textarea)};
        JCheckBox[] check = new JCheckBox[4];
        for (int i = 0; i < check.length; ++i) {
            check[i] = new JCheckBox();
        }
        check[0].setText("Static");
        check[1].setText("Final");
        check[2].setText("Transient");
        check[3].setText("Volatile");
        check[1].addActionListener(new MutualExclusion(check[1], check[3]));
        check[3].addActionListener(new MutualExclusion(check[3], check[1]));
        if (this.strType.equals("interface")) {
            check[2].setVisible(false);
            check[3].setVisible(false);
        }
        JRadioButton[] radio = new JRadioButton[2];
        for (int i = 0; i < radio.length; ++i) {
            radio[i] = new JRadioButton();
        }
        radio[0].setText("Front Comment");
        radio[0].addActionListener(new FrontComment());
        radio[1].setText("Right Comment");
        radio[1].addActionListener(new RightComment());
        panel[1].add(scrollpane[0]);
        scrollpane[0].setBounds(10, 10, 240, 280);
        panel[1].add(button[0]);
        button[0].setBounds(10, 300, 60, 40);
        button[0].addActionListener(new FieldListAdder());
        panel[1].add(button[1]);
        button[1].setBounds(90, 300, 80, 40);
        button[1].addActionListener(new FieldListModifier());
        panel[1].add(button[2]);
        button[2].setBounds(190, 300, 60, 40);
        button[2].addActionListener(new FieldListDeler(this.fieldComp));
        panel[2].add(label[0]);
        label[0].setBounds(10, 10, 80, 20);
        panel[2].add(label[1]);
        label[1].setBounds(10, 40, 80, 20);
        panel[2].add(label[2]);
        label[2].setBounds(10, 70, 80, 20);
        panel[2].add(label[3]);
        label[3].setBounds(10, 100, 80, 20);
        panel[2].add(combobox[0]);
        combobox[0].setBounds(120, 10, 130, 20);
        combobox[0].addItem("");
        combobox[0].addItem("public");
        if (this.strType.equals("class")) {
            combobox[0].addItem("private");
            combobox[0].addItem("protected");
        }
        panel[2].add(combobox[1]);
        combobox[1].setBounds(120, 40, 130, 20);
        combobox[1].addItem("byte");
        combobox[1].addItem("char");
        combobox[1].addItem("short");
        combobox[1].addItem("int");
        combobox[1].addItem("long");
        combobox[1].addItem("float");
        combobox[1].addItem("double");
        combobox[1].addItem("boolean");
        combobox[1].setEditable(true);
        panel[2].add(textfield[0]);
        textfield[0].setBounds(120, 70, 130, 20);
        panel[2].add(textfield[1]);
        textfield[1].setBounds(120, 100, 130, 20);
        panel[2].add(check[0]);
        check[0].setBounds(10, 130, 120, 20);
        panel[2].add(check[1]);
        check[1].setBounds(130, 130, 120, 20);
        panel[2].add(check[2]);
        check[2].setBounds(10, 160, 120, 20);
        panel[2].add(check[3]);
        check[3].setBounds(130, 160, 120, 20);
        panel[2].add(radio[0]);
        radio[0].setBounds(10, 200, 120, 20);
        panel[2].add(radio[1]);
        radio[1].setBounds(130, 200, 120, 20);
        ButtonGroup bgroup = new ButtonGroup();
        bgroup.add(radio[0]);
        bgroup.add(radio[1]);
        panel[2].add(scrollpane[1]);
        scrollpane[1].setBounds(10, 230, 240, 60);
        panel[2].add(button[3]);
        button[3].setBounds(10, 300, 80, 40);
        button[3].addActionListener(new FieldListSetter());
        panel[2].add(button[4]);
        button[4].setBounds(170, 300, 80, 40);
        button[4].addActionListener(new FieldListResetter());
        this.fieldComp[0] = combobox[0];
        ((JComboBox)this.fieldComp[0]).addMouseListener(fieldColorRecover);
        ((JComboBox)this.fieldComp[0]).setBackground(new Color(0xFFFFFF));
        this.fieldComp[1] = combobox[1];
        ((JComboBox)this.fieldComp[1]).addMouseListener(fieldColorRecover);
        ((JComboBox)this.fieldComp[1]).setBackground(new Color(0xFFFFFF));
        this.fieldComp[2] = textfield[0];
        ((JTextField)this.fieldComp[2]).addMouseListener(fieldColorRecover);
        ((JTextField)this.fieldComp[2]).setBackground(new Color(0xFFFFFF));
        this.fieldComp[3] = textfield[1];
        ((JTextField)this.fieldComp[3]).addMouseListener(fieldColorRecover);
        ((JTextField)this.fieldComp[3]).setBackground(new Color(0xFFFFFF));
        this.fieldComp[4] = check[0];
        ((JCheckBox)this.fieldComp[4]).addMouseListener(fieldColorRecover);
        this.fieldComp[5] = check[1];
        ((JCheckBox)this.fieldComp[5]).addMouseListener(fieldColorRecover);
        this.fieldComp[6] = check[2];
        ((JCheckBox)this.fieldComp[6]).addMouseListener(fieldColorRecover);
        this.fieldComp[7] = check[3];
        ((JCheckBox)this.fieldComp[7]).addMouseListener(fieldColorRecover);
        this.fieldComp[8] = radio[0];
        ((JRadioButton)this.fieldComp[8]).addMouseListener(fieldColorRecover);
        this.fieldComp[9] = radio[1];
        ((JRadioButton)this.fieldComp[9]).addMouseListener(fieldColorRecover);
        this.fieldComp[10] = textarea;
        ((JTextArea)this.fieldComp[10]).addMouseListener(fieldColorRecover);
        this.fieldComp[11] = button[3];
        ((JButton)this.fieldComp[11]).addMouseListener(fieldColorRecover);
        this.fieldComp[12] = button[4];
        ((JButton)this.fieldComp[12]).addMouseListener(fieldColorRecover);
        return panel[0];
    }

    private JPanel makeMethodPanel() {
        MethodColorRecoverListener methodColorListener = new MethodColorRecoverListener();
        this.methodComp = new JComponent[13];
        JPanel[] panel = new JPanel[3];
        for (int i = 0; i < panel.length; ++i) {
            panel[i] = new JPanel();
            panel[i].setLayout(null);
        }
        panel[0].add(panel[1]);
        panel[0].add(panel[2]);
        panel[0].setBounds(0, 0, 560, 380);
        panel[1].setBounds(10, 10, panel[0].getWidth() / 2 - 20, panel[0].getHeight() - 30);
        panel[2].setBounds(panel[0].getWidth() / 2 + 20, 10, panel[0].getWidth() / 2 - 20, panel[0].getHeight() - 30);
        panel[1].setBorder(new EtchedBorder());
        panel[2].setBorder(new EtchedBorder());
        JLabel[] label = new JLabel[4];
        for (int i = 0; i < label.length; ++i) {
            label[i] = new JLabel();
        }
        label[0].setText("Visibility");
        label[1].setText("Return Type");
        label[2].setText("Name");
        label[3].setText("Comment");
        JTextField[] textfield = new JTextField[1];
        for (int i = 0; i < textfield.length; ++i) {
            textfield[i] = new JTextField();
        }
        textfield[0].addMouseListener(methodColorListener);
        JComboBox[] combobox = new JComboBox[2];
        for (int i = 0; i < combobox.length; ++i) {
            combobox[i] = new JComboBox();
            combobox[i].addMouseListener(methodColorListener);
        }
        this.methodList = new JList();
        this.methodList.addListSelectionListener(new MethodListListener());
        this.methodList.addMouseListener(methodColorListener);
        JButton[] button = new JButton[5];
        for (int i = 0; i < button.length; ++i) {
            button[i] = new JButton();
            button[i].addMouseListener(methodColorListener);
        }
        button[0].setText("add");
        button[1].setText("modify");
        button[2].setText("del");
        button[3].setText("set");
        button[4].setText("reset");
        JTextArea textarea = new JTextArea();
        textarea.addMouseListener(methodColorListener);
        JScrollPane[] scrollpane = new JScrollPane[]{new JScrollPane(this.methodList), new JScrollPane(textarea)};
        JCheckBox[] check = new JCheckBox[6];
        for (int i = 0; i < check.length; ++i) {
            check[i] = new JCheckBox();
            check[i].addMouseListener(methodColorListener);
        }
        check[0].setText("Static");
        check[1].setText("Abstract");
        check[2].setText("Strictfp");
        check[3].setText("Final");
        check[4].setText("Native");
        check[5].setText("Synchronized");
        if (this.coi.getFinal().equals("final")) {
            check[1].setVisible(false);
        }
        if (this.strType.equals("interface")) {
            check[0].setVisible(false);
            check[2].setVisible(false);
            check[3].setVisible(false);
            check[4].setVisible(false);
            check[5].setVisible(false);
        }
        check[0].addActionListener(new MutualExclusion(check[0], check[1]));
        check[1].addActionListener(new MutualExclusion(check[1], check[0]));
        check[1].addActionListener(new MutualExclusion(check[1], check[3]));
        check[3].addActionListener(new MutualExclusion(check[3], check[1]));
        check[1].addActionListener(new MutualExclusion(check[1], check[5]));
        check[5].addActionListener(new MutualExclusion(check[5], check[1]));
        check[1].addActionListener(new MutualExclusion(check[1], check[4]));
        check[4].addActionListener(new MutualExclusion(check[4], check[1]));
        check[2].addActionListener(new MutualExclusion(check[2], check[4]));
        check[4].addActionListener(new MutualExclusion(check[4], check[2]));
        check[4].addActionListener(new NativeCheck());
        check[1].addActionListener(new MutualExclusion(check[1], check[2]));
        check[2].addActionListener(new MutualExclusion(check[2], check[1]));
        panel[1].add(scrollpane[0]);
        scrollpane[0].setBounds(10, 10, 240, 280);
        panel[1].add(button[0]);
        button[0].setBounds(10, 300, 60, 40);
        button[0].addActionListener(new MethodListAdder());
        panel[1].add(button[1]);
        button[1].setBounds(90, 300, 80, 40);
        button[1].addActionListener(new MethodListModifier());
        panel[1].add(button[2]);
        button[2].setBounds(190, 300, 60, 40);
        button[2].addActionListener(new MethodListDeler());
        panel[2].add(label[0]);
        label[0].setBounds(10, 10, 80, 20);
        panel[2].add(label[1]);
        label[1].setBounds(10, 40, 80, 20);
        panel[2].add(label[2]);
        label[2].setBounds(10, 70, 80, 20);
        panel[2].add(label[3]);
        label[3].setBounds(10, 200, 80, 20);
        JButton paramButton = new JButton();
        paramButton.setText("Edit Parameter");
        paramButton.addActionListener(new ParamBtn());
        panel[2].add(paramButton);
        paramButton.setBounds(10, 100, 240, 20);
        panel[2].add(combobox[0]);
        combobox[0].setBounds(120, 10, 130, 20);
        combobox[0].addItem("");
        combobox[0].addItem("public");
        if (this.strType.equals("class")) {
            combobox[0].addItem("private");
            combobox[0].addItem("protected");
        }
        panel[2].add(combobox[1]);
        combobox[1].setBounds(120, 40, 130, 20);
        combobox[1].addItem("void");
        combobox[1].addItem("byte");
        combobox[1].addItem("char");
        combobox[1].addItem("short");
        combobox[1].addItem("int");
        combobox[1].addItem("long");
        combobox[1].addItem("float");
        combobox[1].addItem("double");
        combobox[1].addItem("boolean");
        combobox[1].setEditable(true);
        panel[2].add(textfield[0]);
        textfield[0].setBounds(120, 70, 130, 20);
        panel[2].add(check[0]);
        check[0].setBounds(10, 130, 60, 20);
        panel[2].add(check[1]);
        check[1].setBounds(70, 130, 80, 20);
        panel[2].add(check[2]);
        check[2].setBounds(150, 130, 100, 20);
        panel[2].add(check[3]);
        check[3].setBounds(10, 160, 60, 20);
        panel[2].add(check[4]);
        check[4].setBounds(70, 160, 70, 20);
        panel[2].add(check[5]);
        check[5].setBounds(140, 160, 110, 20);
        panel[2].add(scrollpane[1]);
        scrollpane[1].setBounds(10, 230, 240, 60);
        panel[2].add(button[3]);
        button[3].setBounds(10, 300, 80, 40);
        button[3].addActionListener(new MethodListSetter());
        panel[2].add(button[4]);
        button[4].setBounds(170, 300, 80, 40);
        button[4].addActionListener(new MethodListResetter());
        this.methodComp[0] = combobox[0];
        this.methodComp[1] = combobox[1];
        this.methodComp[2] = textfield[0];
        this.methodComp[3] = check[0];
        this.methodComp[4] = check[1];
        if (this.coi.getAbstract().equals("abstract") || this.coi.getType().equals("interface")) {
            check[1].setEnabled(true);
        } else {
            check[1].setVisible(false);
        }
        this.methodComp[5] = check[2];
        this.methodComp[6] = check[3];
        this.methodComp[7] = check[4];
        this.methodComp[8] = check[5];
        this.methodComp[9] = textarea;
        this.methodComp[10] = paramButton;
        this.methodComp[11] = button[3];
        this.methodComp[12] = button[4];
        return panel[0];
    }

    private JPanel makeConstructorPanel() {
        this.constructorComp = new JComponent[6];
        JPanel[] panel = new JPanel[3];
        for (int i = 0; i < panel.length; ++i) {
            panel[i] = new JPanel();
            panel[i].setLayout(null);
        }
        panel[0].add(panel[1]);
        panel[0].add(panel[2]);
        panel[0].setBounds(0, 0, 560, 380);
        panel[1].setBounds(10, 10, panel[0].getWidth() / 2 - 20, panel[0].getHeight() - 30);
        panel[2].setBounds(panel[0].getWidth() / 2 + 20, 10, panel[0].getWidth() / 2 - 20, panel[0].getHeight() - 30);
        panel[1].setBorder(new EtchedBorder());
        panel[2].setBorder(new EtchedBorder());
        JLabel[] label = new JLabel[3];
        for (int i = 0; i < label.length; ++i) {
            label[i] = new JLabel();
        }
        label[0].setText("Visibility");
        label[1].setText("Name");
        label[2].setText("Comment");
        JTextField[] textfield = new JTextField[1];
        for (int i = 0; i < textfield.length; ++i) {
            textfield[i] = new JTextField();
        }
        JComboBox[] combobox = new JComboBox[1];
        for (int i = 0; i < combobox.length; ++i) {
            combobox[i] = new JComboBox();
        }
        this.constructorList = new JList();
        this.constructorList.addListSelectionListener(new ConstructorListListener());
        JButton[] button = new JButton[5];
        for (int i = 0; i < button.length; ++i) {
            button[i] = new JButton();
        }
        button[0].setText("add");
        button[1].setText("modify");
        button[2].setText("del");
        button[3].setText("set");
        button[4].setText("reset");
        JTextArea textarea = new JTextArea();
        JScrollPane[] scrollpane = new JScrollPane[]{new JScrollPane(this.constructorList), new JScrollPane(textarea)};
        panel[1].add(scrollpane[0]);
        scrollpane[0].setBounds(10, 10, 240, 280);
        panel[1].add(button[0]);
        button[0].setBounds(10, 300, 60, 40);
        button[0].addActionListener(new ConstructorListAdder());
        panel[1].add(button[1]);
        button[1].setBounds(90, 300, 80, 40);
        button[1].addActionListener(new ConstructorListModifier());
        panel[1].add(button[2]);
        button[2].setBounds(190, 300, 60, 40);
        button[2].addActionListener(new ConstructorListDeler());
        panel[2].add(label[0]);
        label[0].setBounds(10, 10, 80, 20);
        panel[2].add(label[1]);
        label[1].setBounds(10, 40, 80, 20);
        panel[2].add(label[2]);
        label[2].setBounds(10, 100, 80, 20);
        panel[2].add(combobox[0]);
        combobox[0].setBounds(120, 10, 130, 20);
        combobox[0].addItem("");
        combobox[0].addItem("public");
        combobox[0].addItem("private");
        combobox[0].addItem("protected");
        panel[2].add(textfield[0]);
        textfield[0].setBounds(120, 40, 130, 20);
        textfield[0].setEditable(false);
        JButton paramButton = new JButton();
        paramButton.setText("Edit Parameter");
        paramButton.addActionListener(new ParamBtn());
        panel[2].add(paramButton);
        paramButton.setBounds(10, 70, 240, 20);
        panel[2].add(scrollpane[1]);
        scrollpane[1].setBounds(10, 130, 240, 160);
        panel[2].add(button[3]);
        button[3].setBounds(10, 300, 80, 40);
        button[3].addActionListener(new ConstructorListSetter());
        panel[2].add(button[4]);
        button[4].setBounds(170, 300, 80, 40);
        button[4].addActionListener(new ConstructorListResetter());
        this.constructorComp[0] = combobox[0];
        this.constructorComp[1] = textfield[0];
        this.constructorComp[2] = textarea;
        this.constructorComp[3] = paramButton;
        this.constructorComp[4] = button[3];
        this.constructorComp[5] = button[4];
        return panel[0];
    }

    public void initFieldCheckBox() {
        ((JCheckBox)this.fieldComp[5]).nullCounter();
        ((JCheckBox)this.fieldComp[7]).nullCounter();
    }

    public void initMethodCheckBox() {
        ((JCheckBox)this.methodComp[3]).nullCounter();
        ((JCheckBox)this.methodComp[4]).nullCounter();
        ((JCheckBox)this.methodComp[5]).nullCounter();
        ((JCheckBox)this.methodComp[6]).nullCounter();
        ((JCheckBox)this.methodComp[7]).nullCounter();
        ((JCheckBox)this.methodComp[8]).nullCounter();
    }

    public void windowOpened(WindowEvent arg0) {
    }

    public void windowClosing(WindowEvent arg0) {
        exit = true;
        this.myself.setVisible(false);
        this.myself = null;
        this.classwizard.exit();
    }

    public void windowClosed(WindowEvent arg0) {
    }

    public void windowIconified(WindowEvent arg0) {
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowDeactivated(WindowEvent arg0) {
    }

    public String removeSpace(String other) {
        StringTokenizer nonSpaceToken = new StringTokenizer(other);
        String nonSpaceString = "";
        while (nonSpaceToken.hasMoreTokens()) {
            nonSpaceString = nonSpaceString + nonSpaceToken.nextToken();
        }
        return nonSpaceString;
    }

    public void windowGainedFocus(WindowEvent e) {
        if (this.parameterFrame == null) {
            return;
        }
        this.parameterFrame.transferFocus();
    }

    public void windowLostFocus(WindowEvent e) {
    }

    public class NativeCheck
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            JCheckBox c = (JCheckBox)ae.getSource();
            if (c.isSelected()) {
                JOptionPane.showMessageDialog(MainFrame.this.myself, "This choice will eliminate your method body", "Warning", 2);
            }
        }
    }

    public class MutualExclusion
    implements ActionListener {
        JCheckBox comp1;
        JCheckBox comp2;

        public MutualExclusion(JCheckBox c1, JCheckBox c2) {
            this.comp1 = c1;
            this.comp2 = c2;
        }

        public void actionPerformed(ActionEvent arg0) {
            if (this.comp1.isSelected() && MainFrame.this.strType.equals("class")) {
                this.comp2.setSelected(false);
                this.comp2.setEnabled(false);
                this.comp2.increase();
            } else if (MainFrame.this.strType.equals("class")) {
                this.comp2.decrease();
                if (this.comp2.getCounter() == 0) {
                    this.comp2.setEnabled(true);
                }
            }
        }
    }

    public class FieldCellRenderer
    extends JLabel
    implements ListCellRenderer {
        Vector list;

        public FieldCellRenderer(Vector v) {
            this.setOpaque(true);
            this.list = v;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            this.setBackground(isSelected ? new Color(49, 106, 197) : Color.white);
            this.setForeground(isSelected ? Color.white : Color.black);
            CWField m = (CWField)this.list.get(index);
            if (m.getStatic().equals("static")) {
                String htmlText = "<html><font size=\"3\"><u>" + value.toString() + "</u></font><br><font color=\"#ffffff\" size=\"1\">&nbsp</font>" + "";
                this.setText(htmlText);
            }
            return this;
        }
    }

    public class MethodCellRenderer
    extends JLabel
    implements ListCellRenderer {
        Vector list;

        public MethodCellRenderer(Vector v) {
            this.setOpaque(true);
            this.list = v;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Font f;
            this.setText(value.toString());
            this.setBackground(isSelected ? new Color(49, 106, 197) : Color.white);
            this.setForeground(isSelected ? Color.white : Color.black);
            CWMethod m = (CWMethod)this.list.get(index);
            if (m.getAbstract().equals("abstract")) {
                f = this.getFont();
                this.setFont(new Font(f.getFontName(), 2, f.getSize()));
            } else {
                f = this.getFont();
                this.setFont(new Font(f.getFontName(), 0, f.getSize()));
            }
            if (m.getStatic().equals("static")) {
                String htmlText = "<html><font size=\"3\"><u>" + value.toString() + "</u></font><br><font color=\"#ffffff\" size=\"1\">&nbsp</font>" + "";
                this.setText(htmlText);
            }
            return this;
        }
    }

    public class TabChanged
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            int cnt;
            MainFrame.this.fieldList.setSelectedIndex(-1);
            MainFrame.this.constructorList.setSelectedIndex(-1);
            MainFrame.this.methodList.setSelectedIndex(-1);
            for (cnt = 0; cnt < MainFrame.this.fieldComp.length; ++cnt) {
                MainFrame.this.fieldComp[cnt].setEnabled(false);
            }
            for (cnt = 0; cnt < MainFrame.this.methodComp.length; ++cnt) {
                MainFrame.this.methodComp[cnt].setEnabled(false);
            }
            for (cnt = 0; cnt < MainFrame.this.constructorComp.length; ++cnt) {
                MainFrame.this.constructorComp[cnt].setEnabled(false);
            }
            MainFrame.this.fieldMode = -1;
            MainFrame.this.methodMode = -1;
            MainFrame.this.constructorMode = -1;
            MainFrame.this.lblMsg.setText("");
            if (MainFrame.this.strType.equals("class")) {
                ((JTextField)MainFrame.this.generalComp[3]).setBackground(new Color(0xFFFFFF));
            }
            ((JTextField)MainFrame.this.fieldComp[2]).setBackground(new Color(0xFFFFFF));
            ((JComboBox)MainFrame.this.fieldComp[1]).setBackground(new Color(0xFFFFFF));
            ((JComboBox)MainFrame.this.fieldComp[1]).setEditable(true);
            ((JTextField)MainFrame.this.methodComp[2]).setBackground(new Color(0xFFFFFF));
            ((JComboBox)MainFrame.this.methodComp[1]).setBackground(new Color(0xFFFFFF));
            ((JComboBox)MainFrame.this.methodComp[1]).setEditable(true);
            ((JTextField)MainFrame.this.fieldComp[2]).setBackground(new Color(0xFFFFFF));
            ((JTextField)MainFrame.this.generalComp[5]).setBackground(Color.WHITE);
            ((JTextField)MainFrame.this.fieldComp[3]).setBackground(Color.WHITE);
            MainFrame.this.fieldList.clearSelection();
            MainFrame.this.constructorList.clearSelection();
            MainFrame.this.methodList.clearSelection();
            ((JComboBox)MainFrame.this.fieldComp[0]).setSelectedItem("");
            ((JComboBox)MainFrame.this.fieldComp[1]).setSelectedItem("");
            ((JTextField)MainFrame.this.fieldComp[2]).setText("");
            ((JTextField)MainFrame.this.fieldComp[3]).setText("");
            ((JCheckBox)MainFrame.this.fieldComp[4]).setSelected(false);
            ((JCheckBox)MainFrame.this.fieldComp[5]).setSelected(false);
            ((JCheckBox)MainFrame.this.fieldComp[6]).setSelected(false);
            ((JCheckBox)MainFrame.this.fieldComp[7]).setSelected(false);
            ((JRadioButton)MainFrame.this.fieldComp[8]).setSelected(true);
            ((JTextArea)MainFrame.this.fieldComp[10]).setText("");
            MainFrame.this.frontComment = "";
            MainFrame.this.rightComment = "";
            for (cnt = 0; cnt < MainFrame.this.fieldComp.length; ++cnt) {
                MainFrame.this.fieldComp[cnt].setEnabled(false);
            }
            ((JComboBox)MainFrame.this.methodComp[0]).setSelectedItem("");
            ((JComboBox)MainFrame.this.methodComp[1]).setSelectedItem("");
            ((JTextField)MainFrame.this.methodComp[2]).setText("");
            ((JCheckBox)MainFrame.this.methodComp[3]).setSelected(false);
            ((JCheckBox)MainFrame.this.methodComp[4]).setSelected(false);
            ((JCheckBox)MainFrame.this.methodComp[5]).setSelected(false);
            ((JCheckBox)MainFrame.this.methodComp[6]).setSelected(false);
            ((JCheckBox)MainFrame.this.methodComp[7]).setSelected(false);
            ((JCheckBox)MainFrame.this.methodComp[8]).setSelected(false);
            ((JTextArea)MainFrame.this.methodComp[9]).setText("");
            MainFrame.this.currOperatorName = "noname";
            MainFrame.this.currParameters = new Vector();
            for (cnt = 0; cnt < MainFrame.this.methodComp.length; ++cnt) {
                MainFrame.this.methodComp[cnt].setEnabled(false);
            }
            ((JComboBox)MainFrame.this.constructorComp[0]).setSelectedItem("");
            ((JTextField)MainFrame.this.constructorComp[1]).setText(MainFrame.this.coi.getClassNameOrInterfaceName());
            ((JTextArea)MainFrame.this.constructorComp[2]).setText("");
            MainFrame.this.currOperatorName = "noname";
            MainFrame.this.currParameters = new Vector();
            for (cnt = 0; cnt < MainFrame.this.constructorComp.length; ++cnt) {
                MainFrame.this.constructorComp[cnt].setEnabled(false);
            }
        }
    }

    public class OkBtn
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            int i;
            String className = ((JTextField)MainFrame.this.generalComp[1]).getText();
            int check = InterfaceChecker.isValid(((JTextField)MainFrame.this.generalComp[3]).getText());
            if (check == 1) {
                ((JTextField)MainFrame.this.generalComp[3]).setBackground(Color.YELLOW);
                MainFrame.this.lblMsg.setText(Message.SUPER_CLASS_ERROR_1);
                return;
            }
            if (check == 2) {
                ((JTextField)MainFrame.this.generalComp[3]).setBackground(Color.YELLOW);
                MainFrame.this.lblMsg.setText(Message.SUPER_CLASS_ERROR_2);
                return;
            }
            if (className.equals(((JTextField)MainFrame.this.generalComp[3]).getText())) {
                ((JTextField)MainFrame.this.generalComp[3]).setBackground(Color.YELLOW);
                MainFrame.this.lblMsg.setText(Message.SUPER_CLASS_ERROR_3 + className);
                return;
            }
            MainFrame.this.coi.setClassNameOrInterfaceName(((JTextField)MainFrame.this.generalComp[1]).getText());
            MainFrame.this.coi.setSuperClassName(((JTextField)MainFrame.this.generalComp[3]).getText().trim());
            String inputedPackage = ((JTextField)MainFrame.this.generalComp[5]).getText();
            inputedPackage = MainFrame.this.removeSpace(inputedPackage);
            check = InterfaceChecker.isValid(inputedPackage);
            if (check == 1) {
                ((JTextField)MainFrame.this.generalComp[5]).setBackground(Color.YELLOW);
                MainFrame.this.lblMsg.setText(Message.PACKAGE_ERROR_1);
                return;
            }
            if (check == 2) {
                ((JTextField)MainFrame.this.generalComp[5]).setBackground(Color.YELLOW);
                MainFrame.this.lblMsg.setText(Message.PACKAGE_ERROR_2);
                return;
            }
            MainFrame.this.coi.setPackage(inputedPackage);
            MainFrame.this.coi.setVisibility((String)((JComboBox)MainFrame.this.generalComp[2]).getSelectedItem());
            ListModel lm = ((JList)MainFrame.this.generalComp[4]).getModel();
            Vector input = new Vector();
            for (i = 0; i < lm.getSize(); ++i) {
                input.add(lm.getElementAt(i));
            }
            MainFrame.this.coi.setImplementedInterfaceNames(input);
            input = new Vector();
            lm = ((JList)MainFrame.this.generalComp[6]).getModel();
            for (i = 0; i < lm.getSize(); ++i) {
                input.add(lm.getElementAt(i));
            }
            MainFrame.this.coi.setImports(input);
            MainFrame.this.coi.setComments(((JTextArea)MainFrame.this.generalComp[7]).getText());
            MainFrame.this.coi.setFields(MainFrame.this.fieldListData);
            MainFrame.this.coi.setMethods(MainFrame.this.methodListData);
            MainFrame.this.coi.setConstructors(MainFrame.this.constructorListData);
            if (((JCheckBox)MainFrame.this.generalComp[8]).isSelected()) {
                MainFrame.this.coi.setFinal("final");
            } else {
                MainFrame.this.coi.setFinal("");
            }
            MainFrame.this.classwizard.print(MainFrame.this.coi);
            exit = true;
            MainFrame.this.myself.initCode();
            MainFrame.this.myself.setVisible(false);
            MainFrame.this.myself = null;
            MainFrame.this.classwizard.exit();
        }
    }

    public class CencelBtn
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            exit = true;
            MainFrame.this.myself.setVisible(false);
            MainFrame.this.myself = null;
            MainFrame.this.classwizard.exit();
        }
    }

    public class ParamBtn
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            MainFrame.this.parameterFrame = new ParameterFrame(MainFrame.this.currOperatorName, MainFrame.this.currParameters, MainFrame.this.myself);
        }
    }

    public class ApplyBtn
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            int i;
            MainFrame.this.coi.setClassNameOrInterfaceName(((JTextField)MainFrame.this.generalComp[1]).getText());
            String className = ((JTextField)MainFrame.this.generalComp[1]).getText();
            int check = InterfaceChecker.isValid(((JTextField)MainFrame.this.generalComp[3]).getText());
            if (check == 1) {
                ((JTextField)MainFrame.this.generalComp[3]).setBackground(Color.YELLOW);
                MainFrame.this.lblMsg.setText(Message.SUPER_CLASS_ERROR_1);
                return;
            }
            if (check == 2) {
                ((JTextField)MainFrame.this.generalComp[3]).setBackground(Color.YELLOW);
                MainFrame.this.lblMsg.setText(Message.SUPER_CLASS_ERROR_2);
                return;
            }
            if (className.equals(((JTextField)MainFrame.this.generalComp[3]).getText())) {
                ((JTextField)MainFrame.this.generalComp[3]).setBackground(Color.YELLOW);
                MainFrame.this.lblMsg.setText(Message.SUPER_CLASS_ERROR_3 + className);
                return;
            }
            MainFrame.this.coi.setSuperClassName(((JTextField)MainFrame.this.generalComp[3]).getText().trim());
            String inputedPackage = ((JTextField)MainFrame.this.generalComp[5]).getText();
            inputedPackage = MainFrame.this.removeSpace(inputedPackage);
            check = InterfaceChecker.isValid(inputedPackage);
            if (check == 1) {
                ((JTextField)MainFrame.this.generalComp[5]).setBackground(Color.YELLOW);
                MainFrame.this.lblMsg.setText(Message.PACKAGE_ERROR_1);
                return;
            }
            if (check == 2) {
                ((JTextField)MainFrame.this.generalComp[5]).setBackground(Color.YELLOW);
                MainFrame.this.lblMsg.setText(Message.PACKAGE_ERROR_2);
                return;
            }
            MainFrame.this.coi.setPackage(inputedPackage);
            MainFrame.this.coi.setVisibility((String)((JComboBox)MainFrame.this.generalComp[2]).getSelectedItem());
            ListModel lm = ((JList)MainFrame.this.generalComp[4]).getModel();
            Vector input = new Vector();
            for (i = 0; i < lm.getSize(); ++i) {
                input.add(lm.getElementAt(i));
            }
            if (MainFrame.this.strType.equals("class")) {
                MainFrame.this.coi.setImplementedInterfaceNames(input);
            } else {
                MainFrame.this.coi.setSuperInterfaceNames(input);
            }
            input = new Vector();
            lm = ((JList)MainFrame.this.generalComp[6]).getModel();
            for (i = 0; i < lm.getSize(); ++i) {
                input.add(lm.getElementAt(i));
            }
            MainFrame.this.coi.setImports(input);
            MainFrame.this.coi.setComments(((JTextArea)MainFrame.this.generalComp[7]).getText());
            MainFrame.this.coi.setFields(MainFrame.this.fieldListData);
            MainFrame.this.coi.setMethods(MainFrame.this.methodListData);
            MainFrame.this.coi.setConstructors(MainFrame.this.constructorListData);
            if (((JCheckBox)MainFrame.this.generalComp[8]).isSelected()) {
                MainFrame.this.coi.setFinal("final");
            } else {
                MainFrame.this.coi.setFinal("");
            }
            MainFrame.this.classwizard.print(MainFrame.this.coi);
            MainFrame.this.editor.loadFile();
            MainFrame.this.lblMsg.setText(Message.APPLY_BUTTON);
        }
    }

    public class RightComment
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            if (((JRadioButton)MainFrame.this.fieldComp[9]).isSelected()) {
                MainFrame.this.frontComment = ((JTextArea)MainFrame.this.fieldComp[10]).getText();
                ((JTextArea)MainFrame.this.fieldComp[10]).setText(MainFrame.this.rightComment);
            }
        }
    }

    public class FrontComment
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            if (((JRadioButton)MainFrame.this.fieldComp[8]).isSelected()) {
                MainFrame.this.rightComment = ((JTextArea)MainFrame.this.fieldComp[10]).getText();
                ((JTextArea)MainFrame.this.fieldComp[10]).setText(MainFrame.this.frontComment);
            }
        }
    }

    public class ConstructorListResetter
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            if (MainFrame.this.constructorMode == -1) {
                return;
            }
            if (MainFrame.this.constructorMode == 0) {
                ((JComboBox)MainFrame.this.constructorComp[0]).setSelectedItem("");
                ((JTextField)MainFrame.this.constructorComp[1]).setText(MainFrame.this.coi.getClassNameOrInterfaceName());
                ((JTextArea)MainFrame.this.constructorComp[2]).setText("");
                MainFrame.this.currOperatorName = "noname";
                MainFrame.this.currParameters = new Vector();
                MainFrame.this.lblMsg.setText(Message.RESET_BUTTON);
            } else if (MainFrame.this.constructorMode == 1) {
                int index = MainFrame.this.constructorList.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                for (int cnt = 0; cnt < MainFrame.this.constructorComp.length; ++cnt) {
                    MainFrame.this.constructorComp[cnt].setEnabled(true);
                }
                MainFrame.this.constructorComp[1].setEnabled(false);
                CWConstructor constructor = (CWConstructor)MainFrame.this.constructorListData.get(index);
                ((JComboBox)MainFrame.this.constructorComp[0]).setSelectedItem(constructor.getVisibility());
                ((JTextField)MainFrame.this.constructorComp[1]).setText(constructor.getOperatorName());
                ((JTextArea)MainFrame.this.constructorComp[2]).setText(constructor.getComments());
                MainFrame.this.currOperatorName = constructor.getOperatorName();
                MainFrame.this.currParameters = (Vector)constructor.getParameters().clone();
                MainFrame.this.lblMsg.setText(Message.RESET_BUTTON);
            }
        }
    }

    public class ConstructorListSetter
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            if (MainFrame.this.constructorMode == -1) {
                return;
            }
            CWConstructor constructor = new CWConstructor();
            Iterator constructorIte = MainFrame.this.currParameters.iterator();
            while (constructorIte.hasNext()) {
                CWParameter p = (CWParameter)constructorIte.next();
                MainFrame.this.paramOverlap = MainFrame.this.paramOverlap + p.getType();
                if (!constructorIte.hasNext()) continue;
                MainFrame.this.paramOverlap = MainFrame.this.paramOverlap + " ";
            }
            if (MainFrame.this.constructorMode == 0 && MainFrame.this.vecConstructorOverlap.indexOf(MainFrame.this.paramOverlap) >= 0) {
                MainFrame.this.lblMsg.setText(MainFrame.this.coi.getClassNameOrInterfaceName() + "(" + MainFrame.this.paramOverlap + ")" + Message.CONSTRUCTOR_ERROR_1 + MainFrame.this.coi.getClassNameOrInterfaceName());
                MainFrame.this.paramOverlap = "";
                return;
            }
            if (MainFrame.this.constructorMode == 1 && MainFrame.this.vecConstructorOverlap.indexOf(MainFrame.this.paramOverlap) >= 0 && MainFrame.this.vecConstructorOverlap.indexOf(MainFrame.this.paramOverlap) != MainFrame.this.overlapIndex) {
                MainFrame.this.lblMsg.setText(MainFrame.this.coi.getClassNameOrInterfaceName() + "(" + MainFrame.this.paramOverlap + ")" + Message.CONSTRUCTOR_ERROR_1 + MainFrame.this.coi.getClassNameOrInterfaceName());
                MainFrame.this.paramOverlap = "";
                return;
            }
            if (MainFrame.this.constructorMode == 0 && MainFrame.this.vecConstructorOverlap.indexOf(MainFrame.this.paramOverlap) < 0) {
                MainFrame.this.vecConstructorOverlap.add(MainFrame.this.paramOverlap);
            }
            if (MainFrame.this.constructorMode == 1 && MainFrame.this.vecConstructorOverlap.indexOf(MainFrame.this.paramOverlap) < 0) {
                MainFrame.this.vecConstructorOverlap.set(MainFrame.this.overlapIndex, MainFrame.this.paramOverlap);
            }
            MainFrame.this.paramOverlap = "";
            constructor.setVisibility((String)((JComboBox)MainFrame.this.constructorComp[0]).getSelectedItem());
            constructor.setOperatorName(((JTextField)MainFrame.this.constructorComp[1]).getText());
            constructor.setComments(((JTextArea)MainFrame.this.constructorComp[2]).getText());
            constructor.setParameters(MainFrame.this.currParameters);
            if (MainFrame.this.constructorMode == 0) {
                constructor.setBody("{\n}");
                MainFrame.this.constructorListData.add(constructor);
            } else if (MainFrame.this.constructorMode == 1) {
                int index = MainFrame.this.constructorList.getSelectedIndex();
                CWConstructor c = (CWConstructor)MainFrame.this.constructorListData.get(index);
                constructor.setBody(c.getBody());
                MainFrame.this.constructorListData.remove(index);
                MainFrame.this.constructorListData.add(index, constructor);
            }
            Vector<String> constructorNameList = new Vector<String>();
            Iterator i = MainFrame.this.constructorListData.iterator();
            while (i.hasNext()) {
                CWConstructor aconstructor = (CWConstructor)i.next();
                String name = aconstructor.getOperatorName();
                String visibility = aconstructor.getVisibility();
                if (visibility.equals("private")) {
                    name = "-" + name;
                } else if (visibility.equals("protected")) {
                    name = "#" + name;
                } else if (visibility.equals("public")) {
                    name = "+" + name;
                } else if (visibility.equals("")) {
                    name = "~" + name;
                }
                name = name + "(";
                Iterator ii = aconstructor.getParameters().iterator();
                while (ii.hasNext()) {
                    CWParameter p = (CWParameter)ii.next();
                    name = name + p.getParameterName() + " : " + p.getType();
                    if (!ii.hasNext()) continue;
                    name = name + ", ";
                }
                name = name + ")";
                constructorNameList.add(name);
            }
            MainFrame.this.constructorList.setListData(constructorNameList);
            MainFrame.this.constructorMode = -1;
            MainFrame.this.constructorList.setSelectedIndex(-1);
            for (int cnt = 0; cnt < MainFrame.this.constructorComp.length; ++cnt) {
                MainFrame.this.constructorComp[cnt].setEnabled(false);
            }
            MainFrame.this.lblMsg.setText(Message.SET_BUTTON);
        }
    }

    public class ConstructorListDeler
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            ListModel model = MainFrame.this.constructorList.getModel();
            int index = MainFrame.this.constructorList.getSelectedIndex();
            if (index == -1) {
                return;
            }
            String[] input = new String[model.getSize() - 1];
            int j = 0;
            for (int i = 0; i < model.getSize(); ++i) {
                if (i == index) continue;
                input[++j - 1] = (String)model.getElementAt(i);
            }
            MainFrame.this.constructorList.setSelectedIndex(-1);
            MainFrame.this.constructorList.setListData(input);
            MainFrame.this.constructorListData.remove(index);
            MainFrame.this.lblMsg.setText(Message.DELETE_BUTTON);
            MainFrame.this.vecConstructorOverlap.remove(index);
        }
    }

    public class ConstructorListModifier
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            MainFrame.this.constructorMode = 1;
            int index = MainFrame.this.constructorList.getSelectedIndex();
            MainFrame.this.overlapIndex = index;
            if (index == -1) {
                return;
            }
            for (int cnt = 0; cnt < MainFrame.this.constructorComp.length; ++cnt) {
                MainFrame.this.constructorComp[cnt].setEnabled(true);
            }
            MainFrame.this.constructorComp[1].setEnabled(false);
            CWConstructor constructor = (CWConstructor)MainFrame.this.constructorListData.get(index);
            ((JComboBox)MainFrame.this.constructorComp[0]).setSelectedItem(constructor.getVisibility());
            ((JTextField)MainFrame.this.constructorComp[1]).setText(constructor.getOperatorName());
            ((JTextArea)MainFrame.this.constructorComp[2]).setText(constructor.getComments());
            MainFrame.this.currOperatorName = constructor.getOperatorName();
            MainFrame.this.currParameters = (Vector)constructor.getParameters().clone();
        }
    }

    public class ConstructorListAdder
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            MainFrame.this.constructorMode = 0;
            for (int cnt = 0; cnt < MainFrame.this.constructorComp.length; ++cnt) {
                MainFrame.this.constructorComp[cnt].setEnabled(true);
            }
            MainFrame.this.constructorComp[1].setEnabled(false);
            ((JComboBox)MainFrame.this.constructorComp[0]).setSelectedItem("");
            ((JTextField)MainFrame.this.constructorComp[1]).setText(MainFrame.this.coi.getClassNameOrInterfaceName());
            ((JTextArea)MainFrame.this.constructorComp[2]).setText("");
            MainFrame.this.currOperatorName = "noname";
            MainFrame.this.currParameters = new Vector();
        }
    }

    public class ConstructorListListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent arg0) {
            MainFrame.this.constructorMode = -1;
            int index = MainFrame.this.constructorList.getSelectedIndex();
            if (index == -1) {
                return;
            }
            for (int cnt = 0; cnt < MainFrame.this.constructorComp.length; ++cnt) {
                MainFrame.this.constructorComp[cnt].setEnabled(false);
            }
            CWConstructor constructor = (CWConstructor)MainFrame.this.constructorListData.get(index);
            ((JComboBox)MainFrame.this.constructorComp[0]).setSelectedItem(constructor.getVisibility());
            ((JTextField)MainFrame.this.constructorComp[1]).setText(constructor.getOperatorName());
            ((JTextArea)MainFrame.this.constructorComp[2]).setText(constructor.getComments());
        }
    }

    public class MethodListResetter
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            MainFrame.this.initMethodCheckBox();
            if (MainFrame.this.methodMode == -1) {
                return;
            }
            if (MainFrame.this.methodMode == 0) {
                ((JComboBox)MainFrame.this.methodComp[0]).setSelectedItem("");
                ((JComboBox)MainFrame.this.methodComp[1]).setSelectedItem("");
                ((JTextField)MainFrame.this.methodComp[2]).setText("");
                ((JCheckBox)MainFrame.this.methodComp[3]).setSelected(false);
                ((JCheckBox)MainFrame.this.methodComp[4]).setSelected(false);
                ((JCheckBox)MainFrame.this.methodComp[5]).setSelected(false);
                ((JCheckBox)MainFrame.this.methodComp[6]).setSelected(false);
                ((JCheckBox)MainFrame.this.methodComp[7]).setSelected(false);
                ((JCheckBox)MainFrame.this.methodComp[8]).setSelected(false);
                ((JTextArea)MainFrame.this.methodComp[9]).setText("");
                MainFrame.this.currOperatorName = "noname";
                MainFrame.this.currParameters = new Vector();
                MainFrame.this.lblMsg.setText(Message.RESET_BUTTON);
            } else if (MainFrame.this.methodMode == 1) {
                int index = MainFrame.this.methodList.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                for (int cnt = 0; cnt < MainFrame.this.methodComp.length; ++cnt) {
                    MainFrame.this.methodComp[cnt].setEnabled(true);
                }
                CWMethod method = (CWMethod)MainFrame.this.methodListData.get(index);
                ((JComboBox)MainFrame.this.methodComp[0]).setSelectedItem(method.getVisibility());
                ((JComboBox)MainFrame.this.methodComp[1]).setSelectedItem(method.getReturnType());
                ((JTextField)MainFrame.this.methodComp[2]).setText(method.getOperatorName());
                if (method.getStatic().equals("")) {
                    ((JCheckBox)MainFrame.this.methodComp[3]).setSelected(false);
                } else {
                    ((JCheckBox)MainFrame.this.methodComp[3]).setSelected(true);
                }
                if (method.getAbstract().equals("")) {
                    ((JCheckBox)MainFrame.this.methodComp[4]).setSelected(false);
                } else {
                    ((JCheckBox)MainFrame.this.methodComp[4]).setSelected(true);
                }
                if (method.getStrictfp().equals("")) {
                    ((JCheckBox)MainFrame.this.methodComp[5]).setSelected(false);
                } else {
                    ((JCheckBox)MainFrame.this.methodComp[5]).setSelected(true);
                }
                if (method.getFinal().equals("")) {
                    ((JCheckBox)MainFrame.this.methodComp[6]).setSelected(false);
                } else {
                    ((JCheckBox)MainFrame.this.methodComp[6]).setSelected(true);
                }
                if (method.getNative().equals("")) {
                    ((JCheckBox)MainFrame.this.methodComp[7]).setSelected(false);
                } else {
                    ((JCheckBox)MainFrame.this.methodComp[7]).setSelected(true);
                }
                if (method.getSynchronized().equals("")) {
                    ((JCheckBox)MainFrame.this.methodComp[8]).setSelected(false);
                } else {
                    ((JCheckBox)MainFrame.this.methodComp[8]).setSelected(true);
                }
                ((JTextArea)MainFrame.this.methodComp[9]).setText(method.getComments());
                MainFrame.this.currOperatorName = method.getOperatorName();
                MainFrame.this.currParameters = (Vector)method.getParameters().clone();
                MainFrame.this.lblMsg.setText(Message.RESET_BUTTON);
                if (((JCheckBox)MainFrame.this.methodComp[4]).isSelected()) {
                    ((JCheckBox)MainFrame.this.methodComp[3]).setEnabled(false);
                    ((JCheckBox)MainFrame.this.methodComp[5]).setEnabled(false);
                    ((JCheckBox)MainFrame.this.methodComp[6]).setEnabled(false);
                    ((JCheckBox)MainFrame.this.methodComp[7]).setEnabled(false);
                    ((JCheckBox)MainFrame.this.methodComp[8]).setEnabled(false);
                    ((JCheckBox)MainFrame.this.methodComp[3]).increase();
                    ((JCheckBox)MainFrame.this.methodComp[5]).increase();
                    ((JCheckBox)MainFrame.this.methodComp[6]).increase();
                    ((JCheckBox)MainFrame.this.methodComp[7]).increase();
                    ((JCheckBox)MainFrame.this.methodComp[8]).increase();
                }
                if (((JCheckBox)MainFrame.this.methodComp[5]).isSelected()) {
                    ((JCheckBox)MainFrame.this.methodComp[4]).setEnabled(false);
                    ((JCheckBox)MainFrame.this.methodComp[7]).setEnabled(false);
                    ((JCheckBox)MainFrame.this.methodComp[4]).increase();
                    ((JCheckBox)MainFrame.this.methodComp[7]).increase();
                }
                if (((JCheckBox)MainFrame.this.methodComp[7]).isSelected()) {
                    ((JCheckBox)MainFrame.this.methodComp[4]).setEnabled(false);
                    ((JCheckBox)MainFrame.this.methodComp[5]).setEnabled(false);
                    ((JCheckBox)MainFrame.this.methodComp[4]).increase();
                    ((JCheckBox)MainFrame.this.methodComp[5]).increase();
                }
                if (((JCheckBox)MainFrame.this.methodComp[3]).isSelected()) {
                    ((JCheckBox)MainFrame.this.methodComp[4]).setEnabled(false);
                    ((JCheckBox)MainFrame.this.methodComp[4]).increase();
                }
                if (((JCheckBox)MainFrame.this.methodComp[6]).isSelected()) {
                    ((JCheckBox)MainFrame.this.methodComp[4]).setEnabled(false);
                    ((JCheckBox)MainFrame.this.methodComp[4]).increase();
                }
                if (((JCheckBox)MainFrame.this.methodComp[8]).isSelected()) {
                    ((JCheckBox)MainFrame.this.methodComp[4]).setEnabled(false);
                    ((JCheckBox)MainFrame.this.methodComp[4]).increase();
                }
            }
        }
    }

    public class MethodListSetter
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            int check;
            if (MainFrame.this.methodMode == -1) {
                return;
            }
            String methodOverlap = "";
            CWMethod method = new CWMethod();
            method.setVisibility((String)((JComboBox)MainFrame.this.methodComp[0]).getSelectedItem());
            String returnType = (String)((JComboBox)MainFrame.this.methodComp[1]).getSelectedItem();
            returnType = returnType.trim();
            returnType = MainFrame.this.removeSpace(returnType);
            ((JComboBox)MainFrame.this.methodComp[1]).setSelectedItem(returnType);
            String returnTypeA = "";
            String returnTypeB = "";
            int indexOfKeh = returnType.indexOf("[]");
            if (indexOfKeh != -1) {
                returnTypeA = returnType.substring(0, indexOfKeh);
                returnTypeB = returnType.substring(indexOfKeh, returnType.length());
                if (!ArrayChecker.isArrayValid(returnTypeB)) {
                    MainFrame.this.lblMsg.setText(Message.METHOD_ERROR_1);
                    ((JComboBox)MainFrame.this.methodComp[1]).setEditable(false);
                    ((JComboBox)MainFrame.this.methodComp[1]).setBackground(Color.YELLOW);
                    return;
                }
                if (!ReturnTypeChecker.isValid(returnTypeA)) {
                    MainFrame.this.lblMsg.setText(Message.METHOD_ERROR_2);
                    ((JComboBox)MainFrame.this.methodComp[1]).setEditable(false);
                    ((JComboBox)MainFrame.this.methodComp[1]).setBackground(Color.YELLOW);
                    return;
                }
                if (returnTypeA.equals("void")) {
                    MainFrame.this.lblMsg.setText(Message.METHOD_ERROR_3);
                    ((JComboBox)MainFrame.this.methodComp[1]).setEditable(false);
                    ((JComboBox)MainFrame.this.methodComp[1]).setBackground(Color.YELLOW);
                    return;
                }
            } else {
                returnTypeA = returnType;
            }
            if ((check = WordChecker.isValid(returnTypeA)) == 1) {
                MainFrame.this.lblMsg.setText(Message.METHOD_ERROR_1);
                ((JComboBox)MainFrame.this.methodComp[1]).setEditable(false);
                ((JComboBox)MainFrame.this.methodComp[1]).setBackground(Color.YELLOW);
                return;
            }
            if (!ReturnTypeChecker.isValid((String)((JComboBox)MainFrame.this.methodComp[1]).getSelectedItem())) {
                MainFrame.this.lblMsg.setText(Message.METHOD_ERROR_2);
                ((JComboBox)MainFrame.this.methodComp[1]).setEditable(false);
                ((JComboBox)MainFrame.this.methodComp[1]).setBackground(Color.YELLOW);
                return;
            }
            method.setReturnType((String)((JComboBox)MainFrame.this.methodComp[1]).getSelectedItem());
            ((JTextField)MainFrame.this.methodComp[2]).setText(MainFrame.this.removeSpace(((JTextField)MainFrame.this.methodComp[2]).getText()));
            methodOverlap = ((JTextField)MainFrame.this.methodComp[2]).getText().trim();
            Iterator paramIte = MainFrame.this.currParameters.iterator();
            while (paramIte.hasNext()) {
                CWParameter p = (CWParameter)paramIte.next();
                MainFrame.this.paramOverlap = MainFrame.this.paramOverlap + (" " + p.getType());
            }
            methodOverlap = methodOverlap + MainFrame.this.paramOverlap;
            if (MainFrame.this.methodMode == 0 && MainFrame.this.vecMethodOverlap.indexOf(methodOverlap) >= 0) {
                ((JTextField)MainFrame.this.methodComp[2]).setBackground(Color.YELLOW);
                MainFrame.this.lblMsg.setText(((JTextField)MainFrame.this.methodComp[2]).getText() + "(" + MainFrame.this.paramOverlap + ")" + Message.METHOD_ERROR_4 + MainFrame.this.coi.getClassNameOrInterfaceName());
                MainFrame.this.paramOverlap = "";
                methodOverlap = "";
                return;
            }
            if (MainFrame.this.methodMode == 1 && MainFrame.this.vecMethodOverlap.indexOf(methodOverlap) >= 0 && MainFrame.this.vecMethodOverlap.indexOf(methodOverlap) != MainFrame.this.overlapIndex) {
                ((JTextField)MainFrame.this.methodComp[2]).setBackground(Color.YELLOW);
                MainFrame.this.lblMsg.setText(((JTextField)MainFrame.this.methodComp[2]).getText() + "(" + MainFrame.this.paramOverlap + ")" + Message.METHOD_ERROR_4 + MainFrame.this.coi.getClassNameOrInterfaceName());
                MainFrame.this.paramOverlap = "";
                methodOverlap = "";
                return;
            }
            if (MainFrame.this.methodMode == 0 && MainFrame.this.vecMethodOverlap.indexOf(methodOverlap) < 0) {
                MainFrame.this.vecMethodOverlap.add(methodOverlap);
            }
            if (MainFrame.this.methodMode == 1 && MainFrame.this.vecMethodOverlap.indexOf(methodOverlap) < 0) {
                MainFrame.this.vecMethodOverlap.set(MainFrame.this.overlapIndex, methodOverlap);
            }
            MainFrame.this.paramOverlap = "";
            methodOverlap = "";
            check = WordChecker.isValid(((JTextField)MainFrame.this.methodComp[2]).getText());
            if (check == 1) {
                MainFrame.this.lblMsg.setText(Message.METHOD_ERROR_5);
                ((JTextField)MainFrame.this.methodComp[2]).setBackground(Color.YELLOW);
                return;
            }
            if (check == 2) {
                MainFrame.this.lblMsg.setText(Message.METHOD_ERROR_6);
                ((JTextField)MainFrame.this.methodComp[2]).setBackground(Color.YELLOW);
                return;
            }
            if (!MainFrame.this.coi.getAbstract().equals("abstract") && !MainFrame.this.coi.getType().equals("interface")) {
                ((JCheckBox)MainFrame.this.methodComp[4]).setEnabled(false);
                ((JCheckBox)MainFrame.this.methodComp[4]).setSelected(false);
            }
            method.setOperatorName(((JTextField)MainFrame.this.methodComp[2]).getText().trim());
            if (((JCheckBox)MainFrame.this.methodComp[3]).isSelected()) {
                method.setStatic("static");
            } else {
                method.setStatic("");
            }
            if (((JCheckBox)MainFrame.this.methodComp[4]).isSelected()) {
                method.setAbstract("abstract");
            } else {
                method.setAbstract("");
            }
            if (((JCheckBox)MainFrame.this.methodComp[5]).isSelected()) {
                method.setStrictfp("strictfp");
            } else {
                method.setStrictfp("");
            }
            if (((JCheckBox)MainFrame.this.methodComp[6]).isSelected()) {
                method.setFinal("final");
            } else {
                method.setFinal("");
            }
            if (((JCheckBox)MainFrame.this.methodComp[7]).isSelected()) {
                method.setNative("native");
            } else {
                method.setNative("");
            }
            if (((JCheckBox)MainFrame.this.methodComp[8]).isSelected()) {
                method.setSynchronized("synchronized");
            } else {
                method.setSynchronized("");
            }
            method.setComments(((JTextArea)MainFrame.this.methodComp[9]).getText());
            method.setParameters(MainFrame.this.currParameters);
            if (MainFrame.this.methodMode == 0) {
                method.setBody("{\n}");
                MainFrame.this.methodListData.add(method);
            } else if (MainFrame.this.methodMode == 1) {
                int index = MainFrame.this.methodList.getSelectedIndex();
                CWMethod m = (CWMethod)MainFrame.this.methodListData.get(index);
                method.setBody(m.getBody());
                MainFrame.this.methodListData.remove(index);
                MainFrame.this.methodListData.add(index, method);
            }
            Vector<String> methodNameList = new Vector<String>();
            Iterator i = MainFrame.this.methodListData.iterator();
            while (i.hasNext()) {
                CWMethod amethod = (CWMethod)i.next();
                String name = amethod.getOperatorName();
                String visibility = amethod.getVisibility();
                if (visibility.equals("private")) {
                    name = "-" + name;
                } else if (visibility.equals("protected")) {
                    name = "#" + name;
                } else if (visibility.equals("public")) {
                    name = "+" + name;
                } else if (visibility.equals("")) {
                    name = "~" + name;
                }
                name = name + "(";
                Iterator ii = amethod.getParameters().iterator();
                while (ii.hasNext()) {
                    CWParameter p = (CWParameter)ii.next();
                    name = name + p.getParameterName() + " : " + p.getType();
                    if (!ii.hasNext()) continue;
                    name = name + ", ";
                }
                name = name + ")";
                name = name + " : " + amethod.getReturnType();
                methodNameList.add(name);
            }
            MainFrame.this.methodList.setListData(methodNameList);
            MainFrame.this.methodList.setCellRenderer(new MethodCellRenderer(MainFrame.this.methodListData));
            MainFrame.this.methodMode = -1;
            MainFrame.this.methodList.setSelectedIndex(-1);
            for (int cnt = 0; cnt < MainFrame.this.methodComp.length; ++cnt) {
                MainFrame.this.methodComp[cnt].setEnabled(false);
            }
            MainFrame.this.lblMsg.setText(Message.SET_BUTTON);
        }
    }

    public class MethodListDeler
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            ListModel model = MainFrame.this.methodList.getModel();
            int index = MainFrame.this.methodList.getSelectedIndex();
            if (index == -1) {
                return;
            }
            String[] input = new String[model.getSize() - 1];
            int j = 0;
            for (int i = 0; i < model.getSize(); ++i) {
                if (i == index) continue;
                input[++j - 1] = (String)model.getElementAt(i);
            }
            MainFrame.this.methodList.setSelectedIndex(-1);
            MainFrame.this.methodList.setListData(input);
            MainFrame.this.methodListData.remove(index);
            ((JComboBox)MainFrame.this.methodComp[0]).setSelectedItem("");
            ((JComboBox)MainFrame.this.methodComp[1]).setSelectedItem("");
            ((JTextField)MainFrame.this.methodComp[2]).setText("");
            ((JCheckBox)MainFrame.this.methodComp[3]).setSelected(false);
            ((JCheckBox)MainFrame.this.methodComp[4]).setSelected(false);
            ((JCheckBox)MainFrame.this.methodComp[5]).setSelected(false);
            ((JCheckBox)MainFrame.this.methodComp[6]).setSelected(false);
            ((JCheckBox)MainFrame.this.methodComp[7]).setSelected(false);
            ((JCheckBox)MainFrame.this.methodComp[8]).setSelected(false);
            MainFrame.this.lblMsg.setText(Message.DELETE_BUTTON);
            MainFrame.this.vecMethodOverlap.remove(index);
        }
    }

    public class MethodListModifier
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            MainFrame.this.initMethodCheckBox();
            MainFrame.this.methodMode = 1;
            int index = MainFrame.this.methodList.getSelectedIndex();
            if (index == -1) {
                return;
            }
            for (int cnt = 0; cnt < MainFrame.this.methodComp.length; ++cnt) {
                MainFrame.this.methodComp[cnt].setEnabled(true);
            }
            CWMethod method = (CWMethod)MainFrame.this.methodListData.get(index);
            ((JComboBox)MainFrame.this.methodComp[0]).setSelectedItem(method.getVisibility());
            ((JComboBox)MainFrame.this.methodComp[1]).setSelectedItem(method.getReturnType());
            ((JTextField)MainFrame.this.methodComp[2]).setText(method.getOperatorName());
            if (method.getStatic().equals("")) {
                ((JCheckBox)MainFrame.this.methodComp[3]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.methodComp[3]).setSelected(true);
            }
            if (method.getAbstract().equals("")) {
                ((JCheckBox)MainFrame.this.methodComp[4]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.methodComp[4]).setSelected(true);
            }
            if (method.getStrictfp().equals("")) {
                ((JCheckBox)MainFrame.this.methodComp[5]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.methodComp[5]).setSelected(true);
            }
            if (method.getFinal().equals("")) {
                ((JCheckBox)MainFrame.this.methodComp[6]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.methodComp[6]).setSelected(true);
            }
            if (method.getNative().equals("")) {
                ((JCheckBox)MainFrame.this.methodComp[7]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.methodComp[7]).setSelected(true);
            }
            if (method.getSynchronized().equals("")) {
                ((JCheckBox)MainFrame.this.methodComp[8]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.methodComp[8]).setSelected(true);
            }
            ((JTextArea)MainFrame.this.methodComp[9]).setText(method.getComments());
            MainFrame.this.currOperatorName = method.getOperatorName();
            if (method.getParameters() == null) {
                JOptionPane.showMessageDialog(null, "method.getParameters() == null");
            }
            MainFrame.this.currParameters = (Vector)method.getParameters().clone();
            if (MainFrame.this.strType.equals("interface")) {
                MainFrame.this.methodComp[3].setEnabled(false);
                MainFrame.this.methodComp[5].setEnabled(false);
                MainFrame.this.methodComp[6].setEnabled(false);
                MainFrame.this.methodComp[7].setEnabled(false);
                MainFrame.this.methodComp[8].setEnabled(false);
            }
            if (((JCheckBox)MainFrame.this.methodComp[4]).isSelected()) {
                ((JCheckBox)MainFrame.this.methodComp[3]).setEnabled(false);
                ((JCheckBox)MainFrame.this.methodComp[5]).setEnabled(false);
                ((JCheckBox)MainFrame.this.methodComp[6]).setEnabled(false);
                ((JCheckBox)MainFrame.this.methodComp[7]).setEnabled(false);
                ((JCheckBox)MainFrame.this.methodComp[8]).setEnabled(false);
                ((JCheckBox)MainFrame.this.methodComp[3]).increase();
                ((JCheckBox)MainFrame.this.methodComp[5]).increase();
                ((JCheckBox)MainFrame.this.methodComp[6]).increase();
                ((JCheckBox)MainFrame.this.methodComp[7]).increase();
                ((JCheckBox)MainFrame.this.methodComp[8]).increase();
            }
            if (((JCheckBox)MainFrame.this.methodComp[5]).isSelected()) {
                ((JCheckBox)MainFrame.this.methodComp[4]).setEnabled(false);
                ((JCheckBox)MainFrame.this.methodComp[7]).setEnabled(false);
                ((JCheckBox)MainFrame.this.methodComp[4]).increase();
                ((JCheckBox)MainFrame.this.methodComp[7]).increase();
            }
            if (((JCheckBox)MainFrame.this.methodComp[7]).isSelected()) {
                ((JCheckBox)MainFrame.this.methodComp[4]).setEnabled(false);
                ((JCheckBox)MainFrame.this.methodComp[5]).setEnabled(false);
                ((JCheckBox)MainFrame.this.methodComp[4]).increase();
                ((JCheckBox)MainFrame.this.methodComp[5]).increase();
            }
            if (((JCheckBox)MainFrame.this.methodComp[3]).isSelected()) {
                ((JCheckBox)MainFrame.this.methodComp[4]).setEnabled(false);
                ((JCheckBox)MainFrame.this.methodComp[4]).increase();
            }
            if (((JCheckBox)MainFrame.this.methodComp[6]).isSelected()) {
                ((JCheckBox)MainFrame.this.methodComp[4]).setEnabled(false);
                ((JCheckBox)MainFrame.this.methodComp[4]).increase();
            }
            if (((JCheckBox)MainFrame.this.methodComp[8]).isSelected()) {
                ((JCheckBox)MainFrame.this.methodComp[4]).setEnabled(false);
                ((JCheckBox)MainFrame.this.methodComp[4]).increase();
            }
            if (MainFrame.this.coi.getFinal().equals("final")) {
                ((JCheckBox)MainFrame.this.methodComp[4]).setEnabled(false);
                ((JCheckBox)MainFrame.this.methodComp[4]).setSelected(false);
            }
            if (!MainFrame.this.coi.getAbstract().equals("abstract") && !MainFrame.this.coi.getType().equals("interface")) {
                ((JCheckBox)MainFrame.this.methodComp[4]).setEnabled(false);
                ((JCheckBox)MainFrame.this.methodComp[4]).setSelected(false);
            }
        }
    }

    public class MethodListAdder
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            MainFrame.this.initMethodCheckBox();
            MainFrame.this.methodMode = 0;
            for (int cnt = 0; cnt < MainFrame.this.methodComp.length; ++cnt) {
                MainFrame.this.methodComp[cnt].setEnabled(true);
            }
            ((JComboBox)MainFrame.this.methodComp[0]).setSelectedItem("");
            ((JComboBox)MainFrame.this.methodComp[1]).setSelectedItem("");
            ((JTextField)MainFrame.this.methodComp[2]).setText("");
            ((JCheckBox)MainFrame.this.methodComp[3]).setSelected(false);
            ((JCheckBox)MainFrame.this.methodComp[4]).setSelected(false);
            if (MainFrame.this.coi.getFinal().equals("final")) {
                ((JCheckBox)MainFrame.this.methodComp[4]).setEnabled(false);
            }
            ((JCheckBox)MainFrame.this.methodComp[5]).setSelected(false);
            ((JCheckBox)MainFrame.this.methodComp[6]).setSelected(false);
            ((JCheckBox)MainFrame.this.methodComp[7]).setSelected(false);
            ((JCheckBox)MainFrame.this.methodComp[8]).setSelected(false);
            ((JTextArea)MainFrame.this.methodComp[9]).setText("");
            MainFrame.this.currOperatorName = "noname";
            MainFrame.this.currParameters = new Vector();
            if (MainFrame.this.strType.equals("interface")) {
                MainFrame.this.methodComp[3].setEnabled(false);
                MainFrame.this.methodComp[5].setEnabled(false);
                MainFrame.this.methodComp[6].setEnabled(false);
                MainFrame.this.methodComp[7].setEnabled(false);
                MainFrame.this.methodComp[8].setEnabled(false);
            }
        }
    }

    public class MethodListListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent arg0) {
            MainFrame.this.methodMode = -1;
            int index = MainFrame.this.methodList.getSelectedIndex();
            MainFrame.this.overlapIndex = index;
            if (index == -1) {
                return;
            }
            for (int cnt = 0; cnt < MainFrame.this.methodComp.length; ++cnt) {
                MainFrame.this.methodComp[cnt].setEnabled(false);
            }
            CWMethod method = (CWMethod)MainFrame.this.methodListData.get(index);
            ((JComboBox)MainFrame.this.methodComp[0]).setSelectedItem(method.getVisibility());
            ((JComboBox)MainFrame.this.methodComp[1]).setSelectedItem(method.getReturnType());
            ((JTextField)MainFrame.this.methodComp[2]).setText(method.getOperatorName());
            if (method.getStatic().equals("")) {
                ((JCheckBox)MainFrame.this.methodComp[3]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.methodComp[3]).setSelected(true);
            }
            if (method.getAbstract().equals("")) {
                ((JCheckBox)MainFrame.this.methodComp[4]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.methodComp[4]).setSelected(true);
            }
            if (method.getStrictfp().equals("")) {
                ((JCheckBox)MainFrame.this.methodComp[5]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.methodComp[5]).setSelected(true);
            }
            if (method.getFinal().equals("")) {
                ((JCheckBox)MainFrame.this.methodComp[6]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.methodComp[6]).setSelected(true);
            }
            if (method.getNative().equals("")) {
                ((JCheckBox)MainFrame.this.methodComp[7]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.methodComp[7]).setSelected(true);
            }
            if (method.getSynchronized().equals("")) {
                ((JCheckBox)MainFrame.this.methodComp[8]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.methodComp[8]).setSelected(true);
            }
            ((JTextArea)MainFrame.this.methodComp[9]).setText(method.getComments());
        }
    }

    public class FieldListResetter
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            MainFrame.this.initFieldCheckBox();
            if (MainFrame.this.fieldMode == -1) {
                return;
            }
            if (MainFrame.this.fieldMode == 0) {
                ((JComboBox)MainFrame.this.fieldComp[0]).setSelectedItem("");
                ((JComboBox)MainFrame.this.fieldComp[1]).setSelectedItem("");
                ((JTextField)MainFrame.this.fieldComp[2]).setText("");
                ((JTextField)MainFrame.this.fieldComp[3]).setText("");
                ((JCheckBox)MainFrame.this.fieldComp[4]).setSelected(false);
                ((JCheckBox)MainFrame.this.fieldComp[5]).setSelected(false);
                ((JCheckBox)MainFrame.this.fieldComp[6]).setSelected(false);
                ((JCheckBox)MainFrame.this.fieldComp[7]).setSelected(false);
                ((JRadioButton)MainFrame.this.fieldComp[8]).setSelected(true);
                ((JTextArea)MainFrame.this.fieldComp[10]).setText("");
                MainFrame.this.frontComment = "";
                MainFrame.this.rightComment = "";
                MainFrame.this.lblMsg.setText(Message.RESET_BUTTON);
            } else if (MainFrame.this.fieldMode == 1) {
                int index = MainFrame.this.fieldList.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                for (int cnt = 0; cnt < MainFrame.this.fieldComp.length; ++cnt) {
                    MainFrame.this.fieldComp[cnt].setEnabled(true);
                }
                CWField field = (CWField)MainFrame.this.fieldListData.get(index);
                ((JComboBox)MainFrame.this.fieldComp[0]).setSelectedItem(field.getVisibility());
                ((JComboBox)MainFrame.this.fieldComp[1]).setSelectedItem(field.getType());
                ((JTextField)MainFrame.this.fieldComp[2]).setText(field.getName());
                ((JTextField)MainFrame.this.fieldComp[3]).setText(field.getInitialValue());
                if (field.getStatic().equals("")) {
                    ((JCheckBox)MainFrame.this.fieldComp[4]).setSelected(false);
                } else {
                    ((JCheckBox)MainFrame.this.fieldComp[4]).setSelected(true);
                }
                if (field.getFinal().equals("")) {
                    ((JCheckBox)MainFrame.this.fieldComp[5]).setSelected(false);
                } else {
                    ((JCheckBox)MainFrame.this.fieldComp[5]).setSelected(true);
                }
                if (field.getTransient().equals("")) {
                    ((JCheckBox)MainFrame.this.fieldComp[6]).setSelected(false);
                } else {
                    ((JCheckBox)MainFrame.this.fieldComp[6]).setSelected(true);
                }
                if (field.getVolatile().equals("")) {
                    ((JCheckBox)MainFrame.this.fieldComp[7]).setSelected(false);
                } else {
                    ((JCheckBox)MainFrame.this.fieldComp[7]).setSelected(true);
                }
                ((JRadioButton)MainFrame.this.fieldComp[8]).setSelected(true);
                ((JTextArea)MainFrame.this.fieldComp[10]).setText(field.getFrontComments());
                MainFrame.this.frontComment = "";
                MainFrame.this.rightComment = field.getRightComments();
                MainFrame.this.lblMsg.setText(Message.RESET_BUTTON);
                if (((JCheckBox)MainFrame.this.fieldComp[5]).isSelected()) {
                    ((JCheckBox)MainFrame.this.fieldComp[7]).setEnabled(false);
                    ((JCheckBox)MainFrame.this.fieldComp[7]).increase();
                }
                if (((JCheckBox)MainFrame.this.fieldComp[7]).isSelected()) {
                    ((JCheckBox)MainFrame.this.fieldComp[5]).setEnabled(false);
                    ((JCheckBox)MainFrame.this.fieldComp[5]).increase();
                }
            }
        }
    }

    public class FieldListSetter
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            int check;
            if (MainFrame.this.fieldMode == -1) {
                return;
            }
            String fieldType = (String)((JComboBox)MainFrame.this.fieldComp[1]).getSelectedItem();
            fieldType = MainFrame.this.removeSpace(fieldType);
            ((JComboBox)MainFrame.this.fieldComp[1]).setSelectedItem(fieldType);
            int numberOfField = MainFrame.this.fieldListData.size();
            String newName = ((JTextField)MainFrame.this.fieldComp[2]).getText();
            newName = MainFrame.this.removeSpace(newName);
            ((JTextField)MainFrame.this.fieldComp[2]).setText(newName);
            for (int i = 0; i < numberOfField; ++i) {
                CWField cwField;
                String strName = "";
                if (MainFrame.this.fieldMode == 1) {
                    if (i == MainFrame.this.fieldIndex || !(strName = (cwField = (CWField)MainFrame.this.fieldListData.get(i)).getName()).equals(newName)) continue;
                    MainFrame.this.lblMsg.setText(newName + Message.FIELD_ERROR_1 + ((JTextField)MainFrame.this.generalComp[1]).getText());
                    ((JTextField)MainFrame.this.fieldComp[2]).setBackground(Color.YELLOW);
                    return;
                }
                cwField = (CWField)MainFrame.this.fieldListData.get(i);
                strName = cwField.getName();
                if (!strName.equals(newName)) continue;
                MainFrame.this.lblMsg.setText(newName + Message.FIELD_ERROR_1 + ((JTextField)MainFrame.this.generalComp[1]).getText());
                ((JTextField)MainFrame.this.fieldComp[2]).setBackground(Color.YELLOW);
                return;
            }
            CWField field = new CWField();
            field.setVisibility((String)((JComboBox)MainFrame.this.fieldComp[0]).getSelectedItem());
            String fieldTypeA = "";
            String fieldTypeB = "";
            int indexOfKeh = fieldType.indexOf("[]");
            if (indexOfKeh != -1) {
                fieldTypeA = fieldType.substring(0, indexOfKeh);
                fieldTypeB = fieldType.substring(indexOfKeh, fieldType.length());
                if (!ArrayChecker.isArrayValid(fieldTypeB)) {
                    MainFrame.this.lblMsg.setText(Message.FIELD_ERROR_4);
                    ((JComboBox)MainFrame.this.fieldComp[1]).setEditable(false);
                    ((JComboBox)MainFrame.this.fieldComp[1]).setBackground(Color.YELLOW);
                    return;
                }
                if (!FieldTypeChecker.isValid(fieldTypeA)) {
                    MainFrame.this.lblMsg.setText(Message.FIELD_ERROR_5);
                    ((JComboBox)MainFrame.this.fieldComp[1]).setEditable(false);
                    ((JComboBox)MainFrame.this.fieldComp[1]).setBackground(Color.YELLOW);
                    return;
                }
            } else {
                fieldTypeA = fieldType;
            }
            if ((check = WordChecker.isValid(fieldTypeA)) == 1) {
                MainFrame.this.lblMsg.setText(Message.FIELD_ERROR_4);
                ((JComboBox)MainFrame.this.fieldComp[1]).setEditable(false);
                ((JComboBox)MainFrame.this.fieldComp[1]).setBackground(Color.YELLOW);
                return;
            }
            if (!FieldTypeChecker.isValid((String)((JComboBox)MainFrame.this.fieldComp[1]).getSelectedItem())) {
                MainFrame.this.lblMsg.setText(Message.FIELD_ERROR_5);
                ((JComboBox)MainFrame.this.fieldComp[1]).setEditable(false);
                ((JComboBox)MainFrame.this.fieldComp[1]).setBackground(Color.YELLOW);
                return;
            }
            field.setType(((String)((JComboBox)MainFrame.this.fieldComp[1]).getSelectedItem()).trim());
            check = WordChecker.isValid(((JTextField)MainFrame.this.fieldComp[2]).getText());
            if (check == 1) {
                MainFrame.this.lblMsg.setText(Message.FIELD_ERROR_2);
                ((JTextField)MainFrame.this.fieldComp[2]).setBackground(Color.YELLOW);
                return;
            }
            if (check == 2) {
                MainFrame.this.lblMsg.setText(Message.FIELD_ERROR_3);
                ((JTextField)MainFrame.this.fieldComp[2]).setBackground(Color.YELLOW);
                return;
            }
            if (MainFrame.this.strType.equals("interface")) {
                JTextField initValue = (JTextField)MainFrame.this.fieldComp[3];
                String s = initValue.getText();
                if ((s = MainFrame.this.removeSpace(s)) == null || s.equals("")) {
                    MainFrame.this.lblMsg.setText(Message.FIELD_ERROR_6);
                    ((JTextField)MainFrame.this.fieldComp[3]).setBackground(Color.YELLOW);
                    return;
                }
            }
            if (((JCheckBox)MainFrame.this.fieldComp[5]).isSelected() && ((JTextField)MainFrame.this.fieldComp[3]).getText().equals("")) {
                MainFrame.this.lblMsg.setText(Message.FIELD_ERROR_6);
                ((JTextField)MainFrame.this.fieldComp[3]).setBackground(Color.YELLOW);
                return;
            }
            field.setName(((JTextField)MainFrame.this.fieldComp[2]).getText().trim());
            field.setInitialValue(((JTextField)MainFrame.this.fieldComp[3]).getText().trim());
            if (((JCheckBox)MainFrame.this.fieldComp[4]).isSelected()) {
                field.setStatic("static");
            } else {
                field.setStatic("");
            }
            if (((JCheckBox)MainFrame.this.fieldComp[5]).isSelected()) {
                field.setFinal("final");
            } else {
                field.setFinal("");
            }
            if (((JCheckBox)MainFrame.this.fieldComp[6]).isSelected()) {
                field.setTransient("transient");
            } else {
                field.setTransient("");
            }
            if (((JCheckBox)MainFrame.this.fieldComp[7]).isSelected()) {
                field.setVolatile("volatile");
            } else {
                field.setVolatile("");
            }
            if (((JRadioButton)MainFrame.this.fieldComp[8]).isSelected()) {
                field.setFrontComments(((JTextArea)MainFrame.this.fieldComp[10]).getText());
            } else {
                field.setFrontComments(MainFrame.this.frontComment);
            }
            if (((JRadioButton)MainFrame.this.fieldComp[9]).isSelected()) {
                field.setRightComments(((JTextArea)MainFrame.this.fieldComp[10]).getText());
            } else {
                field.setRightComments(MainFrame.this.rightComment);
            }
            if (MainFrame.this.fieldMode == 0) {
                MainFrame.this.fieldListData.add(field);
            } else if (MainFrame.this.fieldMode == 1) {
                int index = MainFrame.this.fieldList.getSelectedIndex();
                MainFrame.this.fieldListData.remove(index);
                MainFrame.this.fieldListData.add(index, field);
            }
            Vector<String> fieldNameList = new Vector<String>();
            Iterator i = MainFrame.this.fieldListData.iterator();
            while (i.hasNext()) {
                CWField afield = (CWField)i.next();
                String name = afield.getName();
                String visibility = afield.getVisibility();
                if (visibility.equals("private")) {
                    name = "-" + name;
                } else if (visibility.equals("protected")) {
                    name = "#" + name;
                } else if (visibility.equals("public")) {
                    name = "+" + name;
                } else if (visibility.equals("")) {
                    name = "~" + name;
                }
                name = name + " : " + afield.getType();
                if (!afield.getInitialValue().equals("")) {
                    name = name + " = " + afield.getInitialValue();
                }
                fieldNameList.add(name);
            }
            MainFrame.this.fieldList.setListData(fieldNameList);
            MainFrame.this.fieldList.setCellRenderer(new FieldCellRenderer(MainFrame.this.fieldListData));
            MainFrame.this.fieldMode = -1;
            MainFrame.this.fieldList.setSelectedIndex(-1);
            for (int cnt = 0; cnt < MainFrame.this.fieldComp.length; ++cnt) {
                MainFrame.this.fieldComp[cnt].setEnabled(false);
            }
            MainFrame.this.lblMsg.setText(Message.SET_BUTTON);
        }
    }

    public class FieldListDeler
    implements ActionListener {
        JComponent[] fieldComp;

        public FieldListDeler(JComponent[] fieldComp) {
            this.fieldComp = fieldComp;
        }

        public void actionPerformed(ActionEvent arg0) {
            ListModel model = MainFrame.this.fieldList.getModel();
            int index = MainFrame.this.fieldList.getSelectedIndex();
            if (index == -1) {
                return;
            }
            String[] input = new String[model.getSize() - 1];
            int j = 0;
            for (int i = 0; i < model.getSize(); ++i) {
                if (i == index) continue;
                input[++j - 1] = (String)model.getElementAt(i);
            }
            MainFrame.this.fieldList.setSelectedIndex(-1);
            MainFrame.this.fieldList.setListData(input);
            MainFrame.this.fieldListData.remove(index);
            ((JComboBox)this.fieldComp[0]).setSelectedItem("");
            ((JComboBox)this.fieldComp[1]).setSelectedItem("");
            ((JTextField)this.fieldComp[2]).setText("");
            ((JTextField)this.fieldComp[3]).setText("");
            ((JCheckBox)this.fieldComp[4]).setSelected(false);
            ((JCheckBox)this.fieldComp[5]).setSelected(false);
            ((JCheckBox)this.fieldComp[6]).setSelected(false);
            ((JCheckBox)this.fieldComp[7]).setSelected(false);
            ((JTextArea)this.fieldComp[10]).setText("");
            MainFrame.this.lblMsg.setText("deleting success");
        }
    }

    public class FieldListModifier
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            MainFrame.this.initFieldCheckBox();
            MainFrame.this.fieldMode = 1;
            int index = MainFrame.this.fieldList.getSelectedIndex();
            if (index == -1) {
                MainFrame.this.fieldIndex = -1;
                return;
            }
            MainFrame.this.fieldIndex = index;
            for (int cnt = 0; cnt < MainFrame.this.fieldComp.length; ++cnt) {
                MainFrame.this.fieldComp[cnt].setEnabled(true);
            }
            CWField field = (CWField)MainFrame.this.fieldListData.get(index);
            ((JComboBox)MainFrame.this.fieldComp[0]).setSelectedItem(field.getVisibility());
            ((JComboBox)MainFrame.this.fieldComp[1]).setSelectedItem(field.getType());
            ((JTextField)MainFrame.this.fieldComp[2]).setText(field.getName());
            ((JTextField)MainFrame.this.fieldComp[3]).setText(field.getInitialValue());
            if (field.getStatic().equals("")) {
                ((JCheckBox)MainFrame.this.fieldComp[4]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.fieldComp[4]).setSelected(true);
            }
            if (field.getFinal().equals("")) {
                ((JCheckBox)MainFrame.this.fieldComp[5]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.fieldComp[5]).setSelected(true);
            }
            if (field.getTransient().equals("")) {
                ((JCheckBox)MainFrame.this.fieldComp[6]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.fieldComp[6]).setSelected(true);
            }
            if (field.getVolatile().equals("")) {
                ((JCheckBox)MainFrame.this.fieldComp[7]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.fieldComp[7]).setSelected(true);
            }
            ((JRadioButton)MainFrame.this.fieldComp[8]).setSelected(true);
            ((JTextArea)MainFrame.this.fieldComp[10]).setText(field.getFrontComments());
            MainFrame.this.rightComment = field.getRightComments();
            if (MainFrame.this.strType.equals("interface")) {
                ((JCheckBox)MainFrame.this.fieldComp[6]).setEnabled(false);
                ((JCheckBox)MainFrame.this.fieldComp[7]).setEnabled(false);
            }
            if (((JCheckBox)MainFrame.this.fieldComp[5]).isSelected()) {
                ((JCheckBox)MainFrame.this.fieldComp[7]).setEnabled(false);
                ((JCheckBox)MainFrame.this.fieldComp[7]).increase();
            }
            if (((JCheckBox)MainFrame.this.fieldComp[7]).isSelected()) {
                ((JCheckBox)MainFrame.this.fieldComp[5]).setEnabled(false);
                ((JCheckBox)MainFrame.this.fieldComp[5]).increase();
            }
        }
    }

    public class FieldListAdder
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            MainFrame.this.initFieldCheckBox();
            MainFrame.this.fieldMode = 0;
            for (int cnt = 0; cnt < MainFrame.this.fieldComp.length; ++cnt) {
                MainFrame.this.fieldComp[cnt].setEnabled(true);
            }
            ((JComboBox)MainFrame.this.fieldComp[0]).setSelectedItem("");
            ((JComboBox)MainFrame.this.fieldComp[1]).setSelectedItem("");
            ((JTextField)MainFrame.this.fieldComp[2]).setText("");
            class ColorChangeListener
            implements MouseListener {
                private final /* synthetic */ FieldListAdder this$1;

                ColorChangeListener(FieldListAdder this$1) {
                    this.this$1 = this$1;
                }

                public void mousePressed(MouseEvent event) {
                    ((JTextField)MainFrame.access$300(FieldListAdder.access$900(this.this$1))[2]).setBackground(new Color(0xFFFFFF));
                }

                public void mouseReleased(MouseEvent event) {
                }

                public void mouseClicked(MouseEvent event) {
                }

                public void mouseEntered(MouseEvent event) {
                }

                public void mouseExited(MouseEvent event) {
                }
            }
            ColorChangeListener colorChange = new ColorChangeListener(this);
            ((JTextField)MainFrame.this.fieldComp[2]).addMouseListener(colorChange);
            ((JTextField)MainFrame.this.fieldComp[3]).setText("");
            ((JCheckBox)MainFrame.this.fieldComp[4]).setSelected(false);
            ((JCheckBox)MainFrame.this.fieldComp[5]).setSelected(false);
            ((JCheckBox)MainFrame.this.fieldComp[6]).setSelected(false);
            ((JCheckBox)MainFrame.this.fieldComp[7]).setSelected(false);
            if (MainFrame.this.strType.equals("interface")) {
                ((JCheckBox)MainFrame.this.fieldComp[6]).setEnabled(false);
                ((JCheckBox)MainFrame.this.fieldComp[7]).setEnabled(false);
            }
            ((JRadioButton)MainFrame.this.fieldComp[8]).setSelected(true);
            ((JTextArea)MainFrame.this.fieldComp[10]).setText("");
            MainFrame.this.frontComment = "";
            MainFrame.this.rightComment = "";
        }

        static /* synthetic */ MainFrame access$900(FieldListAdder x0) {
            return x0.MainFrame.this;
        }
    }

    public class FieldListListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent arg0) {
            MainFrame.this.fieldMode = -1;
            int index = MainFrame.this.fieldList.getSelectedIndex();
            if (index == -1) {
                return;
            }
            for (int cnt = 0; cnt < MainFrame.this.fieldComp.length; ++cnt) {
                MainFrame.this.fieldComp[cnt].setEnabled(false);
            }
            CWField field = (CWField)MainFrame.this.fieldListData.get(index);
            ((JComboBox)MainFrame.this.fieldComp[0]).setSelectedItem(field.getVisibility());
            ((JComboBox)MainFrame.this.fieldComp[1]).setSelectedItem(field.getType());
            ((JTextField)MainFrame.this.fieldComp[2]).setText(field.getName());
            ((JTextField)MainFrame.this.fieldComp[3]).setText(field.getInitialValue());
            if (field.getStatic().equals("")) {
                ((JCheckBox)MainFrame.this.fieldComp[4]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.fieldComp[4]).setSelected(true);
            }
            if (field.getFinal().equals("")) {
                ((JCheckBox)MainFrame.this.fieldComp[5]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.fieldComp[5]).setSelected(true);
            }
            if (field.getTransient().equals("")) {
                ((JCheckBox)MainFrame.this.fieldComp[6]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.fieldComp[6]).setSelected(true);
            }
            if (field.getVolatile().equals("")) {
                ((JCheckBox)MainFrame.this.fieldComp[7]).setSelected(false);
            } else {
                ((JCheckBox)MainFrame.this.fieldComp[7]).setSelected(true);
            }
            ((JRadioButton)MainFrame.this.fieldComp[8]).setSelected(true);
            ((JTextArea)MainFrame.this.fieldComp[10]).setText(field.getFrontComments());
        }
    }

    public class GeneralDeler
    implements ActionListener {
        private JList list;

        public GeneralDeler(JList l) {
            this.list = l;
        }

        public void actionPerformed(ActionEvent e) {
            ListModel model = this.list.getModel();
            int index = this.list.getSelectedIndex();
            if (index == -1) {
                return;
            }
            String[] input = new String[model.getSize() - 1];
            int j = 0;
            for (int i = 0; i < model.getSize(); ++i) {
                if (i == index) continue;
                input[++j - 1] = (String)model.getElementAt(i);
            }
            this.list.setListData(input);
            MainFrame.this.lblMsg.setText("deleting success");
        }
    }

    public class GeneralImportAdder
    implements ActionListener {
        private JList list;
        private String msg;

        public GeneralImportAdder(JList l, String s) {
            this.list = l;
            this.msg = s;
        }

        public void actionPerformed(ActionEvent e) {
            int j;
            ListModel model = this.list.getModel();
            String[] input = new String[model.getSize() + 1];
            String in = JOptionPane.showInputDialog(null, (Object)this.msg);
            if ((in = MainFrame.this.removeSpace(in)) == null) {
                return;
            }
            if (in.equals("")) {
                return;
            }
            for (int i = 0; i < model.getSize(); ++i) {
                input[i] = (String)model.getElementAt(i);
            }
            boolean overlapped = false;
            for (j = 0; j < model.getSize(); ++j) {
                if (!input[j].equals(in)) continue;
                overlapped = true;
            }
            if (!overlapped) {
                int check = ImportChecker.isValid(in);
                if (check == 1) {
                    MainFrame.this.lblMsg.setText("invalid import-sentence ");
                    return;
                }
                if (check == 2) {
                    MainFrame.this.lblMsg.setText("reserved word can't be a part of class(es)");
                    return;
                }
                if (check == 3) {
                    MainFrame.this.lblMsg.setText("'.' is expected");
                    return;
                }
                MainFrame.this.lblMsg.setText("Adding success");
                input[i] = in = in.trim();
            } else {
                input = new String[model.getSize()];
                for (j = 0; j < model.getSize(); ++j) {
                    input[j] = (String)model.getElementAt(j);
                }
                MainFrame.this.lblMsg.setText(in + " is Already defined in " + ((JTextField)MainFrame.this.generalComp[1]).getText());
            }
            this.list.setListData(input);
        }
    }

    public class GeneralInterfaceAdder
    implements ActionListener {
        private JList list;
        private String msg;

        public GeneralInterfaceAdder(JList l, String s) {
            this.list = l;
            this.msg = s;
        }

        public void actionPerformed(ActionEvent e) {
            int j;
            ListModel model = this.list.getModel();
            String[] input = new String[model.getSize() + 1];
            String in = JOptionPane.showInputDialog(null, (Object)this.msg);
            if ((in = MainFrame.this.removeSpace(in)) == null) {
                return;
            }
            if (in.equals("")) {
                return;
            }
            for (int i = 0; i < model.getSize(); ++i) {
                input[i] = (String)model.getElementAt(i);
            }
            boolean overlapped = false;
            for (j = 0; j < model.getSize(); ++j) {
                if (!input[j].equals(in)) continue;
                overlapped = true;
            }
            if (!overlapped) {
                int check = InterfaceChecker.isValid(in);
                if (check == 1) {
                    MainFrame.this.lblMsg.setText("Invalid interface name");
                    return;
                }
                if (check == 2) {
                    MainFrame.this.lblMsg.setText("reserved word can't be a interface name");
                    return;
                }
                String className = MainFrame.this.coi.getClassNameOrInterfaceName();
                if (className.equals(in)) {
                    MainFrame.this.lblMsg.setText("cyclic inheritance involving " + className);
                    return;
                }
                MainFrame.this.lblMsg.setText("Adding success");
                input[i] = in = in.trim();
            } else {
                input = new String[model.getSize()];
                for (j = 0; j < model.getSize(); ++j) {
                    input[j] = (String)model.getElementAt(j);
                }
                MainFrame.this.lblMsg.setText(in + " is Already defined in " + ((JTextField)MainFrame.this.generalComp[1]).getText());
            }
            this.list.setListData(input);
        }
    }

    class MethodColorRecoverListener
    implements MouseListener {
        MethodColorRecoverListener() {
        }

        public void mousePressed(MouseEvent event) {
            ((JTextField)MainFrame.this.methodComp[2]).setBackground(new Color(0xFFFFFF));
            ((JComboBox)MainFrame.this.methodComp[1]).setBackground(new Color(0xFFFFFF));
            ((JComboBox)MainFrame.this.methodComp[1]).setEditable(true);
            MainFrame.this.lblMsg.setText("");
        }

        public void mouseReleased(MouseEvent event) {
        }

        public void mouseClicked(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }
    }

    class FieldColorRecoverListener
    implements MouseListener {
        FieldColorRecoverListener() {
        }

        public void mousePressed(MouseEvent event) {
            ((JTextField)MainFrame.this.fieldComp[2]).setBackground(new Color(0xFFFFFF));
            ((JComboBox)MainFrame.this.fieldComp[1]).setBackground(new Color(0xFFFFFF));
            ((JComboBox)MainFrame.this.fieldComp[1]).setEditable(true);
            ((JTextField)MainFrame.this.fieldComp[3]).setBackground(new Color(0xFFFFFF));
            MainFrame.this.lblMsg.setText("");
        }

        public void mouseReleased(MouseEvent event) {
        }

        public void mouseClicked(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }
    }

    class GeneralColorRecoverListener
    implements MouseListener {
        GeneralColorRecoverListener() {
        }

        public void mousePressed(MouseEvent event) {
            if (MainFrame.this.strType.equals("class")) {
                ((JTextField)MainFrame.this.generalComp[3]).setBackground(new Color(0xFFFFFF));
            }
            ((JTextField)MainFrame.this.generalComp[5]).setBackground(Color.WHITE);
            MainFrame.this.lblMsg.setText("");
        }

        public void mouseReleased(MouseEvent event) {
        }

        public void mouseClicked(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }
    }
}

