/*
 * Decompiled with CFR 0.152.
 */
package kr.or.bluej.cw.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kr.or.bluej.cw.checker.ArrayChecker;
import kr.or.bluej.cw.checker.FieldTypeChecker;
import kr.or.bluej.cw.checker.WordChecker;
import kr.or.bluej.cw.gui.MainFrame;
import kr.or.bluej.cw.member.CWParameter;

public class ParameterFrame
extends JFrame
implements WindowListener {
    private JList parameterList;
    private Vector paramListData;
    private Vector changedParameters;
    private Vector params;
    private ParameterFrame myself;
    private MainFrame mainframe;
    private JLabel lblMsg;
    private int paramIndex = -3;
    private JComponent[] paramComp = null;
    int paramMode = -1;

    public ParameterFrame(String operatorName, Vector params, MainFrame mf) {
        super("Class Wizard : Parameter : " + operatorName + "()");
        this.params = params;
        this.setBounds(200, 150, 600, 500);
        this.setResizable(false);
        this.setVisible(true);
        this.changedParameters = this.changedParameters;
        this.myself = this;
        this.addWindowListener(this);
        this.mainframe = mf;
        this.makeMainPanel();
        this.initCode();
    }

    public void makeMainPanel() {
        Container cp = this.getContentPane();
        cp.setLayout(null);
        JPanel embTab = new JPanel();
        embTab.setLayout(null);
        embTab.setBounds(10, 10, this.getWidth() - 30, this.getHeight() - 100);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setBounds(0, 0, embTab.getWidth(), embTab.getHeight());
        tabbedPane.addTab("General", this.makeParameterPanel());
        embTab.add(tabbedPane);
        JPanel embBtn = new JPanel();
        embBtn.setLayout(null);
        embBtn.setBounds(10, 20 + this.getHeight() - 100, this.getWidth() - 30, 80);
        JButton okBtn = new JButton("ok");
        okBtn.setBounds(this.getWidth() - 30 - 100 - 110, 0, 100, 40);
        okBtn.addActionListener(new OkBtn());
        JButton cancelBtn = new JButton("cencel");
        cancelBtn.setBounds(this.getWidth() - 30 - 100, 0, 100, 40);
        cancelBtn.addActionListener(new CencelBtn());
        this.lblMsg = new JLabel();
        this.lblMsg.setBounds(this.getWidth() - 30 - 100 - 110 - 110 - 200 - 50, 20, 240, 20);
        this.lblMsg.setHorizontalAlignment(2);
        this.lblMsg.setText("");
        embBtn.add(this.lblMsg);
        embBtn.add(okBtn);
        embBtn.add(cancelBtn);
        cp.add(embTab);
        cp.add(embBtn);
    }

    public JPanel makeParameterPanel() {
        this.paramComp = new JComponent[5];
        JPanel[] panel = new JPanel[3];
        for (int i = 0; i < panel.length; ++i) {
            panel[i] = new JPanel();
            panel[i].setLayout(null);
        }
        panel[0].add(panel[1]);
        panel[0].add(panel[2]);
        panel[0].setBounds(0, 0, 560, 380);
        panel[1].setBounds(10, 10, panel[0].getWidth() / 2 - 20, panel[0].getHeight() - 30);
        panel[2].setBounds(panel[0].getWidth() / 2 + 20, 10, panel[0].getWidth() / 2 - 20, panel[0].getHeight() - 30);
        panel[1].setBorder(new EtchedBorder());
        panel[2].setBorder(new EtchedBorder());
        JLabel[] label = new JLabel[3];
        for (int i = 0; i < label.length; ++i) {
            label[i] = new JLabel();
        }
        label[0].setText("Type");
        label[1].setText("Name");
        ParamColorRecoverListener paramColorRecover = new ParamColorRecoverListener();
        JTextField[] textfield = new JTextField[1];
        for (int i = 0; i < textfield.length; ++i) {
            textfield[i] = new JTextField();
            textfield[i].addMouseListener(paramColorRecover);
        }
        JComboBox[] combobox = new JComboBox[1];
        for (int i = 0; i < combobox.length; ++i) {
            combobox[i] = new JComboBox();
        }
        this.parameterList = new JList();
        this.parameterList.addListSelectionListener(new ParameterListListener());
        this.parameterList.addMouseListener(paramColorRecover);
        JButton[] button = new JButton[5];
        for (int i = 0; i < button.length; ++i) {
            button[i] = new JButton();
            button[i].addMouseListener(paramColorRecover);
        }
        button[0].setText("add");
        button[1].setText("modify");
        button[2].setText("del");
        button[3].setText("set");
        button[4].setText("reset");
        JScrollPane[] scrollpane = new JScrollPane[]{new JScrollPane(this.parameterList)};
        JCheckBox[] check = new JCheckBox[1];
        for (int i = 0; i < check.length; ++i) {
            check[i] = new JCheckBox();
            check[i].addMouseListener(paramColorRecover);
        }
        check[0].setText("Final");
        panel[1].add(scrollpane[0]);
        scrollpane[0].setBounds(10, 10, 240, 280);
        panel[1].add(button[0]);
        button[0].setBounds(10, 300, 60, 40);
        button[0].addActionListener(new ParameterListAdder());
        panel[1].add(button[1]);
        button[1].setBounds(90, 300, 80, 40);
        button[1].addActionListener(new ParameterListModifier());
        panel[1].add(button[2]);
        button[2].setBounds(190, 300, 60, 40);
        button[2].addActionListener(new ParameterListDeler());
        panel[2].add(label[0]);
        label[0].setBounds(10, 10, 80, 20);
        panel[2].add(label[1]);
        label[1].setBounds(10, 40, 80, 20);
        panel[2].add(combobox[0]);
        combobox[0].setEditable(true);
        combobox[0].setBounds(120, 10, 130, 20);
        combobox[0].addItem("byte");
        combobox[0].addItem("char");
        combobox[0].addItem("short");
        combobox[0].addItem("int");
        combobox[0].addItem("long");
        combobox[0].addItem("float");
        combobox[0].addItem("double");
        combobox[0].addItem("boolean");
        combobox[0].addMouseListener(paramColorRecover);
        panel[2].add(textfield[0]);
        textfield[0].setBounds(120, 40, 130, 20);
        panel[2].add(check[0]);
        check[0].setBounds(10, 70, 130, 20);
        panel[2].add(button[3]);
        button[3].setBounds(10, 300, 80, 40);
        button[3].addActionListener(new ParameterListSetter());
        panel[2].add(button[4]);
        button[4].setBounds(170, 300, 80, 40);
        button[4].addActionListener(new ParameterListResetter());
        this.paramComp[0] = combobox[0];
        this.paramComp[1] = textfield[0];
        this.paramComp[2] = check[0];
        this.paramComp[3] = button[3];
        this.paramComp[4] = button[4];
        for (int cnt = 0; cnt < this.paramComp.length; ++cnt) {
            this.paramComp[cnt].setEnabled(true);
        }
        return panel[0];
    }

    public void initCode() {
        if (this.params == null) {
            return;
        }
        this.paramListData = (Vector)this.params.clone();
        Vector<String> paramNameList = new Vector<String>();
        Iterator i = this.paramListData.iterator();
        while (i.hasNext()) {
            CWParameter param = (CWParameter)i.next();
            String name = param.getParameterName();
            name = name + " : " + param.getType();
            paramNameList.add(name);
        }
        this.parameterList.setListData(paramNameList);
        for (int cnt = 0; cnt < this.paramComp.length; ++cnt) {
            this.paramComp[cnt].setEnabled(false);
        }
    }

    public void windowOpened(WindowEvent arg0) {
    }

    public void windowClosing(WindowEvent arg0) {
        this.mainframe.parameterFrame = null;
        this.myself.setVisible(false);
        this.myself = null;
    }

    public void windowClosed(WindowEvent arg0) {
    }

    public void windowIconified(WindowEvent arg0) {
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowDeactivated(WindowEvent arg0) {
    }

    public class CencelBtn
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            ((ParameterFrame)ParameterFrame.this).mainframe.parameterFrame = null;
            ParameterFrame.this.myself.setVisible(false);
            ParameterFrame.this.myself = null;
        }
    }

    public class OkBtn
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            ParameterFrame.this.params.removeAllElements();
            ParameterFrame.this.params.addAll(ParameterFrame.this.paramListData);
            ((ParameterFrame)ParameterFrame.this).mainframe.parameterFrame = null;
            ParameterFrame.this.myself.setVisible(false);
            ParameterFrame.this.myself = null;
        }
    }

    public class ParameterListResetter
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            if (ParameterFrame.this.paramMode == -1) {
                return;
            }
            if (ParameterFrame.this.paramMode == 0) {
                ((JComboBox)ParameterFrame.this.paramComp[0]).setSelectedItem("");
                ((JTextField)ParameterFrame.this.paramComp[1]).setText("");
                ((JCheckBox)ParameterFrame.this.paramComp[2]).setSelected(false);
            } else if (ParameterFrame.this.paramMode == 1) {
                int index = ParameterFrame.this.parameterList.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                for (int cnt = 0; cnt < ParameterFrame.this.paramComp.length; ++cnt) {
                    ParameterFrame.this.paramComp[cnt].setEnabled(true);
                }
                CWParameter param = (CWParameter)ParameterFrame.this.paramListData.get(index);
                ((JComboBox)ParameterFrame.this.paramComp[0]).setSelectedItem(param.getType());
                ((JTextField)ParameterFrame.this.paramComp[1]).setText(param.getParameterName());
                if (param.getFinal().equals("final")) {
                    ((JCheckBox)ParameterFrame.this.paramComp[2]).setSelected(true);
                } else {
                    ((JCheckBox)ParameterFrame.this.paramComp[2]).setSelected(false);
                }
            }
        }
    }

    public class ParameterListSetter
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            int check;
            if (ParameterFrame.this.paramMode == -1) {
                return;
            }
            int numberOfParam = ParameterFrame.this.paramListData.size();
            ((JTextField)ParameterFrame.this.paramComp[1]).setText(ParameterFrame.this.mainframe.removeSpace(((JTextField)ParameterFrame.this.paramComp[1]).getText()));
            for (int i = 0; i < numberOfParam; ++i) {
                String newName;
                CWParameter cwParameter;
                String strName;
                if (i == ParameterFrame.this.paramIndex || !(strName = (cwParameter = (CWParameter)ParameterFrame.this.paramListData.get(i)).getParameterName()).equals(newName = ((JTextField)ParameterFrame.this.paramComp[1]).getText())) continue;
                ParameterFrame.this.lblMsg.setText(newName + " is already defined in " + ((JTextField)ParameterFrame.this.paramComp[1]).getText());
                ((JTextField)ParameterFrame.this.paramComp[1]).setBackground(Color.YELLOW);
                return;
            }
            CWParameter parameter = new CWParameter();
            String paramType = ParameterFrame.this.mainframe.removeSpace((String)((JComboBox)ParameterFrame.this.paramComp[0]).getSelectedItem());
            ((JComboBox)ParameterFrame.this.paramComp[0]).setSelectedItem(paramType);
            String paramTypeA = "";
            String paramTypeB = "";
            int indexOfKeh = paramType.indexOf("[]");
            if (indexOfKeh != -1) {
                paramTypeA = paramType.substring(0, indexOfKeh);
                paramTypeB = paramType.substring(indexOfKeh, paramType.length());
                if (!ArrayChecker.isArrayValid(paramTypeB)) {
                    ParameterFrame.this.lblMsg.setText("Invalid param type");
                    ((JComboBox)ParameterFrame.this.paramComp[0]).setEditable(false);
                    ((JComboBox)ParameterFrame.this.paramComp[0]).setBackground(Color.YELLOW);
                    return;
                }
                if (!FieldTypeChecker.isValid(paramTypeA)) {
                    ParameterFrame.this.lblMsg.setText("Keyword can't be a param type");
                    ((JComboBox)ParameterFrame.this.paramComp[0]).setEditable(false);
                    ((JComboBox)ParameterFrame.this.paramComp[0]).setBackground(Color.YELLOW);
                    return;
                }
            } else {
                paramTypeA = paramType;
            }
            if ((check = WordChecker.isValid(paramTypeA)) == 1) {
                ParameterFrame.this.lblMsg.setText("Invalid parameter type");
                ((JComboBox)ParameterFrame.this.paramComp[0]).setEditable(false);
                ((JComboBox)ParameterFrame.this.paramComp[0]).setBackground(Color.YELLOW);
                return;
            }
            if (!FieldTypeChecker.isValid((String)((JComboBox)ParameterFrame.this.paramComp[0]).getSelectedItem())) {
                ParameterFrame.this.lblMsg.setText("Keyword can't be a parameter type");
                ((JComboBox)ParameterFrame.this.paramComp[0]).setEditable(false);
                ((JComboBox)ParameterFrame.this.paramComp[0]).setBackground(Color.YELLOW);
                return;
            }
            parameter.setType((String)((JComboBox)ParameterFrame.this.paramComp[0]).getSelectedItem());
            check = WordChecker.isValid(((JTextField)ParameterFrame.this.paramComp[1]).getText());
            String GRAMMA_ERROR = "Invalid parameter name";
            String KEYWORD_ERROR = "Keyword can't be a parameter name";
            if (check == 1) {
                ParameterFrame.this.lblMsg.setText(GRAMMA_ERROR);
                ((JTextField)ParameterFrame.this.paramComp[1]).setBackground(Color.YELLOW);
                return;
            }
            if (check == 2) {
                ParameterFrame.this.lblMsg.setText(KEYWORD_ERROR);
                ((JTextField)ParameterFrame.this.paramComp[1]).setBackground(new Color(0xFFFFD9));
                return;
            }
            ParameterFrame.this.lblMsg.setText("Setting success");
            parameter.setParameterName(((JTextField)ParameterFrame.this.paramComp[1]).getText().trim());
            if (((JCheckBox)ParameterFrame.this.paramComp[2]).isSelected()) {
                parameter.setFinal("final");
            } else {
                parameter.setFinal("");
            }
            if (ParameterFrame.this.paramMode == 0) {
                ParameterFrame.this.paramListData.add(parameter);
            } else if (ParameterFrame.this.paramMode == 1) {
                int index = ParameterFrame.this.parameterList.getSelectedIndex();
                ParameterFrame.this.paramListData.remove(index);
                ParameterFrame.this.paramListData.add(index, parameter);
            }
            Vector<String> paramNameList = new Vector<String>();
            Iterator i = ParameterFrame.this.paramListData.iterator();
            while (i.hasNext()) {
                CWParameter param = (CWParameter)i.next();
                String name = param.getParameterName();
                name = name + " : " + param.getType();
                paramNameList.add(name);
            }
            ParameterFrame.this.parameterList.setListData(paramNameList);
            ParameterFrame.this.paramMode = -1;
            ParameterFrame.this.parameterList.setSelectedIndex(-1);
            for (int cnt = 0; cnt < ParameterFrame.this.paramComp.length; ++cnt) {
                ParameterFrame.this.paramComp[cnt].setEnabled(false);
            }
        }
    }

    public class ParameterListDeler
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            ListModel model = ParameterFrame.this.parameterList.getModel();
            int index = ParameterFrame.this.parameterList.getSelectedIndex();
            if (index == -1) {
                return;
            }
            String[] input = new String[model.getSize() - 1];
            int j = 0;
            for (int i = 0; i < model.getSize(); ++i) {
                if (i == index) continue;
                input[++j - 1] = (String)model.getElementAt(i);
            }
            ParameterFrame.this.parameterList.setSelectedIndex(-1);
            ParameterFrame.this.parameterList.setListData(input);
            ParameterFrame.this.paramListData.remove(index);
            ParameterFrame.this.lblMsg.setText("Deleting success");
        }
    }

    public class ParameterListModifier
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            ParameterFrame.this.paramMode = 1;
            int index = ParameterFrame.this.parameterList.getSelectedIndex();
            if (index == -1) {
                return;
            }
            ParameterFrame.this.paramIndex = index;
            for (int cnt = 0; cnt < ParameterFrame.this.paramComp.length; ++cnt) {
                ParameterFrame.this.paramComp[cnt].setEnabled(true);
            }
            CWParameter param = (CWParameter)ParameterFrame.this.paramListData.get(index);
            ((JComboBox)ParameterFrame.this.paramComp[0]).setSelectedItem(param.getType());
            ((JTextField)ParameterFrame.this.paramComp[1]).setText(param.getParameterName());
            if (param.getFinal().equals("final")) {
                ((JCheckBox)ParameterFrame.this.paramComp[2]).setSelected(true);
            } else {
                ((JCheckBox)ParameterFrame.this.paramComp[2]).setSelected(false);
            }
        }
    }

    public class ParameterListAdder
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            ParameterFrame.this.paramMode = 0;
            for (int cnt = 0; cnt < ParameterFrame.this.paramComp.length; ++cnt) {
                ParameterFrame.this.paramComp[cnt].setEnabled(true);
            }
            ((JComboBox)ParameterFrame.this.paramComp[0]).setSelectedItem("");
            ((JTextField)ParameterFrame.this.paramComp[1]).setText("");
            ((JCheckBox)ParameterFrame.this.paramComp[2]).setSelected(false);
        }
    }

    public class ParameterListListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent arg0) {
            ParameterFrame.this.paramMode = -1;
            int index = ParameterFrame.this.parameterList.getSelectedIndex();
            if (index == -1) {
                return;
            }
            for (int cnt = 0; cnt < ParameterFrame.this.paramComp.length; ++cnt) {
                ParameterFrame.this.paramComp[cnt].setEnabled(false);
            }
            CWParameter param = (CWParameter)ParameterFrame.this.paramListData.get(index);
            ((JComboBox)ParameterFrame.this.paramComp[0]).setSelectedItem(param.getType());
            ((JTextField)ParameterFrame.this.paramComp[1]).setText(param.getParameterName());
            if (param.getFinal().equals("")) {
                ((JCheckBox)ParameterFrame.this.paramComp[2]).setSelected(false);
            } else {
                ((JCheckBox)ParameterFrame.this.paramComp[2]).setSelected(true);
            }
        }
    }

    class ParamColorRecoverListener
    implements MouseListener {
        ParamColorRecoverListener() {
        }

        public void mousePressed(MouseEvent event) {
            ((JTextField)ParameterFrame.this.paramComp[1]).setBackground(new Color(0xFFFFFF));
            ((JComboBox)ParameterFrame.this.paramComp[0]).setBackground(new Color(0xFFFFFF));
            ((JComboBox)ParameterFrame.this.paramComp[0]).setEditable(true);
            ParameterFrame.this.lblMsg.setText("");
        }

        public void mouseReleased(MouseEvent event) {
        }

        public void mouseClicked(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }
    }
}

