/*
 * Decompiled with CFR 0.152.
 */
package kr.or.bluej.cw.gui;

import bluej.extensions.editor.Editor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.border.TitledBorder;
import kr.or.bluej.cw.extension.ClassWizard;
import kr.or.bluej.cw.gui.MainFrame;
import kr.or.bluej.cw.member.CWClassOrInterface;

public class SplashFrame
extends JFrame
implements Runnable {
    private JRootPane rootPane;
    private Container container;
    private JProgressBar progressBar = new JProgressBar(0, 1, 100);
    private Thread thread;
    private CWClassOrInterface coi;
    private File file;
    private ClassWizard cw;
    private Editor editor;

    public SplashFrame() {
        super("");
        this.init();
        this.setUndecorated(true);
        this.setSize(200, 100);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenDim.width - 200) / 2, (screenDim.height - 200) / 2);
        this.setVisible(true);
    }

    public void init() {
        this.coi = null;
        this.file = null;
        this.cw = null;
        this.editor = null;
        this.rootPane = this.getRootPane();
        this.container = this.rootPane.getContentPane();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.white);
        panel.setBorder(new TitledBorder(""));
        this.progressBar.setStringPainted(true);
        JLabel lblName = new JLabel("Class Wizard Running", 0);
        lblName.setBackground(Color.CYAN);
        panel.add("Center", lblName);
        ImageIcon image = new ImageIcon(this.getClass().getResource("wizard_icon_splash.jpg"));
        JLabel imageLabel = new JLabel();
        imageLabel.setIcon(image);
        panel.add("East", imageLabel);
        panel.add("South", this.progressBar);
        this.container.add(panel);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void run() {
        try {
            int percent;
            for (percent = 0; percent <= 20; ++percent) {
                this.progressBar.setString(String.valueOf(percent) + "%");
                this.progressBar.setValue(percent);
                Thread.sleep(20L);
            }
            int temp = percent;
            while (this.coi == null) {
                if (temp == 60) {
                    Thread.sleep(1000L);
                    continue;
                }
                this.progressBar.setString(String.valueOf(temp) + "%");
                this.progressBar.setValue(temp);
                Thread.sleep(50L);
                ++temp;
            }
            for (percent = temp; percent < 101; ++percent) {
                this.progressBar.setString(String.valueOf(percent) + "%");
                this.progressBar.setValue(percent);
                Thread.sleep(2L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
        MainFrame.showClassWizard(this.coi, this.file, this.cw, this.editor);
    }

    public void setMainFrameMember(CWClassOrInterface coi, File file, ClassWizard cw, Editor editor) {
        this.coi = coi;
        this.file = file;
        this.cw = cw;
        this.editor = editor;
    }
}

