/*
 * Decompiled with CFR 0.152.
 */
package kr.or.bluej.cw.io;

import bluej.extensions.BClass;
import bluej.extensions.editor.Editor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import kr.or.bluej.cw.member.CWClassOrInterface;
import kr.or.bluej.cw.member.CWConstructor;
import kr.or.bluej.cw.member.CWField;
import kr.or.bluej.cw.member.CWMethod;
import kr.or.bluej.cw.member.CWParameter;
import kr.or.bluej.cw.styler.CodeFormatter;

public class Writer {
    String source = "";
    CWClassOrInterface cwClassOrInterface;
    Editor editor;
    BClass bClass;
    File file;

    public Writer(CWClassOrInterface cwClassOrInterface, BClass bClass, Editor editor, File file) {
        this.cwClassOrInterface = cwClassOrInterface;
        this.bClass = bClass;
        this.file = file;
        this.editor = editor;
    }

    public void printSource() {
        this.source = this.getFullSource();
        try {
            FileWriter fileWriter = new FileWriter(this.file);
            try {
                fileWriter.write(this.source);
                fileWriter.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getFullSource() {
        String strFullSource = "";
        strFullSource = strFullSource + this.getGeneralComments();
        strFullSource = strFullSource + this.getPackage();
        strFullSource = strFullSource + this.getImport();
        strFullSource = strFullSource + this.getGeneralSource();
        strFullSource = strFullSource + this.getFieldSource();
        strFullSource = strFullSource + this.getConstructorSource();
        strFullSource = strFullSource + this.getMethodSource();
        strFullSource = strFullSource + this.getNestedClass();
        strFullSource = strFullSource + this.getNestedInterface();
        strFullSource = strFullSource + "}";
        strFullSource = CodeFormatter.format(strFullSource);
        return strFullSource;
    }

    public String getGeneralComments() {
        return this.cwClassOrInterface.getComments();
    }

    public String getPackage() {
        String strPackageSource = "";
        String strPackage = "";
        strPackage = this.cwClassOrInterface.getPackage();
        if (!strPackage.equals("")) {
            strPackageSource = strPackageSource + "package ";
            strPackageSource = strPackageSource + strPackage;
            strPackageSource = strPackageSource + ";";
            strPackageSource = strPackageSource + "\n\n";
        }
        return strPackageSource;
    }

    public String getImport() {
        String strImportSource = "";
        String strImport = "";
        Vector vecImports = this.cwClassOrInterface.getImports();
        int numberOfImport = vecImports.size();
        for (int i = 0; i < numberOfImport; ++i) {
            strImportSource = strImportSource + "import ";
            strImportSource = strImportSource + (String)vecImports.get(i);
            strImportSource = strImportSource + ";";
            strImportSource = strImportSource + "\n";
        }
        if (!strImportSource.equals("")) {
            strImportSource = strImportSource + "\n";
        }
        return strImportSource;
    }

    public String getGeneralSource() {
        int i;
        String generalSource = "";
        String strVisibility = this.cwClassOrInterface.getVisibility();
        generalSource = generalSource + strVisibility;
        generalSource = generalSource + " ";
        String strFinal = this.cwClassOrInterface.getFinal();
        generalSource = generalSource + strFinal;
        generalSource = generalSource + " ";
        String strAbstract = this.cwClassOrInterface.getAbstract();
        generalSource = generalSource + strAbstract;
        generalSource = generalSource + " ";
        String strStrictfp = this.cwClassOrInterface.getStrictfp();
        generalSource = generalSource + strStrictfp;
        generalSource = generalSource + " ";
        String strType = this.cwClassOrInterface.getType();
        generalSource = generalSource + strType;
        generalSource = generalSource + " ";
        String strClassOrInterfaceName = this.cwClassOrInterface.getClassNameOrInterfaceName();
        generalSource = generalSource + strClassOrInterfaceName;
        generalSource = generalSource + " ";
        if (strType.equals("class")) {
            String strSuperClass = "";
            if (!(strSuperClass = strSuperClass + this.cwClassOrInterface.getSuperClassName()).equals("")) {
                generalSource = generalSource + "extends";
                generalSource = generalSource + " ";
            }
            generalSource = generalSource + strSuperClass;
            generalSource = generalSource + " ";
        } else {
            String strSuperInterfaceNames = "";
            Vector vecSuperInterface = this.cwClassOrInterface.getSuperInterfaceNames();
            int numberOfSuperInterface = vecSuperInterface.size();
            for (i = 0; i < numberOfSuperInterface; ++i) {
                if (i == numberOfSuperInterface - 1) {
                    strSuperInterfaceNames = strSuperInterfaceNames + (String)vecSuperInterface.get(i);
                    continue;
                }
                strSuperInterfaceNames = strSuperInterfaceNames + (String)vecSuperInterface.get(i);
                strSuperInterfaceNames = strSuperInterfaceNames + ",";
            }
            if (!strSuperInterfaceNames.equals("")) {
                generalSource = generalSource + "extends";
                generalSource = generalSource + " ";
                generalSource = generalSource + strSuperInterfaceNames;
                generalSource = generalSource + " ";
            }
        }
        if (strType.equals("class")) {
            String strImplementedInterfaceNames = "";
            Vector vecImplementedInterfaceNames = this.cwClassOrInterface.getImplementedInterfaceNames();
            int numberOfImplementedInterface = vecImplementedInterfaceNames.size();
            for (i = 0; i < numberOfImplementedInterface; ++i) {
                if (i == numberOfImplementedInterface - 1) {
                    strImplementedInterfaceNames = strImplementedInterfaceNames + (String)vecImplementedInterfaceNames.get(i);
                    continue;
                }
                strImplementedInterfaceNames = strImplementedInterfaceNames + (String)vecImplementedInterfaceNames.get(i);
                strImplementedInterfaceNames = strImplementedInterfaceNames + ",";
            }
            if (!strImplementedInterfaceNames.equals("")) {
                generalSource = generalSource + "implements";
                generalSource = generalSource + " ";
                generalSource = generalSource + strImplementedInterfaceNames;
                generalSource = generalSource + " ";
            }
        }
        generalSource = generalSource + "{\n";
        return generalSource;
    }

    public String getNestedClass() {
        String strNestedClasses = this.cwClassOrInterface.getNestedClass();
        if (strNestedClasses.equals("")) {
            return "";
        }
        return strNestedClasses;
    }

    public String getNestedInterface() {
        String strNestedInterface = this.cwClassOrInterface.getNestedInterface();
        if (strNestedInterface.equals("")) {
            return "";
        }
        return strNestedInterface;
    }

    public String getConstructorSource() {
        String strConstructorSource = "";
        Vector vecConstructors = this.cwClassOrInterface.getConstructors();
        int numberOfConstructor = vecConstructors.size();
        for (int i = 0; i < numberOfConstructor; ++i) {
            CWConstructor cwConstructor = (CWConstructor)vecConstructors.get(i);
            strConstructorSource = strConstructorSource + cwConstructor.getComments();
            String strVisibility = "";
            strVisibility = strVisibility + cwConstructor.getVisibility();
            strConstructorSource = strConstructorSource + strVisibility;
            strConstructorSource = strConstructorSource + " ";
            String strName = "";
            strName = strName + cwConstructor.getOperatorName();
            strConstructorSource = strConstructorSource + strName;
            strConstructorSource = strConstructorSource + "(";
            Vector vecParameters = cwConstructor.getParameters();
            int numberOfParameter = vecParameters.size();
            for (int j = 0; j < numberOfParameter; ++j) {
                CWParameter cwParameter = (CWParameter)vecParameters.get(j);
                String param = "";
                String strFinal = cwParameter.getFinal();
                param = param + strFinal;
                param = param + " ";
                String strType = cwParameter.getType();
                param = param + strType;
                param = param + " ";
                String strParamName = cwParameter.getParameterName();
                param = param + strParamName;
                if (j != numberOfParameter - 1) {
                    param = param + ",";
                }
                strConstructorSource = strConstructorSource + param;
            }
            strConstructorSource = strConstructorSource + ") ";
            Vector vecExceptions = cwConstructor.getExceptions();
            int numberOfException = vecExceptions.size();
            if (numberOfException != 0) {
                strConstructorSource = strConstructorSource + "throws ";
            }
            for (int j = 0; j < numberOfException; ++j) {
                strConstructorSource = strConstructorSource + (String)vecExceptions.get(j);
                if (j == numberOfException - 1) continue;
                strConstructorSource = strConstructorSource + ",";
            }
            strConstructorSource = strConstructorSource + cwConstructor.getBody();
            if (i >= numberOfConstructor - 1) continue;
            strConstructorSource = strConstructorSource + "\n";
        }
        strConstructorSource = strConstructorSource + "\n";
        return strConstructorSource;
    }

    public String getFieldSource() {
        CWField cwField = new CWField();
        Vector vecField = new Vector();
        String fieldSource = "";
        vecField = this.cwClassOrInterface.getFields();
        for (int index = 0; vecField.size() - 1 >= index; ++index) {
            cwField = (CWField)vecField.get(index);
            fieldSource = fieldSource + cwField.getFrontComments() + "";
            fieldSource = fieldSource + cwField.getVisibility() + " ";
            fieldSource = fieldSource + cwField.getStatic() + " ";
            fieldSource = fieldSource + cwField.getFinal() + " ";
            fieldSource = fieldSource + cwField.getTransient() + " ";
            fieldSource = fieldSource + cwField.getVolatile() + " ";
            fieldSource = fieldSource + cwField.getType() + " ";
            fieldSource = fieldSource + cwField.getName() + " ";
            fieldSource = !cwField.getInitialValue().toString().equals("") ? fieldSource + "=" + cwField.getInitialValue() + ";" : fieldSource + ";";
            fieldSource = !cwField.getRightComments().toString().equals("") ? fieldSource + cwField.getRightComments() : fieldSource + "\n";
        }
        fieldSource = fieldSource + "\n";
        return fieldSource;
    }

    public String getMethodSource() {
        String strMethodSource = "";
        Vector vecMethods = this.cwClassOrInterface.getMethods();
        int numberOfMethod = vecMethods.size();
        for (int i = 0; i < numberOfMethod; ++i) {
            CWMethod cwMethod = (CWMethod)vecMethods.get(i);
            strMethodSource = strMethodSource + cwMethod.getComments();
            String strVisibility = "";
            strVisibility = strVisibility + cwMethod.getVisibility();
            strMethodSource = strMethodSource + strVisibility;
            strMethodSource = strMethodSource + " ";
            String strStatic = "";
            strStatic = strStatic + cwMethod.getStatic();
            strMethodSource = strMethodSource + strStatic;
            strMethodSource = strMethodSource + " ";
            String strAbstract = "";
            strAbstract = strAbstract + cwMethod.getAbstract();
            strMethodSource = strMethodSource + strAbstract;
            strMethodSource = strMethodSource + " ";
            String strFinal = "";
            strFinal = strFinal + cwMethod.getFinal();
            strMethodSource = strMethodSource + strFinal;
            strMethodSource = strMethodSource + " ";
            String strSynchronized = "";
            strSynchronized = strSynchronized + cwMethod.getSynchronized();
            strMethodSource = strMethodSource + strSynchronized;
            strMethodSource = strMethodSource + " ";
            String strStrictfp = "";
            strStrictfp = strStrictfp + cwMethod.getStrictfp();
            strMethodSource = strMethodSource + strStrictfp;
            strMethodSource = strMethodSource + " ";
            String strNative = "";
            strNative = strNative + cwMethod.getNative();
            strMethodSource = strMethodSource + strNative;
            strMethodSource = strMethodSource + " ";
            String strReturnType = "";
            strReturnType = cwMethod.getReturnType();
            strMethodSource = strMethodSource + cwMethod.getReturnType();
            strMethodSource = strMethodSource + " ";
            String strName = "";
            strName = strName + cwMethod.getOperatorName();
            strMethodSource = strMethodSource + strName;
            strMethodSource = strMethodSource + "(";
            Vector vecParameters = cwMethod.getParameters();
            int numberOfParameter = vecParameters.size();
            for (int j = 0; j < numberOfParameter; ++j) {
                CWParameter cwParameter = (CWParameter)vecParameters.get(j);
                String param = "";
                String strPFinal = cwParameter.getFinal();
                param = param + strPFinal;
                param = param + " ";
                String strType = cwParameter.getType();
                param = param + strType;
                param = param + " ";
                String strParamName = cwParameter.getParameterName();
                param = param + strParamName;
                if (j != numberOfParameter - 1) {
                    param = param + ",";
                }
                strMethodSource = strMethodSource + param;
            }
            strMethodSource = strMethodSource + ") ";
            Vector vecExceptions = cwMethod.getExceptions();
            int numberOfException = vecExceptions.size();
            if (numberOfException != 0) {
                strMethodSource = strMethodSource + "throws ";
            }
            for (int j = 0; j < numberOfException; ++j) {
                strMethodSource = strMethodSource + (String)vecExceptions.get(j);
                if (j == numberOfException - 1) continue;
                strMethodSource = strMethodSource + ",";
            }
            if (this.cwClassOrInterface.getType().equals("interface") || cwMethod.getAbstract().equals("abstract") || cwMethod.getNative().equals("native")) {
                System.out.println(cwMethod.getNative());
                strMethodSource = strMethodSource + ";";
            } else {
                strMethodSource = strMethodSource + cwMethod.getBody();
            }
            if (i == numberOfMethod - 1) continue;
            strMethodSource = strMethodSource + "\n";
        }
        return strMethodSource;
    }
}

