/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.util.ArrayList;
import java.util.List;

class PackageObjectFactory
implements ModuleFactory {
    private final List mPackages = new ArrayList();

    PackageObjectFactory() {
    }

    String[] getPackages() {
        return this.mPackages.toArray(new String[this.mPackages.size()]);
    }

    void addPackage(String aPackageName) {
        this.mPackages.add(aPackageName);
    }

    private Object doMakeObject(String aName) throws CheckstyleException {
        try {
            return this.createObject(aName);
        }
        catch (CheckstyleException ex) {
            for (int i = 0; i < this.mPackages.size(); ++i) {
                String packageName = (String)this.mPackages.get(i);
                String className = packageName + aName;
                try {
                    return this.createObject(className);
                }
                catch (CheckstyleException ex2) {
                    continue;
                }
            }
            throw new CheckstyleException("Unable to instantiate " + aName);
        }
    }

    private Object createObject(String aClassName) throws CheckstyleException {
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            Class<?> clazz = Class.forName(aClassName, true, loader);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new CheckstyleException("Unable to find class for " + aClassName, e);
        }
        catch (InstantiationException e) {
            throw new CheckstyleException("Unable to instantiate " + aClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new CheckstyleException("Unable to instantiate " + aClassName, e);
        }
    }

    public Object createModule(String aName) throws CheckstyleException {
        try {
            return this.doMakeObject(aName);
        }
        catch (CheckstyleException ex) {
            try {
                return this.doMakeObject(aName + "Check");
            }
            catch (CheckstyleException ex2) {
                throw new CheckstyleException("Unable to instantiate " + aName, ex2);
            }
        }
    }
}

