/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.j2ee;

import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class Utils {
    public static boolean hasPublicMethod(DetailAST aAST, String aName) {
        DetailAST objBlock = aAST.findFirstToken(6);
        if (objBlock != null) {
            for (DetailAST child = (DetailAST)objBlock.getFirstChild(); child != null; child = (DetailAST)child.getNextSibling()) {
                if (child.getType() != 9 || !Utils.isPublicMethod(child, aName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPublicMethod(DetailAST aAST, String aName, boolean aIsVoid) {
        DetailAST objBlock = aAST.findFirstToken(6);
        if (objBlock != null) {
            for (DetailAST child = (DetailAST)objBlock.getFirstChild(); child != null; child = (DetailAST)child.getNextSibling()) {
                if (child.getType() != 9 || !Utils.isPublicMethod(child, aName, aIsVoid)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPublicMethod(DetailAST aAST, String aName, boolean aIsVoid, int aParameterCount) {
        DetailAST objBlock = aAST.findFirstToken(6);
        if (objBlock != null) {
            for (DetailAST child = (DetailAST)objBlock.getFirstChild(); child != null; child = (DetailAST)child.getNextSibling()) {
                if (child.getType() != 9 || !Utils.isPublicMethod(child, aName, aIsVoid, aParameterCount)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPublicConstructor(DetailAST aAST, int aParameterCount) {
        DetailAST objBlock = aAST.findFirstToken(6);
        if (objBlock == null) {
            return false;
        }
        int constructorCount = 0;
        for (DetailAST child = (DetailAST)objBlock.getFirstChild(); child != null; child = (DetailAST)child.getNextSibling()) {
            if (child.getType() != 8) continue;
            ++constructorCount;
            DetailAST parameters = child.findFirstToken(20);
            if (!Utils.isPublic(child) || parameters.getChildCount() != aParameterCount) continue;
            return true;
        }
        return constructorCount == 0 && aParameterCount == 0;
    }

    public static boolean implementsEntityBean(DetailAST aAST) {
        DetailAST definer = Utils.getDefiner(aAST);
        return definer != null && Utils.hasImplements(definer, "javax.ejb.EntityBean");
    }

    public static boolean implementsSessionBean(DetailAST aAST) {
        DetailAST definer = Utils.getDefiner(aAST);
        return definer != null && Utils.hasImplements(definer, "javax.ejb.SessionBean");
    }

    public static boolean isInEJB(DetailAST aAST) {
        DetailAST definer = Utils.getDefiner(aAST);
        return definer != null && (Utils.hasImplements(definer, "javax.ejb.SessionBean") || Utils.hasImplements(definer, "javax.ejb.EntityBean") || Utils.hasImplements(definer, "javax.ejb.MessageDrivenBean") && Utils.hasImplements(definer, "javax.jms.MessageListener"));
    }

    private static DetailAST getDefiner(DetailAST aAST) {
        DetailAST definer;
        for (definer = aAST.getParent(); definer != null && definer.getType() != 14; definer = definer.getParent()) {
        }
        return definer;
    }

    public static boolean isAbstract(DetailAST aAST) {
        DetailAST mods = aAST.findFirstToken(5);
        return mods != null && mods.branchContains(40);
    }

    public static boolean isFinal(DetailAST aAST) {
        DetailAST mods = aAST.findFirstToken(5);
        return mods != null && mods.branchContains(39);
    }

    public static boolean isPublic(DetailAST aAST) {
        DetailAST mods = aAST.findFirstToken(5);
        return mods != null && mods.branchContains(62);
    }

    public static boolean isStatic(DetailAST aAST) {
        DetailAST mods = aAST.findFirstToken(5);
        return mods != null && mods.branchContains(64);
    }

    public static boolean isVoid(DetailAST aAST) {
        DetailAST type = aAST.findFirstToken(13);
        return type != null && type.branchContains(49);
    }

    public static boolean hasImplements(DetailAST aAST, String aInterface) {
        String shortName = com.puppycrawl.tools.checkstyle.api.Utils.baseClassname(aInterface);
        DetailAST implementsAST = aAST.findFirstToken(19);
        if (implementsAST != null) {
            for (DetailAST child = (DetailAST)implementsAST.getFirstChild(); child != null; child = (DetailAST)child.getNextSibling()) {
                String name;
                if (child.getType() != 58 && child.getType() != 59 || !(name = Utils.constructDottedName(child)).equals(aInterface) && !name.equals(shortName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasExtends(DetailAST aAST, String aClassOrInterface) {
        String shortName = com.puppycrawl.tools.checkstyle.api.Utils.baseClassname(aClassOrInterface);
        DetailAST extendsAST = aAST.findFirstToken(18);
        if (extendsAST != null) {
            for (DetailAST child = (DetailAST)extendsAST.getFirstChild(); child != null; child = (DetailAST)child.getNextSibling()) {
                String name;
                if (child.getType() != 58 && child.getType() != 59 || !(name = Utils.constructDottedName(child)).equals(aClassOrInterface) && !name.equals(shortName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasThrows(DetailAST aAST, String aException) {
        String shortName = com.puppycrawl.tools.checkstyle.api.Utils.baseClassname(aException);
        DetailAST throwsAST = aAST.findFirstToken(81);
        if (throwsAST != null) {
            for (DetailAST child = (DetailAST)throwsAST.getFirstChild(); child != null; child = (DetailAST)child.getNextSibling()) {
                String name;
                if (child.getType() != 58 && child.getType() != 59 || !(name = Utils.constructDottedName(child)).equals(aException) && !name.equals(shortName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPublicMethod(DetailAST aAST, String aName, boolean aIsVoid, int aParameterCount) {
        DetailAST parameters;
        String name;
        DetailAST nameNode = aAST.findFirstToken(58);
        return nameNode != null && (name = nameNode.getText()).equals(aName) && Utils.isPublic(aAST) && Utils.isVoid(aAST) == aIsVoid && (parameters = aAST.findFirstToken(20)).getChildCount() == aParameterCount;
    }

    public static boolean isPublicMethod(DetailAST aAST, String aName, boolean aIsVoid) {
        String name;
        DetailAST nameNode = aAST.findFirstToken(58);
        return nameNode != null && (name = nameNode.getText()).equals(aName) && Utils.isPublic(aAST) && Utils.isVoid(aAST) == aIsVoid;
    }

    public static boolean isPublicMethod(DetailAST aAST, String aName) {
        String name;
        DetailAST nameNode = aAST.findFirstToken(58);
        return nameNode != null && (name = nameNode.getText()).equals(aName) && Utils.isPublic(aAST);
    }

    public static String constructDottedName(DetailAST aAST) {
        String result;
        if (aAST.getType() == 59) {
            DetailAST left = (DetailAST)aAST.getFirstChild();
            DetailAST right = (DetailAST)left.getNextSibling();
            result = Utils.constructDottedName(left) + "." + Utils.constructDottedName(right);
        } else {
            result = aAST.getText();
        }
        return result;
    }

    public static boolean sameParameters(DetailAST aMethodAST1, DetailAST aMethodAST2) {
        DetailAST params1 = aMethodAST1.findFirstToken(20);
        DetailAST params2 = aMethodAST2.findFirstToken(20);
        if (params1.getChildCount() != params2.getChildCount()) {
            return false;
        }
        DetailAST param1 = (DetailAST)params1.getFirstChild();
        DetailAST param2 = (DetailAST)params2.getFirstChild();
        while (param1 != null) {
            DetailAST type2;
            DetailAST type1;
            if (param1.getType() == 21 && param2.getType() == 21 && !Utils.equalTypes(type1 = param1.findFirstToken(13), type2 = param2.findFirstToken(13))) {
                return false;
            }
            param1 = (DetailAST)param1.getNextSibling();
            param2 = (DetailAST)param2.getNextSibling();
        }
        return true;
    }

    public static boolean equalTypes(DetailAST aTypeAST1, DetailAST aTypeAST2) {
        DetailAST child1 = (DetailAST)aTypeAST1.getFirstChild();
        DetailAST child2 = (DetailAST)aTypeAST2.getFirstChild();
        String name1 = Utils.constructDottedName(child1);
        String name2 = Utils.constructDottedName(child2);
        return name1.equals(name2);
    }
}

