/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.plugins.bluej;

import bluej.extensions.BClass;
import bluej.extensions.BPackage;
import bluej.extensions.BProject;
import bluej.extensions.BlueJ;
import bluej.extensions.ClassNotFoundException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import com.puppycrawl.tools.checkstyle.plugins.bluej.AuditFrame;
import com.puppycrawl.tools.checkstyle.plugins.bluej.BlueJPropertiesAdapter;
import java.awt.Frame;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BlueJManager {
    private static BlueJManager sInstance = null;
    private static final String CONFIG_FILE_NAME_KEY = "checkstyle.configfile";
    private static final String PROPS_FILE_NAME_KEY = "checkstyle.propsfile";
    private static final String IS_OPEN_KEY = "checkstyle.frameisopen";
    private static final String FRAME_DIMENSIONS = "checkstyle.framedimensions";
    private static final String DEFAULT_CONFIG_FILE = "default_checks.xml";
    private BlueJ mBlueJ = null;
    private Set<String> mMissingResources = new HashSet<String>();
    private BlueJPropertiesAdapter mBlueJProperties;
    private static final int FRAME_OFFSET = 20;

    public static synchronized BlueJManager getInstance() {
        if (sInstance == null) {
            sInstance = new BlueJManager();
        }
        return sInstance;
    }

    private BlueJManager() {
    }

    public void setBlueJ(BlueJ aBlueJ) {
        this.mBlueJ = aBlueJ;
        if (this.mBlueJProperties != null) {
            this.mBlueJProperties.setBlueJ(aBlueJ);
        }
    }

    public Set<BClass> getBClasses() throws ProjectNotOpenException, PackageNotFoundException {
        HashSet<BClass> result = new HashSet<BClass>();
        BProject[] projects = this.mBlueJ.getOpenProjects();
        for (int i = 0; i < projects.length; ++i) {
            result.addAll(this.getBClasses(projects[i]));
        }
        return result;
    }

    public Set<File> getFiles() throws ClassNotFoundException, ProjectNotOpenException, PackageNotFoundException {
        HashSet<File> result = new HashSet<File>();
        Set<BClass> classes = this.getBClasses();
        for (BClass theClass : classes) {
            BPackage thePackage = theClass.getPackage();
            BProject theProject = thePackage.getProject();
            String projectDirName = theProject.getDir().toString().replaceAll("\\\\", "/");
            String className = theClass.getJavaClass().getName();
            className = className.replaceAll("\\.", "/");
            String fullName = projectDirName + "/" + className + ".java";
            File file = new File(fullName);
            if (!file.exists()) continue;
            result.add(file);
        }
        return result;
    }

    public Set<BClass> getBClasses(BProject aProject) throws ProjectNotOpenException, PackageNotFoundException {
        HashSet<BClass> result = new HashSet<BClass>();
        BPackage[] packages = aProject.getPackages();
        for (int i = 0; i < packages.length; ++i) {
            result.addAll(this.getBClasses(packages[i]));
        }
        return result;
    }

    public Set<BClass> getBClasses(BPackage aPackage) throws ProjectNotOpenException, PackageNotFoundException {
        BClass[] classes = aPackage.getClasses();
        HashSet<BClass> result = new HashSet<BClass>(classes.length);
        for (int i = 0; i < classes.length; ++i) {
            result.add(classes[i]);
        }
        return result;
    }

    public Frame getCurrentFrame() {
        try {
            return this.mBlueJ.getCurrentPackage().getFrame();
        }
        catch (Exception e) {
            return this.mBlueJ.getCurrentFrame();
        }
    }

    public Properties properties() {
        if (this.mBlueJProperties == null) {
            this.mBlueJProperties = new BlueJPropertiesAdapter(this.mBlueJ, System.getProperties());
        }
        return this.mBlueJProperties;
    }

    public InputStream getConfigStream() {
        return this.getResourceStream(this.mBlueJ.getExtensionPropertyString(CONFIG_FILE_NAME_KEY, DEFAULT_CONFIG_FILE), DEFAULT_CONFIG_FILE, "checkstyle configuration file");
    }

    public InputStream getPropertyStream() {
        return this.getResourceStream(this.mBlueJ.getExtensionPropertyString(PROPS_FILE_NAME_KEY, null), null, null);
    }

    private InputStream getResourceStream(String name, String defaultName, String description) {
        InputStream result = null;
        if (name != null && !name.equals("") && (result = this.getResourceStream(name)) == null && defaultName != null && description != null) {
            this.missingResourceMessage(name, defaultName, description);
        }
        if (result == null && defaultName != null && !defaultName.equals(name) && (result = this.getResourceStream(defaultName)) == null) {
            this.missingResourceMessage(defaultName, null, description);
        }
        return result;
    }

    private void missingResourceMessage(String name, String defaultName, String description) {
        if (!this.mMissingResources.contains(name)) {
            if (description == null) {
                description = "resource";
            }
            JOptionPane.showMessageDialog(this.getCurrentFrame(), "Cannot find specified " + description + ":\n" + "  \"" + name + "\"\nas a file, on the classpath, " + "or as a URL." + (defaultName != null ? "\nUsing default: " + defaultName : "") + ".", "Checkstyle Extension", 2);
            this.mMissingResources.add(name);
        }
    }

    private InputStream getResourceStream(String resourceLocation) {
        if (resourceLocation == null || resourceLocation.equals("")) {
            return null;
        }
        try {
            File file = new File(resourceLocation);
            if (!file.exists()) {
                file = new File(this.mBlueJ.getSystemLibDir(), resourceLocation);
            }
            if (!file.exists()) {
                file = new File(this.mBlueJ.getSystemLibDir() + "/extensions", resourceLocation);
            }
            if (file.exists()) {
                return new FileInputStream(file);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            return this.getClass().getClassLoader().getResource(resourceLocation).openStream();
        }
        catch (Exception e) {
            try {
                return new URL(resourceLocation).openStream();
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public String getConfigFileName() {
        return this.mBlueJ.getExtensionPropertyString(CONFIG_FILE_NAME_KEY, null);
    }

    public String getPropsFileName() {
        return this.mBlueJ.getExtensionPropertyString(PROPS_FILE_NAME_KEY, null);
    }

    public void saveConfigFileName(String aName) {
        String old = this.mBlueJ.getExtensionPropertyString(CONFIG_FILE_NAME_KEY, null);
        if (old != null && !old.equals("")) {
            this.mMissingResources.remove(old);
        }
        this.mBlueJ.setExtensionPropertyString(CONFIG_FILE_NAME_KEY, aName);
    }

    public void savePropsFileName(String aName) {
        String old = this.mBlueJ.getExtensionPropertyString(PROPS_FILE_NAME_KEY, null);
        if (old != null && !old.equals("")) {
            this.mMissingResources.remove(old);
        }
        this.mBlueJ.setExtensionPropertyString(PROPS_FILE_NAME_KEY, aName);
    }

    public void initAuditFrame(AuditFrame aFrame) {
        String frameDimensions = this.mBlueJ.getExtensionPropertyString(FRAME_DIMENSIONS, "");
        if (!frameDimensions.equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(frameDimensions);
            int x = Integer.parseInt(tokenizer.nextToken());
            int y = Integer.parseInt(tokenizer.nextToken());
            aFrame.setLocation(x, y);
        } else {
            Frame bluejFrame = this.getCurrentFrame();
            Point corner = new Point(0, 0);
            if (bluejFrame != null) {
                corner = bluejFrame.getLocation();
            }
            corner.translate(20, 20);
            aFrame.setLocation(corner);
        }
        if (Boolean.valueOf(this.mBlueJ.getExtensionPropertyString(IS_OPEN_KEY, "false")).booleanValue()) {
            aFrame.setVisible(true);
        }
    }

    public void saveAuditFrame(AuditFrame aFrame) {
        this.mBlueJ.setExtensionPropertyString(IS_OPEN_KEY, "" + aFrame.isShowing());
        String frameDimensions = (int)aFrame.getLocation().getX() + " " + (int)aFrame.getLocation().getY() + " " + (int)aFrame.getSize().getWidth() + " " + (int)aFrame.getSize().getHeight();
        this.mBlueJ.setExtensionPropertyString(FRAME_DIMENSIONS, frameDimensions);
    }
}

