/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.plugins.bluej;

import bluej.extensions.BlueJ;
import bluej.extensions.Extension;
import bluej.extensions.MenuGenerator;
import bluej.extensions.PreferenceGenerator;
import bluej.extensions.event.ApplicationEvent;
import bluej.extensions.event.ApplicationListener;
import bluej.extensions.event.CompileEvent;
import bluej.extensions.event.CompileListener;
import bluej.extensions.event.PackageEvent;
import bluej.extensions.event.PackageListener;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.plugins.bluej.AuditFrame;
import com.puppycrawl.tools.checkstyle.plugins.bluej.Auditor;
import com.puppycrawl.tools.checkstyle.plugins.bluej.BlueJChecker;
import com.puppycrawl.tools.checkstyle.plugins.bluej.BlueJManager;
import com.puppycrawl.tools.checkstyle.plugins.bluej.ExtensionMenu;
import com.puppycrawl.tools.checkstyle.plugins.bluej.FilesChangeListener;
import com.puppycrawl.tools.checkstyle.plugins.bluej.Preferences;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;

public class CheckstyleExtension
extends Extension {
    private boolean mInitialized = false;
    private LogFactory mLogFactory;
    private static final int AUDIT_CHECK_INTERVAL = 2000;
    private static CheckstyleExtension sInstance;
    private Timer mTimer;
    private ExtensionMenu mMenu;
    private AuditFrame mFrame = null;
    private Set<File> mCompilingFiles = new HashSet<File>();
    private static final String NAME = "Checkstyle";
    private static final String DESCRIPTION = "Checks that Java source code adheres to a coding standard.";
    private static final String VERSION = "4.3-0";
    private static final String URL = "http://bluejcheckstyle.sourceforge.net/";

    public static CheckstyleExtension getInstance() {
        return sInstance;
    }

    public CheckstyleExtension() {
        sInstance = this;
        FilesChangeListener listener = new FilesChangeListener();
        this.mTimer = new Timer(2000, listener);
        try {
            this.mLogFactory = LogFactory.getFactory();
            this.mInitialized = true;
        }
        catch (LogConfigurationException e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
            e.printStackTrace();
        }
    }

    private void updateTimer() {
        if (this.mCompilingFiles.isEmpty() && this.mFrame.isShowing()) {
            this.mTimer.start();
        } else {
            this.mTimer.stop();
        }
    }

    public boolean isCompatible() {
        return true;
    }

    public void startup(BlueJ aBlueJ) {
        BlueJManager.getInstance().setBlueJ(aBlueJ);
        aBlueJ.addApplicationListener((ApplicationListener)new CheckstyleApplicationListener());
        aBlueJ.addPackageListener((PackageListener)new CheckstylePackageListener());
        aBlueJ.addCompileListener((CompileListener)new CheckstyleCompileListener());
        this.mMenu = new ExtensionMenu();
        aBlueJ.setMenuGenerator((MenuGenerator)this.mMenu);
        Preferences myPreferences = new Preferences();
        aBlueJ.setPreferenceGenerator((PreferenceGenerator)myPreferences);
        this.mTimer.start();
    }

    public void terminate() {
        BlueJManager.getInstance().saveAuditFrame(this.mFrame);
        this.mCompilingFiles.clear();
        this.mTimer.stop();
    }

    public void refreshView() {
        if (this.mFrame.isShowing()) {
            Auditor auditor;
            BlueJChecker checker = new BlueJChecker();
            try {
                auditor = checker.processAllFiles();
            }
            catch (CheckstyleException ex) {
                this.error(ex);
                return;
            }
            this.viewAudit(auditor);
        }
    }

    private synchronized void buildAuditFrame() {
        if (this.mFrame == null) {
            this.mFrame = new AuditFrame();
            final class AuditFrameListener
            extends WindowAdapter {
                AuditFrameListener() {
                }

                public void windowOpened(WindowEvent aEvent) {
                    CheckstyleExtension.this.updateTimer();
                }

                public void windowClosed(WindowEvent aEvent) {
                    CheckstyleExtension.this.updateTimer();
                }

                public void windowIconified(WindowEvent aEvent) {
                    CheckstyleExtension.this.updateTimer();
                }

                public void windowDeiconified(WindowEvent aEvent) {
                    CheckstyleExtension.this.updateTimer();
                }
            }
            this.mFrame.addWindowListener(new AuditFrameListener());
            BlueJManager.getInstance().initAuditFrame(this.mFrame);
            this.mFrame.pack();
        }
    }

    public void showAuditFrame() {
        this.buildAuditFrame();
        this.mFrame.setVisible(true);
        this.refreshView();
    }

    public synchronized void viewAudit(final Auditor aAuditor) {
        Runnable update = new Runnable(){

            public void run() {
                if (CheckstyleExtension.this.mFrame != null) {
                    CheckstyleExtension.this.mFrame.setAuditor(aAuditor);
                }
            }
        };
        SwingUtilities.invokeLater(update);
    }

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getVersion() {
        return VERSION;
    }

    public URL getURL() {
        URL result = null;
        try {
            result = new URL(URL);
        }
        catch (MalformedURLException e) {
            this.error(e);
        }
        return result;
    }

    public void error(String aMessage) {
        Frame frame = BlueJManager.getInstance().getCurrentFrame();
        JOptionPane.showMessageDialog(frame, aMessage);
        if (this.mInitialized) {
            Log log = this.mLogFactory.getInstance(CheckstyleExtension.class);
            log.info(aMessage);
        } else {
            System.out.println(aMessage);
        }
    }

    public void error(Exception aException) {
        aException.printStackTrace();
        this.error("" + aException);
    }

    private class CheckstyleApplicationListener
    implements ApplicationListener {
        private CheckstyleApplicationListener() {
        }

        public void blueJReady(ApplicationEvent aEvent) {
            CheckstyleExtension.this.buildAuditFrame();
            CheckstyleExtension.this.refreshView();
        }
    }

    private class CheckstyleCompileListener
    implements CompileListener {
        private CheckstyleCompileListener() {
        }

        public void compileStarted(CompileEvent aEvent) {
            this.recordCompileStart(aEvent.getFiles());
        }

        private void recordCompileStart(File[] aFiles) {
            for (int i = 0; i < aFiles.length; ++i) {
                CheckstyleExtension.this.mCompilingFiles.add(aFiles[i]);
            }
            CheckstyleExtension.this.updateTimer();
        }

        public void compileError(CompileEvent aEvent) {
            this.recordCompileEnd(aEvent.getFiles());
        }

        private void recordCompileEnd(File[] aFiles) {
            for (int i = 0; i < aFiles.length; ++i) {
                CheckstyleExtension.this.mCompilingFiles.remove(aFiles[i]);
            }
            CheckstyleExtension.this.updateTimer();
        }

        public void compileWarning(CompileEvent aEvent) {
            this.recordCompileEnd(aEvent.getFiles());
        }

        public void compileSucceeded(CompileEvent aEvent) {
            this.recordCompileEnd(aEvent.getFiles());
            if (CheckstyleExtension.this.mCompilingFiles.isEmpty()) {
                CheckstyleExtension.this.refreshView();
            }
        }

        public void compileFailed(CompileEvent aEvent) {
            this.recordCompileEnd(aEvent.getFiles());
        }
    }

    private class CheckstylePackageListener
    implements PackageListener {
        private CheckstylePackageListener() {
        }

        public void packageOpened(PackageEvent aEvent) {
        }

        public void packageClosing(PackageEvent aEvent) {
        }
    }
}

