import java.awt.geom.Ellipse2D;

/**
 * Ein Kreis, der manipuliert werden kann und sich selbst auf einer
 * Leinwand zeichnet.
 * 
 * @author  Michael Klling und David J. Barnes
 * @version 1.0  (3. Januar 2003)
 * 
 * Gendert und vereinfacht
 *          Dieter Bergmann (info@DieterBergmann.de)
 *          2007-12-20
 */

public class Kreis
{
  private int durchmesser;
  private int xPosition;
  private int yPosition;
  private String farbe;
  private boolean istSichtbar;

  /**
   * Erzeuge einen neuen Kreis mit diesen Parametern.
   */
  public Kreis(int d, int x, int y, String f)
  {
    durchmesser = d;
    xPosition = x;
    yPosition = y;
    farbe = f;
    istSichtbar = false;
  }

  /**
   * Mache diesen Kreis sichtbar.
   * Wenn er bereits sichtbar ist, tue nichts.
   */
  public void sichtbarMachen()
  {
    istSichtbar = true;
    zeichnen();
  }

  /**
   * Mache diesen Kreis unsichtbar.
   * Wenn er bereits unsichtbar ist, tue nichts.
   */
  public void unsichtbarMachen()
  {
    loeschen();
    istSichtbar = false;
  }

  
  /**
   * ndere den Durchmesser dieses Kreises in 'neuerDurchmesser'
   * (Angabe in Bildschirmpunkten).
   * 'neuerDurchmesser' muss grer gleich Null sein.
   */
  public void groesseAendern(int neuerDurchmesser)
  {
    loeschen();
    durchmesser = neuerDurchmesser;
    zeichnen();
  }

  /**
   * ndere die Farbe dieses Kreises in 'neueFarbe'.
   * Gltige Angaben sind "rot", "gelb", "blau", "gruen",
   * "lila" und "schwarz".
   */
  public void farbeAendern(String neueFarbe)
  {
    farbe = neueFarbe;
    zeichnen();
  }

  /*
   * Zeichne diesen Kreis mit seinen aktuellen Werten auf den Bildschirm.
   */
  private void zeichnen()
  {
    if (istSichtbar)
    {
      Leinwand leinwand = Leinwand.gibLeinwand();
      leinwand.zeichne(
        this,
        farbe,
        new Ellipse2D.Double(xPosition, yPosition, durchmesser, durchmesser));
      leinwand.warte(10);
    }
  }

  /*
   * Lsche diesen Kreis vom Bildschirm.
   */
  private void loeschen()
  {
    if (istSichtbar)
    {
      Leinwand leinwand = Leinwand.gibLeinwand();
      leinwand.entferne(this);
    }
  }

}
