
/**
 * Schalter stellt eine boolsche Variable zur Verfgung,
 * die ber folgende Methoden manipuliert werden kann:
 * Einschalten: setzt den Wert auf true
 * Ausschalten: setzt den Wert auf false
 * Schalten:    wechselt den Wert
 * 
 * Neuerungen gegenber der Version 2:
 * Der Stand des Schalters wird in einem Fenster visualisiert.
 * 
 * @author   Dieter Bergmann 
 * @version  2007-12-20
 */

public class Schalter
{
    // Instanzvariablen - ersetzen Sie das folgende Beispiel mit Ihren Variablen
    boolean Schalter_ein;
    private Kreis licht;

    /**
     * Konstruktor fr Objekte der Klasse Schalter
     * Ausgangszustand: Der Schalter ist aus
     */
    public Schalter(Kreis k)
    {
        licht = k;
        Schalter_ein = false;
        licht.sichtbarMachen();   // sonst erscheint das leere Fenster nicht
        licht.unsichtbarMachen();
    }

    /**
     * Einschalten
     * Der Schalter steht unabhngig vom Zustand danach auf ein
    */
    public void Einschalten()
    {
        Schalter_ein = true;
        licht.sichtbarMachen();
    }
    
    /**
     * Ausschalten
     * Der Schalter steht unabhngig vom Zustand danach auf aus
    */
    public void Ausschalten()
    {
        Schalter_ein = false;
        licht.unsichtbarMachen();
    }
    
    /**
     * Schalten
     * Der Schalter hat abhngig vom Zustand danach den jeweils anderen Zustand
    */
    public void Schalten()
    {
        if (Schalter_ein) Ausschalten(); else Einschalten();
    }
    
}
