import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

public class AMPEL extends Actor
{
    // Instanzvariablen
    private KREIS    rotesLicht;
    private KREIS    gelbesLicht;
    private KREIS    gruenesLicht;
    private SCHALTER roterSchalter;
    private SCHALTER gelberSchalter;
    private SCHALTER gruenerSchalter;
    private ZAEHLER_ZYKLISCH Zustand;

    /**
     * Konstruktor fr Objekte der Klasse AMPEL
     */
    public AMPEL(int xPos, KREIS r, KREIS y, KREIS g)
    {
        // Instanzvariable initialisieren
        rotesLicht   = r; roterSchalter   = new SCHALTER(rotesLicht);
        gelbesLicht  = y; gelberSchalter  = new SCHALTER(gelbesLicht);
        gruenesLicht = g; gruenerSchalter = new SCHALTER(gruenesLicht);
        Zustand = new ZAEHLER_ZYKLISCH(3);
        Reset();
    }
    
    public void act()
    {
      Schalten();
    }
    
    public void Reset()
    {
       Zustand.Set_Null();
       Anzeigen();
       //rot();
    }
    
    public void rot()
    {
        roterSchalter.Einschalten();
        gelberSchalter.Ausschalten();
        gruenerSchalter.Ausschalten();
    }
    
    public void rot_gelb()
    {
        roterSchalter.Einschalten();
        gelberSchalter.Einschalten();
        gruenerSchalter.Ausschalten();
    }

    public void gruen()
    {
        roterSchalter.Ausschalten();
        gelberSchalter.Ausschalten();
        gruenerSchalter.Einschalten();
    }
    
    public void gelb()
    {
        roterSchalter.Ausschalten();
        gelberSchalter.Einschalten();
        gruenerSchalter.Ausschalten();
    }
    
    public void alleEinschalten()
    {
        roterSchalter.Einschalten();
        gelberSchalter.Einschalten();
        gruenerSchalter.Einschalten();
    }
    
    public void alleAusschalten()
    {
        roterSchalter.Ausschalten();
        gelberSchalter.Ausschalten();
        gruenerSchalter.Ausschalten();
    }
    
    public void Schalten()
    {
       Zustand.Zaehlen();
       Anzeigen();
    }
    
    private void Anzeigen()
    {
        if (Zustand.Get_Zaehlerstand() == 0) {rot();};
        if (Zustand.Get_Zaehlerstand() == 1) {rot_gelb();};
        if (Zustand.Get_Zaehlerstand() == 2) {gruen();};
        if (Zustand.Get_Zaehlerstand() == 3) {gelb();};
    }
    
}
