import java.awt.*;
import java.awt.Graphics.*;
import java.awt.event.*;
import javax.swing.event.ChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.*;

/**
  * Stellt eine Komponente zur Verfgung, auf der ein Kreis gezeichnet werden kann
  *
  * @version 0.1
  * @author D. Bergmann
  */

public class Kreis extends JComponent
{
  // Instanzvariablen
  int mx, my, r;              // Mittelpunkt und Radius
  Color Farbe, Randfarbe;     // Farben
  String f;                   // Farbname in deutsch als String
  int Randbreite;             // ..
  boolean sichtbar;           // Sichtbarkeit des Kreises
  
  /**
   * Konstruktor ohne Parameter
   */
  public Kreis() 
  {
    mx = getWidth()/2; my = getHeight()/2; r = 50;
    Farbe      = Color.white; f = "wei";
    Randfarbe  = Color.black;
    Randbreite = 1;
    sichtbar   = true;
  }
  
  /**
   * Konstruktor mit Mittelpunkt, Radius und Farbe
   */
  public Kreis(int mx, int my, int r, String Farbe) 
  {
    this.mx = mx; this.my = my; this.r = r; this.Farbe = Farbe2Java(Farbe); this.f = Farbe;
    Randfarbe  = Color.black;
    Randbreite = 1;
    sichtbar   = true;
  }
    
  public void setMittelpunkt(int mx, int my)
  {
    this.mx = mx; this.my = my;
    repaint();
  }
    
  public void setRadius(int r)
  {
    this.r = r;
    repaint();
  }
  
  public void setSichtbar()
  {
    sichtbar = true;
    setVisible(sichtbar);
  }
  
  public void setUnsichtbar()
  {
    sichtbar = false;
    setVisible(sichtbar);
  }
  
  public boolean getSichtbarkeit()
  {
    return sichtbar;
  }
  
  public void setFarbe(String Farbe)
  {
    this.Farbe = Farbe2Java(Farbe); this.f = Farbe;
    repaint();
  }
  
  public String getFarbe()
  {
    return f;
  }
  
  public void setRandfarbe(String Randfarbe)
  {
    this.Randfarbe = Farbe2Java(Randfarbe);
    repaint();
  }
  
  public void setRandbreite(int Randbreite)
  {
    this.Randbreite = Randbreite;
    repaint();
  }
    
  public void paint(Graphics g)
  {
    Graphics2D g2d = (Graphics2D) g;
    g2d.setStroke(new BasicStroke(Randbreite));
    g2d.setColor(Randfarbe);
    g2d.drawOval(mx-r+Randbreite, my-r+Randbreite, 2*r, 2*r);
    g2d.setColor(Farbe); 
    g2d.fillOval(mx-r+Randbreite, my-r+Randbreite, 2*r, 2*r);
  }
  
  private Color Farbe2Java(String f)
  { 
    if (f.equals("schwarz"))    return Color.black;
    if (f.equals("gelb"))       return Color.yellow;
    if (f.equals("blau"))       return Color.blue;
    if (f.equals("rot"))        return Color.red;
    if (f.equals("wei"))       return Color.white;
    if (f.equals("grn"))       return Color.green;
    if (f.equals("zyan"))       return Color.cyan;
    if (f.equals("dunkelgrau")) return Color.darkGray;
    if (f.equals("grau"))       return Color.gray;
    if (f.equals("hellgrau"))   return Color.lightGray;
    if (f.equals("magenta"))    return Color.magenta;
    if (f.equals("orange"))     return Color.orange;
    if (f.equals("pink"))       return Color.pink;
    return Color.black;
  }
    
}
