/**
 * Verkehrsampel
 * @author  Dieter Bergmann (info@DieterBergmann.de)
 * @version 2007-12-20
 */
public class Ampel
{
    // Instanzvariablen - erzeugt die drei Lichter und die drei Schalter
    private Kreis     rotesLicht;
    private Kreis     gelbesLicht;
    private Kreis     gruenesLicht;
    private Schalter  roterSchalter;
    private Schalter  gelberSchalter;
    private Schalter  gruenerSchalter;
    private int Zustand;

    /**
     *  Konstruktor fr Objekte der Klasse Schalter
     */
    public Ampel()
    {
        // Instanzvariablen initialisieren
        rotesLicht      = new Kreis(60, 120, 20, "rot");
        gelbesLicht     = new Kreis(60, 120, 100, "gelb");
        gruenesLicht    = new Kreis(60, 120, 180, "gruen");
        roterSchalter   = new Schalter(rotesLicht);
        gelberSchalter  = new Schalter(gelbesLicht);
        gruenerSchalter = new Schalter(gruenesLicht);
        Zustand = 1;
    }

    /**
     *  alle Lichter einschalten
     */
    public void alleEinschalten()
    {
        // alle Lichter sichtbar machen
        roterSchalter.Einschalten();
        gelberSchalter.Einschalten();
        gruenerSchalter.Einschalten();
    }
    
    /**
     *  alle Lichter ausschalten
     */
    public void alleAusschalten()
    {
        // alle Lichter unsichtbar machen
        roterSchalter.Ausschalten();
        gelberSchalter.Ausschalten();
        gruenerSchalter.Ausschalten();
    }
    
     /**
     *   Ampel starten, rotes Licht an
     */
    public void Start()
    {
       // rotes Licht an, Zustand wird auf 1 weitergeschaltet
       Zustand = 1;
       Schalten();
    }
    
    /**
     *   Ampel in nchste Phase weiterschalten
    */
    public void Schalten()
    {
       if (Zustand == 1) {roterSchalter.Einschalten();
                          gelberSchalter.Ausschalten();
                          gruenerSchalter.Ausschalten();};
       if (Zustand == 2) {roterSchalter.Einschalten();
                          gelberSchalter.Einschalten();
                          gruenerSchalter.Ausschalten();};
       if (Zustand == 3) {roterSchalter.Ausschalten();
                          gelberSchalter.Ausschalten();
                          gruenerSchalter.Einschalten();};
       if (Zustand == 4) {roterSchalter.Ausschalten();
                          gelberSchalter.Einschalten();
                          gruenerSchalter.Ausschalten();};
       if (Zustand == 4) {Zustand = 1;} else {Zustand++;};
    }
    
}
