/**
 * Schalter stellt eine boolsche Variable zur Verfgung,
 * die ber folgende Methoden manipuliert werden kann:
 * Einschalten: setzt den Wert auf true
 * Ausschalten: setzt den Wert auf false
 * Schalten:    wechselt den Wert
 * 
 * Neuerungen gegenber der Version 03:
 * Der Stand des Schalters wird in einem Fenster visualisiert.
 * 
 * @author   Dieter Bergmann 
 * @version  2008-05-24
 */

public class SCHALTER      
{    
    private boolean Schalter_ein;   // Instanzvarable fr den Zustand
    private KREIS   Licht;          // Variable zur Visualsierung
    
    /**
     * Konstruktor fr Objekte der Klasse Schalter
     * Ausgangszustand: Der Schalter ist aus
     * @param Objekt der Klasse Kreis, dient zur Visualisierung
     */
    public SCHALTER(KREIS k)
    {
        Schalter_ein = false;       // Startzustand setzen
        Licht = k;                  // Speichern des Objektes zur Visualisierung
        Licht.sichtbarMachen();     // sonst erscheint das leere Fenster nicht
        Licht.unsichtbarMachen();   // gewnschter Anfangszustand
    }
   
    /**
     * Einschalten
     * Der Schalter steht unabhngig vom Zustand danach auf ein
    */
    public void Einschalten()
    {
        Schalter_ein = true;
        Protokoll("Einschalten");
    }
    
    /**
     * Ausschalten
     * Der Schalter steht unabhngig vom Zustand danach auf aus
    */
    public void Ausschalten()
    {
        Schalter_ein = false;
        Protokoll("Ausschalten");
    } 
    
    
    public boolean Get_Schalterstellung()
    {
        return Schalter_ein;
    }
    
    /**
     * Umschalten
     * Der Schalter hat ABHNGIG vom Zustand danach den jeweils anderen Zustand
    */
    public void Umschalten()
    {
        Protokoll("Umschalten");
        if (Get_Schalterstellung()) {Ausschalten();} else {Einschalten();};
    }
    
    private void Protokoll(String gerufen_von)
    {
        if (Get_Schalterstellung()) {Licht.sichtbarMachen();}
                               else {Licht.unsichtbarMachen();};
     }
                            
    
}